/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.render.renderer;

import com.seibel.distanthorizons.api.enums.config.EDhApiGpuUploadMethod;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.logging.DhLogger;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.render.glObject.buffer.GLVertexBuffer;
import com.seibel.distanthorizons.core.render.glObject.shader.ShaderProgram;
import com.seibel.distanthorizons.core.render.glObject.vertexAttribute.AbstractVertexAttribute;
import com.seibel.distanthorizons.core.render.glObject.vertexAttribute.VertexPointer;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftGLWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftRenderWrapper;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.lwjgl.opengl.GL32;

public class TestRenderer {
    public static final DhLogger LOGGER = new DhLoggerBuilder().build();
    private static final IMinecraftRenderWrapper MC_RENDER = SingletonInjector.INSTANCE.get(IMinecraftRenderWrapper.class);
    private static final IMinecraftGLWrapper GLMC = SingletonInjector.INSTANCE.get(IMinecraftGLWrapper.class);
    ShaderProgram basicShader;
    GLVertexBuffer vbo;
    AbstractVertexAttribute va;
    boolean init = false;
    private static final float[] vertices = new float[]{-0.5f, -0.5f, 0.0f, 0.0f, 0.0f, 1.0f, 0.4f, -0.4f, 1.0f, 0.0f, 0.0f, 1.0f, 0.3f, 0.3f, 1.0f, 1.0f, 0.0f, 0.0f, -0.2f, 0.2f, 0.0f, 1.0f, 1.0f, 1.0f};

    public void init() {
        if (this.init) {
            return;
        }
        LOGGER.info("init", new Object[0]);
        this.init = true;
        this.va = AbstractVertexAttribute.create();
        this.va.bind();
        this.va.setVertexAttribute(0, 0, VertexPointer.addVec2Pointer(false));
        this.va.setVertexAttribute(0, 1, VertexPointer.addVec4Pointer(false));
        this.va.completeAndCheck(24);
        this.basicShader = new ShaderProgram("shaders/test/vert.vert", "shaders/test/frag.frag", "fragColor", new String[]{"vPosition", "color"});
        this.createBuffer();
    }

    private void createBuffer() {
        ByteBuffer buffer = ByteBuffer.allocateDirect(vertices.length * 4);
        buffer.order(ByteOrder.nativeOrder());
        buffer.asFloatBuffer().put(vertices);
        buffer.rewind();
        this.vbo = new GLVertexBuffer(false);
        this.vbo.bind();
        this.vbo.uploadBuffer(buffer, 4, EDhApiGpuUploadMethod.DATA, vertices.length * 4);
    }

    public void render() {
        this.init();
        GLMC.glBindFramebuffer(36160, MC_RENDER.getTargetFramebuffer());
        GL32.glViewport((int)0, (int)0, (int)MC_RENDER.getTargetFramebufferViewportWidth(), (int)MC_RENDER.getTargetFramebufferViewportHeight());
        GL32.glPolygonMode((int)1032, (int)6914);
        GLMC.disableFaceCulling();
        GLMC.disableDepthTest();
        GLMC.disableBlend();
        GLMC.disableScissorTest();
        this.basicShader.bind();
        this.va.bind();
        this.vbo.bind();
        this.va.bindBufferToAllBindingPoints(this.vbo.getId());
        GL32.glDrawArrays((int)6, (int)0, (int)4);
        GL32.glClear((int)256);
    }
}

