/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.network;

import com.supermartijn642.core.CoreLib;
import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.core.network.PacketContext;
import com.supermartijn642.core.network.PacketDirection;
import com.supermartijn642.core.registry.RegistryUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.PacketListener;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class PacketChannel {
    private final String modid;
    private final String name;
    private final ResourceLocation channelName;
    private final SimpleChannel channel;
    private final List<PacketProperties<?>> packetsByIndex = new ArrayList();
    private final Map<Class<? extends BasePacket>, PacketProperties<?>> packetsByClass = new HashMap();

    public static PacketChannel create(String modid, String channelName) {
        if (!RegistryUtil.isValidNamespace(modid)) {
            throw new IllegalArgumentException("Modid '" + modid + "' must only contain characters [a-z0-9_.-]!");
        }
        if (!RegistryUtil.isValidNamespace(channelName)) {
            throw new IllegalArgumentException("Channel name '" + channelName + "' must only contain characters [a-z0-9_.-]!");
        }
        String activeMod = ModLoadingContext.get().getActiveNamespace();
        if (activeMod != null && !activeMod.equals("minecraft") && !activeMod.equals("forge")) {
            if (!activeMod.equals(modid)) {
                CoreLib.LOGGER.warn("Mod '{}' is creating a packet channel for different modid '{}'!", (Object)ModLoadingContext.get().getActiveContainer().getModInfo().getDisplayName(), (Object)modid);
            }
        } else if (modid.equals("minecraft") || modid.equals("forge")) {
            CoreLib.LOGGER.warn("Mod is creating a packet channel for modid '{}'!", (Object)modid);
        }
        return new PacketChannel(modid, channelName);
    }

    public static PacketChannel create(String modid) {
        return PacketChannel.create(modid, "main");
    }

    @Deprecated
    public static PacketChannel create() {
        return PacketChannel.create(ModLoadingContext.get().getActiveNamespace(), "main");
    }

    private PacketChannel(String modid, String name) {
        this.modid = modid;
        this.name = name;
        this.channel = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation(modid, name), () -> "1", "1"::equals, "1"::equals);
        this.channelName = new ResourceLocation(modid, name);
        this.channel.messageBuilder(Payload.class, 0).encoder((payload, buffer) -> this.write(payload.packet, (FriendlyByteBuf)buffer)).decoder(buffer -> new Payload(this.read((FriendlyByteBuf)buffer))).consumerNetworkThread((payload, contextSupplier) -> {
            NetworkEvent.Context context = (NetworkEvent.Context)contextSupplier.get();
            context.setPacketHandled(true);
            this.handle(payload.packet, new PacketContext(context), context.getDirection().getReceptionSide().isClient() ? PacketDirection.SERVER_TO_CLIENT : PacketDirection.CLIENT_TO_SERVER);
        }).add();
    }

    public <T extends BasePacket> void registerMessage(Class<T> packetClass, Supplier<T> packetSupplier, PacketDirection direction, boolean shouldBeQueued) {
        if (this.packetsByClass.containsKey(packetClass)) {
            throw new IllegalArgumentException("Class '" + packetClass + "' has already been registered!");
        }
        int index = this.packetsByIndex.size();
        PacketProperties<T> properties = new PacketProperties<T>(index, packetClass, packetSupplier, direction, shouldBeQueued);
        this.packetsByIndex.add(properties);
        this.packetsByClass.put(packetClass, properties);
    }

    @Deprecated
    public <T extends BasePacket> void registerMessage(Class<T> packetClass, Supplier<T> packetSupplier, boolean shouldBeQueued) {
        this.registerMessage(packetClass, packetSupplier, PacketDirection.BOTH_WAYS, shouldBeQueued);
    }

    public void sendToServer(BasePacket packet) {
        this.checkRegistration(packet, PacketDirection.CLIENT_TO_SERVER);
        this.channel.sendToServer((Object)new Payload(packet));
    }

    public void sendToClient(Connection connection, BasePacket packet) {
        this.checkRegistration(packet, PacketDirection.SERVER_TO_CLIENT);
        if (connection.m_178313_() == PacketFlow.CLIENTBOUND) {
            throw new IllegalArgumentException("This must only be called server-side!");
        }
        PacketListener packetListener = connection.m_129538_();
        if (!(packetListener instanceof ServerGamePacketListenerImpl)) {
            throw new IllegalArgumentException("Cannot send packet during the current network stage!");
        }
        ServerGamePacketListenerImpl listener = (ServerGamePacketListenerImpl)packetListener;
        this.channel.send(PacketDistributor.PLAYER.with(() -> listener.f_9743_), (Object)new Payload(packet));
    }

    public void sendToPlayer(Player player, BasePacket packet) {
        if (!(player instanceof ServerPlayer)) {
            throw new IllegalStateException("This must only be called server-side!");
        }
        this.checkRegistration(packet, PacketDirection.SERVER_TO_CLIENT);
        this.channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new Payload(packet));
    }

    public void sendToAllPlayers(BasePacket packet) {
        this.checkRegistration(packet, PacketDirection.SERVER_TO_CLIENT);
        this.channel.send(PacketDistributor.ALL.noArg(), (Object)new Payload(packet));
    }

    public void sendToDimension(ResourceKey<Level> dimension, BasePacket packet) {
        this.checkRegistration(packet, PacketDirection.SERVER_TO_CLIENT);
        this.channel.send(PacketDistributor.DIMENSION.with(() -> dimension), (Object)new Payload(packet));
    }

    public void sendToDimension(Level world, BasePacket packet) {
        if (world.f_46443_) {
            throw new IllegalStateException("This must only be called server-side!");
        }
        this.sendToDimension((ResourceKey<Level>)world.m_46472_(), packet);
    }

    public void sendToAllTrackingEntity(Entity entity, BasePacket packet) {
        if (entity.m_9236_().f_46443_) {
            throw new IllegalStateException("This must only be called server-side!");
        }
        this.checkRegistration(packet, PacketDirection.SERVER_TO_CLIENT);
        this.channel.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)new Payload(packet));
    }

    public void sendToAllNear(ResourceKey<Level> world, double x, double y, double z, double radius, BasePacket packet) {
        this.checkRegistration(packet, PacketDirection.SERVER_TO_CLIENT);
        this.channel.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(x, y, z, radius, world)), (Object)new Payload(packet));
    }

    public void sendToAllNear(ResourceKey<Level> world, BlockPos pos, double radius, BasePacket packet) {
        this.sendToAllNear(world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, radius, packet);
    }

    public void sendToAllNear(Level world, double x, double y, double z, double radius, BasePacket packet) {
        if (world.f_46443_) {
            throw new IllegalStateException("This must only be called server-side!");
        }
        this.sendToAllNear((ResourceKey<Level>)world.m_46472_(), x, y, z, radius, packet);
    }

    public void sendToAllNear(Level world, BlockPos pos, double radius, BasePacket packet) {
        if (world.f_46443_) {
            throw new IllegalStateException("This must only be called server-side!");
        }
        this.sendToAllNear(world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, radius, packet);
    }

    private void checkRegistration(BasePacket packet, PacketDirection direction) {
        PacketProperties<?> properties = this.packetsByClass.get(packet.getClass());
        if (properties == null) {
            throw new IllegalArgumentException("Tried to send unregistered packet '" + packet.getClass() + "' on channel '" + this.modid + ":" + this.name + "'!");
        }
        if (properties.direction != PacketDirection.BOTH_WAYS && properties.direction != direction) {
            throw new IllegalArgumentException("Tried to send packet '" + packet.getClass() + "' on channel '" + this.modid + ":" + this.name + "' in invalid direction '" + direction + "'!");
        }
    }

    void write(BasePacket packet, FriendlyByteBuf buffer) {
        int index = this.packetsByClass.get(packet.getClass()).index;
        buffer.writeInt(index);
        try {
            packet.write(buffer);
        }
        catch (Exception e) {
            throw new RuntimeException("Encountered an exception whilst writing packet of class '" + packet.getClass().getName() + "' for channel '" + this.modid + ":" + this.name + "'!", e);
        }
    }

    BasePacket read(FriendlyByteBuf buffer) {
        int index = buffer.readInt();
        if (this.packetsByIndex.size() < index) {
            throw new RuntimeException("Received an unregistered packet with index '" + index + "' on channel '" + this.modid + ":" + this.name + "'!");
        }
        PacketProperties<?> properties = this.packetsByIndex.get(index);
        BasePacket packet = (BasePacket)properties.supplier().get();
        try {
            packet.read(buffer);
        }
        catch (Exception e) {
            throw new RuntimeException("Encountered an exception whilst reading packet of class '" + packet.getClass().getName() + "' for channel '" + this.modid + ":" + this.name + "'!", e);
        }
        return packet;
    }

    void handle(BasePacket packet, PacketContext context, PacketDirection direction) {
        PacketProperties<?> properties = this.packetsByClass.get(packet.getClass());
        if (properties.direction != PacketDirection.BOTH_WAYS && properties.direction != direction) {
            throw new RuntimeException("Received packet of class '" + properties.clazz + "' on channel '" + this.modid + ":" + this.name + "' for invalid direction '" + (direction == PacketDirection.CLIENT_TO_SERVER ? PacketDirection.SERVER_TO_CLIENT : PacketDirection.CLIENT_TO_SERVER) + "'!");
        }
        try {
            boolean verify = packet.verify(context);
            if (!verify) {
                return;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Encountered an exception whilst verifying packet of class '" + packet.getClass().getName() + "' for channel '" + this.modid + ":" + this.name + "'!", e);
        }
        Runnable handle = () -> {
            try {
                packet.handle(context);
            }
            catch (Exception e) {
                throw new RuntimeException("Encountered an exception whilst processing packet of class '" + packet.getClass().getName() + "' for channel '" + this.modid + ":" + this.name + "'!", e);
            }
        };
        if (properties.shouldBeQueued) {
            context.queueTask(handle);
        } else {
            handle.run();
        }
    }

    private static class Payload {
        private final BasePacket packet;

        private Payload(BasePacket packet) {
            this.packet = packet;
        }
    }

    private record PacketProperties<T extends BasePacket>(int index, Class<T> clazz, Supplier<T> supplier, PacketDirection direction, boolean shouldBeQueued) {
    }
}

