/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.spelunkery.blocks.nephrite;

import com.ordana.spelunkery.blocks.entity.CarvedNephriteBlockEntity;
import com.ordana.spelunkery.reg.ModEntities;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class CarvedNephriteBlock
extends BaseEntityBlock {
    public static final EnumProperty<ChargeState> CHARGE = EnumProperty.m_61587_((String)"charge", ChargeState.class);

    public CarvedNephriteBlock(BlockBehaviour.Properties properties) {
        super(properties.m_60953_(state -> switch ((ChargeState)((Object)((Object)state.m_61143_(CHARGE)))) {
            default -> throw new IncompatibleClassChangeError();
            case ChargeState.EMPTY -> 0;
            case ChargeState.ONE_TO_TWENTY -> 1;
            case ChargeState.TWENTYONE_TO_FOURTY -> 2;
            case ChargeState.FOURTYONE_TO_SIXTY -> 3;
            case ChargeState.SIXTYONE_TO_EIGHTY -> 4;
            case ChargeState.EIGHTYONE_TO_NINETYNINE -> 5;
            case ChargeState.FULL -> 6;
        }));
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(CHARGE, (Comparable)((Object)ChargeState.EMPTY)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateManager) {
        super.m_7926_(stateManager);
        stateManager.m_61104_(new Property[]{CHARGE});
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        switch ((ChargeState)((Object)state.m_61143_(CHARGE))) {
            default: {
                return 0;
            }
            case ONE_TO_TWENTY: {
                return 2;
            }
            case TWENTYONE_TO_FOURTY: {
                return 5;
            }
            case FOURTYONE_TO_SIXTY: {
                return 8;
            }
            case SIXTYONE_TO_EIGHTY: {
                return 11;
            }
            case EIGHTYONE_TO_NINETYNINE: {
                return 14;
            }
            case FULL: 
        }
        return 15;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new CarvedNephriteBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        if (!level.f_46443_) {
            return CarvedNephriteBlock.m_152132_(blockEntityType, ModEntities.NEPHRITE_TILE.get(), CarvedNephriteBlockEntity::tickBlock);
        }
        return super.m_142354_(level, state, blockEntityType);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity;
        if (level instanceof ServerLevel && (blockEntity = level.m_7702_(pos)) instanceof CarvedNephriteBlockEntity) {
            CarvedNephriteBlockEntity selfTile = (CarvedNephriteBlockEntity)blockEntity;
            this.m_49805_((ServerLevel)level, pos, selfTile.getCharge());
        }
        super.m_5707_(level, pos, state, player);
    }

    public static enum ChargeState implements StringRepresentable
    {
        EMPTY,
        ONE_TO_TWENTY,
        TWENTYONE_TO_FOURTY,
        FOURTYONE_TO_SIXTY,
        SIXTYONE_TO_EIGHTY,
        EIGHTYONE_TO_NINETYNINE,
        FULL;


        public String m_7912_() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

