/*
 * Decompiled with CFR 0.152.
 */
package com.goby56.wakes.config.gui;

import com.goby56.wakes.WakesClient;
import com.goby56.wakes.config.gui.ColorPickerScreen;
import com.goby56.wakes.render.WakeColor;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import ladysnake.satin.api.managed.ManagedCoreShader;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_357;
import net.minecraft.class_6382;
import net.minecraft.class_757;
import org.joml.Matrix4f;
import org.joml.Vector2f;

public class ColorPicker
extends class_339 {
    private static final class_2960 FRAME_TEXTURE = class_2960.method_43902((String)"wakes", (String)"textures/slot_frame.png");
    private static final class_2960 PICKER_KNOB_TEXTURE = class_2960.method_43902((String)"wakes", (String)"textures/picker_knob.png");
    private static final int pickerKnobDim = 7;
    private final Map<String, Bounded> widgets = new HashMap<String, Bounded>();
    private final AABB bounds;
    private Consumer<WakeColor> changedColorListener;
    private final Vector2f pickerPos = new Vector2f();

    public ColorPicker(ColorPickerScreen screenContext, int x, int y, int width, int height) {
        super(x, y, width, height, class_2561.method_30163((String)""));
        this.bounds = new AABB(0.0f, 0.0f, 1.0f, 0.6666667f, x, y, width, height);
        this.widgets.put("hueSlider", new GradientSlider(new AABB(0.0f, 0.6666667f, 1.0f, 0.8333333f, x, y, width, height), "Hue", this, true));
        this.widgets.put("alphaSlider", new GradientSlider(new AABB(0.5f, 0.8333333f, 1.0f, 1.0f, x, y, width, height), "Opacity", this, false));
        this.widgets.put("hexInputField", new HexInputField(new AABB(0.0f, 0.8333333f, 0.5f, 1.0f, x, y, width, height), this, class_310.method_1551().field_1772));
        screenContext.addWidget(this);
        for (Bounded widget : this.widgets.values()) {
            screenContext.addWidget(widget.getWidget());
        }
        this.setActive(false);
    }

    public void setActive(boolean active) {
        this.field_22763 = this.field_22764 = active;
        for (Bounded widget : this.widgets.values()) {
            widget.setActive(active);
        }
    }

    public void setColor(WakeColor currentColor, WidgetUpdateFlag updateFlag) {
        if (updateFlag.equals((Object)WidgetUpdateFlag.ONLY_HEX)) {
            this.widgets.get("hexInputField").setColor(currentColor);
            return;
        }
        float[] hsv = Color.RGBtoHSB(currentColor.r, currentColor.g, currentColor.b, null);
        this.pickerPos.set((float)this.bounds.x + hsv[1] * (float)this.bounds.width, (float)this.bounds.y + (1.0f - hsv[2]) * (float)this.bounds.height);
        for (String widgetKey : this.widgets.keySet()) {
            if (updateFlag.equals((Object)WidgetUpdateFlag.IGNORE_HEX) && widgetKey.equals("hexInputField")) {
                this.changedColorListener.accept(currentColor);
                continue;
            }
            this.widgets.get(widgetKey).setColor(currentColor);
        }
    }

    public void registerListener(Consumer<WakeColor> changedListener) {
        this.changedColorListener = changedListener;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        class_339 hexInput = this.widgets.get("hexInputField").getWidget();
        if (hexInput.method_25370()) {
            return hexInput.method_25404(keyCode, scanCode, modifiers);
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25400(char chr, int modifiers) {
        class_339 hexInput = this.widgets.get("hexInputField").getWidget();
        if (hexInput.method_25370()) {
            return hexInput.method_25400(chr, modifiers);
        }
        return super.method_25400(chr, modifiers);
    }

    public void method_25348(double mouseX, double mouseY) {
        class_339 focusedWidget = null;
        for (Bounded widget : this.widgets.values()) {
            widget.getWidget().method_25365(false);
            if (!widget.getBounds().contains((int)mouseX, (int)mouseY)) continue;
            focusedWidget = widget.getWidget();
        }
        if (focusedWidget != null) {
            focusedWidget.method_25365(true);
            focusedWidget.method_25348(mouseX, mouseY);
            return;
        }
        this.updatePickerPos(mouseX, mouseY);
        super.method_25348(mouseX, mouseY);
    }

    public void method_25349(double mouseX, double mouseY, double deltaX, double deltaY) {
        mouseX = Math.min((double)(this.method_46426() + this.field_22758), Math.max((double)this.method_46426(), mouseX));
        mouseY = Math.min((double)(this.method_46427() + this.field_22759), Math.max((double)this.method_46427(), mouseY));
        for (Bounded widget : this.widgets.values()) {
            if (!widget.getWidget().method_25370()) continue;
            widget.getWidget().method_25349(mouseX, mouseY, deltaX, deltaY);
            return;
        }
        this.updatePickerPos(mouseX, mouseY);
        super.method_25349(mouseX, mouseY, deltaX, deltaY);
    }

    public void updatePickerPos(double mouseX, double mouseY) {
        mouseX = Math.min((double)(this.bounds.x + this.bounds.width), Math.max((double)this.bounds.x, mouseX));
        mouseY = Math.min((double)(this.bounds.y + this.bounds.height), Math.max((double)this.bounds.y, mouseY));
        this.pickerPos.set(mouseX, mouseY);
        this.updateColor();
    }

    public void updateColor() {
        float hue = ((GradientSlider)this.widgets.get("hueSlider").getWidget()).getValue();
        float saturation = (this.pickerPos.x - (float)this.bounds.x) / (float)this.bounds.width;
        float value = 1.0f - (this.pickerPos.y - (float)this.bounds.y) / (float)this.bounds.height;
        float opacity = ((GradientSlider)this.widgets.get("alphaSlider").getWidget()).getValue();
        WakeColor newColor = new WakeColor(hue, saturation, value, opacity);
        this.setColor(newColor, WidgetUpdateFlag.ONLY_HEX);
        this.changedColorListener.accept(newColor);
    }

    protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        if (!this.field_22763) {
            return;
        }
        int x = this.bounds.x;
        int y = this.bounds.y;
        int w = this.bounds.width;
        int h = this.bounds.height;
        RenderSystem.setShader(() -> ((ManagedCoreShader)WakesClient.POSITION_TEXTURE_HSV).getProgram());
        RenderSystem.setShaderTexture((int)0, (class_2960)GradientSlider.BLANK_SLIDER_TEXTURE);
        float hue = ((GradientSlider)this.widgets.get("hueSlider").getWidget()).getValue();
        class_287 builder = class_289.method_1348().method_1349();
        builder.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
        Matrix4f matrix = context.method_51448().method_23760().method_23761();
        builder.method_22918(matrix, (float)x, (float)y, 0.0f).method_22913(0.0f, 0.0f).method_22915(hue, 0.0f, 1.0f, 1.0f).method_1344();
        builder.method_22918(matrix, (float)x, (float)(y + h), 0.0f).method_22913(0.0f, 1.0f).method_22915(hue, 0.0f, 0.0f, 1.0f).method_1344();
        builder.method_22918(matrix, (float)(x + w), (float)(y + h), 0.0f).method_22913(1.0f, 1.0f).method_22915(hue, 1.0f, 0.0f, 1.0f).method_1344();
        builder.method_22918(matrix, (float)(x + w), (float)y, 0.0f).method_22913(1.0f, 0.0f).method_22915(hue, 1.0f, 1.0f, 1.0f).method_1344();
        class_289.method_1348().method_1350();
        context.method_25290(FRAME_TEXTURE, x, y, 0.0f, 0.0f, w, h, w, h);
        int d = 7;
        int pickerX = (int)Math.min((float)(this.bounds.x + this.bounds.width - d), Math.max((float)this.bounds.x, this.pickerPos.x - 3.0f));
        int pickerY = (int)Math.min((float)(this.bounds.y + this.bounds.height - d), Math.max((float)this.bounds.y, this.pickerPos.y - 3.0f));
        context.method_25290(PICKER_KNOB_TEXTURE, pickerX, pickerY, 0.0f, 0.0f, d, d, d, d);
    }

    protected void method_47399(class_6382 builder) {
    }

    public static class AABB {
        public int x;
        public int y;
        public int width;
        public int height;

        public AABB(float fracX1, float fracY1, float fracX2, float fracY2, int globX, int globY, int totWidth, int totHeight) {
            this.x = Math.round(fracX1 * (float)totWidth) + globX + 1;
            this.y = Math.round(fracY1 * (float)totHeight) + globY + 1;
            this.width = Math.round((fracX2 - fracX1) * (float)totWidth) - 2;
            this.height = Math.round((fracY2 - fracY1) * (float)totHeight) - 2;
        }

        public boolean contains(int x, int y) {
            return this.x <= x && x < this.x + this.width && this.y <= y && y < this.y + this.height;
        }
    }

    private static class GradientSlider
    extends class_357
    implements Bounded {
        private static final class_2960 TRANSPARENT_SLIDER_TEXTURE = class_2960.method_43902((String)"wakes", (String)"textures/transparent_slider.png");
        private static final class_2960 BLANK_SLIDER_TEXTURE = class_2960.method_43902((String)"wakes", (String)"textures/blank_slider.png");
        protected AABB bounds;
        private final boolean colored;
        private final ColorPicker colorPicker;

        public GradientSlider(AABB bounds, String text, ColorPicker colorPicker, boolean colored) {
            super(bounds.x, bounds.y, bounds.width, bounds.height, class_2561.method_30163((String)text), 1.0);
            this.bounds = bounds;
            this.colorPicker = colorPicker;
            this.colored = colored;
        }

        @Override
        public void setActive(boolean active) {
            this.field_22763 = this.field_22764 = active;
        }

        @Override
        public void setColor(WakeColor currentColor) {
            this.field_22753 = this.colored ? (double)Color.RGBtoHSB(currentColor.r, currentColor.g, currentColor.b, null)[0] : (double)((float)currentColor.a / 255.0f);
        }

        public float getValue() {
            return (float)this.field_22753;
        }

        public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
            int rightCol;
            int leftCol;
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            context.method_49697(field_41787, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(), 20, 4, 200, 20, 0, this.method_25356());
            if (this.colored) {
                context.method_51422(1.0f, 1.0f, 1.0f, 0.3f);
                RenderSystem.setShader(() -> ((ManagedCoreShader)WakesClient.POSITION_TEXTURE_HSV).getProgram());
                RenderSystem.setShaderTexture((int)0, (class_2960)BLANK_SLIDER_TEXTURE);
                leftCol = -16711681;
                rightCol = -1;
            } else {
                context.method_51422(1.0f, 1.0f, 1.0f, 0.6f);
                RenderSystem.setShader(class_757::method_34543);
                RenderSystem.setShaderTexture((int)0, (class_2960)TRANSPARENT_SLIDER_TEXTURE);
                leftCol = -1;
                rightCol = 0xFFFFFF;
            }
            int x = this.bounds.x;
            int y = this.bounds.y;
            int w = this.bounds.width;
            int h = this.bounds.height;
            class_287 builder = class_289.method_1348().method_1349();
            builder.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
            Matrix4f matrix = context.method_51448().method_23760().method_23761();
            builder.method_22918(matrix, (float)x, (float)y, 0.0f).method_22913(0.0f, 0.0f).method_39415(leftCol).method_1344();
            builder.method_22918(matrix, (float)x, (float)(y + h), 0.0f).method_22913(0.0f, 1.0f).method_39415(leftCol).method_1344();
            builder.method_22918(matrix, (float)(x + w), (float)(y + h), 0.0f).method_22913(1.0f, 1.0f).method_39415(rightCol).method_1344();
            builder.method_22918(matrix, (float)(x + w), (float)y, 0.0f).method_22913(1.0f, 0.0f).method_39415(rightCol).method_1344();
            class_289.method_1348().method_1350();
            context.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
            context.method_49697(field_41787, this.method_46426() + (int)(this.field_22753 * (double)(this.field_22758 - 8)), this.method_46427(), 8, 20, 20, 4, 200, 20, 0, this.method_48204());
            int i = this.field_22763 ? 0xFFFFFF : 0xA0A0A0;
            this.method_49604(context, class_310.method_1551().field_1772, 2, i | class_3532.method_15386((float)(this.field_22765 * 255.0f)) << 24);
        }

        protected void method_25346() {
        }

        protected void method_25344() {
            this.colorPicker.updateColor();
        }

        @Override
        public AABB getBounds() {
            return this.bounds;
        }

        @Override
        public class_339 getWidget() {
            return this;
        }
    }

    private static class HexInputField
    extends class_342
    implements Bounded {
        protected AABB bounds;
        private final ColorPicker colorPicker;
        private final Pattern hexColorRegex;
        private boolean autoUpdate = false;

        public HexInputField(AABB bounds, ColorPicker colorPicker, class_327 textRenderer) {
            super(textRenderer, bounds.x, bounds.y, bounds.width, bounds.height, (class_2561)class_2561.method_43473());
            this.method_1880(9);
            this.bounds = bounds;
            this.colorPicker = colorPicker;
            this.method_1890(HexInputField::validHex);
            this.hexColorRegex = Pattern.compile("#[a-f0-9]{7,9}", 2);
        }

        public void method_1874(String newText) {
            if (this.autoUpdate) {
                return;
            }
            if (this.hexColorRegex.matcher(newText).find()) {
                this.colorPicker.setColor(new WakeColor(newText), WidgetUpdateFlag.IGNORE_HEX);
            }
            super.method_1874(newText);
        }

        private static boolean validHex(String text) {
            if (text.length() > 9) {
                return false;
            }
            for (char c : text.toLowerCase().toCharArray()) {
                if (Character.digit(c, 16) != -1 || c == '#') continue;
                return false;
            }
            return true;
        }

        @Override
        public void setActive(boolean active) {
            this.field_22763 = this.field_22764 = active;
        }

        public boolean method_25400(char chr, int modifiers) {
            this.autoUpdate = false;
            return super.method_25400(chr, modifiers);
        }

        public boolean method_25404(int keyCode, int scanCode, int modifiers) {
            this.autoUpdate = false;
            return super.method_25404(keyCode, scanCode, modifiers);
        }

        @Override
        public void setColor(WakeColor currentColor) {
            this.autoUpdate = true;
            this.method_1852(currentColor.toHex());
        }

        @Override
        public AABB getBounds() {
            return this.bounds;
        }

        @Override
        public class_339 getWidget() {
            return this;
        }
    }

    public static interface Bounded {
        public AABB getBounds();

        public class_339 getWidget();

        public void setActive(boolean var1);

        public void setColor(WakeColor var1);
    }

    public static enum WidgetUpdateFlag {
        ALL,
        ONLY_HEX,
        IGNORE_HEX;

    }
}

