/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.data.builder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.content.fluids.transfer.EmptyingRecipe;
import com.simibubi.create.content.fluids.transfer.FillingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.StrictNBTIngredient;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.ModLoadedCondition;
import net.minecraftforge.registries.ForgeRegistries;
import umpaz.brewinandchewin.common.registry.BnCRecipeSerializers;

public class KegPouringRecipeBuilder {
    private ItemStack container;
    private final Fluid fluid;
    private final int amount;
    private final ItemStack output;
    private final boolean strict;
    private final boolean filling;
    private final List<ICondition> conditions = new ArrayList<ICondition>();
    private boolean includeCreateRecipes = true;

    private KegPouringRecipeBuilder(Fluid fluid, int amount, ItemStack output, boolean strict, boolean filling) {
        this.fluid = fluid;
        this.amount = amount;
        this.output = output;
        this.strict = strict;
        this.filling = filling;
    }

    public static KegPouringRecipeBuilder kegPouringRecipe(Fluid fluid, int amount, ItemStack output, boolean strict) {
        return new KegPouringRecipeBuilder(fluid, amount, output, strict, true);
    }

    public static KegPouringRecipeBuilder kegPouringRecipe(Fluid fluid, int amount, ItemStack output, boolean strict, boolean filling) {
        return new KegPouringRecipeBuilder(fluid, amount, output, strict, filling);
    }

    public static KegPouringRecipeBuilder kegPouringRecipe(Fluid fluid, int amount, ItemLike output) {
        return new KegPouringRecipeBuilder(fluid, amount, output.m_5456_().m_7968_(), false, true);
    }

    public static KegPouringRecipeBuilder kegPouringRecipe(Fluid fluid, int amount, ItemLike output, boolean filling) {
        return new KegPouringRecipeBuilder(fluid, amount, output.m_5456_().m_7968_(), false, filling);
    }

    public KegPouringRecipeBuilder withContainer(ItemLike container) {
        this.container = container.m_5456_().m_7968_();
        return this;
    }

    public KegPouringRecipeBuilder withCondition(ICondition condition) {
        this.conditions.add(condition);
        return this;
    }

    public KegPouringRecipeBuilder excludeCreateCompat() {
        this.includeCreateRecipes = false;
        return this;
    }

    public void build(Consumer<FinishedRecipe> consumerIn) {
        ResourceLocation outputLocation = ForgeRegistries.ITEMS.getKey((Object)this.output.m_41720_());
        this.build(consumerIn, "brewinandchewin:pouring/" + outputLocation.m_135815_());
    }

    public void build(Consumer<FinishedRecipe> consumerIn, String save) {
        ResourceLocation resourcelocation = ForgeRegistries.ITEMS.getKey((Object)this.output.m_41720_());
        if (new ResourceLocation(save).equals((Object)resourcelocation)) {
            throw new IllegalStateException("Pouring Recipe " + save + " should remove its 'save' argument");
        }
        this.build(consumerIn, new ResourceLocation(save));
    }

    public void build(Consumer<FinishedRecipe> consumerIn, ResourceLocation id) {
        if (!this.output.hasCraftingRemainingItem() && this.container == null) {
            throw new IllegalStateException("Pouring Recipe " + String.valueOf(id) + " must specify a container as the output does not have a remainder.");
        }
        consumerIn.accept(new Result(id, this.container, this.fluid, this.amount, this.output, this.strict, this.filling, this.conditions));
        if (ForgeRegistries.ITEMS.getKey((Object)this.output.m_41720_()).m_135827_().equals("create") || !this.includeCreateRecipes) {
            return;
        }
        ProcessingRecipeBuilder fillingBuilder = new ProcessingRecipeBuilder(FillingRecipe::new, new ResourceLocation("brewinandchewin", "create/" + id.m_135815_().replace("pouring/", ""))).require(this.fluid, this.amount).require((ItemLike)(this.container == null ? this.output.getCraftingRemainingItem().m_41720_() : this.container.m_41720_())).output(this.output).withCondition((ICondition)new ModLoadedCondition("create"));
        for (ICondition condition : this.conditions) {
            fillingBuilder.withCondition(condition);
        }
        fillingBuilder.build(consumerIn);
        if (!this.filling) {
            return;
        }
        ProcessingRecipeBuilder emptyingBuilder = new ProcessingRecipeBuilder(EmptyingRecipe::new, new ResourceLocation("brewinandchewin", "create/" + id.m_135815_().replace("pouring/", ""))).output(this.fluid, this.amount).output((ItemLike)(this.container == null ? this.output.getCraftingRemainingItem().m_41720_() : this.container.m_41720_())).withCondition((ICondition)new ModLoadedCondition("create"));
        if (this.strict) {
            emptyingBuilder.require((Ingredient)StrictNBTIngredient.of((ItemStack)this.output));
        } else {
            emptyingBuilder.require((ItemLike)this.output.m_41720_());
        }
        for (ICondition condition : this.conditions) {
            emptyingBuilder.withCondition(condition);
        }
        emptyingBuilder.build(consumerIn);
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        @Nullable
        private final ItemStack container;
        private final Fluid fluid;
        private final int amount;
        private final ItemStack output;
        private final boolean strict;
        private final boolean filling;
        private final List<ICondition> conditions;

        public Result(ResourceLocation idIn, ItemStack containerIn, Fluid fluidIn, int amountIn, ItemStack outputIn, boolean strict, boolean filling, List<ICondition> conditions) {
            this.id = idIn;
            this.container = containerIn;
            this.fluid = fluidIn;
            this.amount = amountIn;
            this.output = outputIn;
            this.strict = strict;
            this.filling = filling;
            this.conditions = conditions;
        }

        public void m_7917_(JsonObject json) {
            if (this.container != null) {
                JsonObject objectContainer = new JsonObject();
                objectContainer.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)this.container.m_41720_()).toString());
                if (this.container.m_41782_()) {
                    objectContainer.addProperty("nbt", this.container.m_41783_().toString());
                }
                json.add("container", (JsonElement)objectContainer);
            }
            JsonObject objectContainer1 = new JsonObject();
            objectContainer1.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)this.output.m_41720_()).toString());
            if (this.output.m_41782_()) {
                objectContainer1.addProperty("nbt", this.output.m_41783_().toString());
            }
            json.add("output", (JsonElement)objectContainer1);
            json.addProperty("fluid", ForgeRegistries.FLUIDS.getKey((Object)this.fluid).toString());
            json.addProperty("amount", (Number)this.amount);
            json.addProperty("strict", Boolean.valueOf(this.strict));
            json.addProperty("filling", Boolean.valueOf(this.filling));
            if (!this.conditions.isEmpty()) {
                JsonArray conditions = new JsonArray();
                this.conditions.forEach(iCondition -> conditions.add((JsonElement)CraftingHelper.serialize((ICondition)iCondition)));
                json.add("conditions", (JsonElement)conditions);
            }
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)BnCRecipeSerializers.KEG_POURING.get();
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

