/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.loot;

import com.teammetallurgy.aquaculture.api.AquacultureAPI;
import com.teammetallurgy.aquaculture.api.fish.FishData;
import com.teammetallurgy.aquaculture.init.AquaItems;
import com.teammetallurgy.aquaculture.misc.AquaConfig;
import java.math.BigDecimal;
import java.math.MathContext;
import java.text.DecimalFormat;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.StringUtils;

@Mod.EventBusSubscriber(modid="aquaculture")
public class FishWeightHandler {
    @SubscribeEvent
    public static void onItemFished(ItemFishedEvent event) {
        if (!event.getDrops().isEmpty()) {
            ItemStack fish = (ItemStack)event.getDrops().get(0);
            if (((Boolean)AquaConfig.BASIC_OPTIONS.randomWeight.get()).booleanValue()) {
                if (AquacultureAPI.FISH_DATA.hasWeight(fish.m_41720_())) {
                    FishData fishWeight = AquacultureAPI.FISH_DATA;
                    FishWeightHandler.assignRandomWeight(fish, fishWeight.getMinWeight(fish.m_41720_()), fishWeight.getMaxWeight(fish.m_41720_()));
                } else if (fish.m_204117_(ItemTags.f_13156_)) {
                    FishWeightHandler.assignRandomWeight(fish, 0.1, 100.0);
                }
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (!stack.m_41619_() && stack != null && stack.m_41782_() && stack.m_41783_() != null) {
            if (stack.m_41783_().m_128441_("fishSize")) {
                MutableComponent fishWeightString = Component.m_237115_((String)("aquaculture.fishWeight." + StringUtils.toLowerCase((String)stack.m_41783_().m_128461_("fishSize"))));
                event.getToolTip().add(fishWeightString.m_130948_(fishWeightString.m_7383_().m_131155_(Boolean.valueOf(true)).m_131140_(ChatFormatting.AQUA)));
            }
            if (stack.m_41783_().m_128441_("fishWeight")) {
                double weight = stack.m_41783_().m_128459_("fishWeight");
                String lb = weight == 1.0 ? " lb" : " lbs";
                DecimalFormat df = new DecimalFormat("#,###.##");
                BigDecimal bd = new BigDecimal(weight);
                if ((bd = bd.round(new MathContext(3))).doubleValue() > 999.0) {
                    MutableComponent doubleWeight = Component.m_237110_((String)"aquaculture.fishWeight.weight", (Object[])new Object[]{df.format((int)bd.doubleValue()) + lb});
                    event.getToolTip().add(doubleWeight.m_130948_(doubleWeight.m_7383_().m_131155_(Boolean.valueOf(true)).m_131140_(ChatFormatting.GRAY)));
                } else {
                    MutableComponent decimalWeight = Component.m_237110_((String)"aquaculture.fishWeight.weight", (Object[])new Object[]{String.valueOf(bd) + lb});
                    event.getToolTip().add(decimalWeight.m_130948_(decimalWeight.m_7383_().m_131155_(Boolean.valueOf(true)).m_131140_(ChatFormatting.GRAY)));
                }
            }
        }
    }

    private static void assignRandomWeight(ItemStack fish, double min, double max) {
        CompoundTag tag;
        if (fish.m_41619_()) {
            return;
        }
        double weight = min + Math.random() * (max - min);
        if (!fish.m_41782_()) {
            fish.m_41751_(new CompoundTag());
        }
        if ((tag = fish.m_41783_()) != null) {
            tag.m_128347_("fishWeight", weight);
            if (weight <= max * (double)0.1f) {
                tag.m_128359_("fishSize", "juvenile");
            } else if (weight > max * (double)0.1f && weight <= max * (double)0.2f) {
                tag.m_128359_("fishSize", "small");
            } else if (weight >= max * (double)0.8f && weight < max * (double)0.9f) {
                tag.m_128359_("fishSize", "large");
            } else if (weight >= max * (double)0.9f) {
                tag.m_128359_("fishSize", "massive");
            }
        }
    }

    public static void registerFishData() {
        AquacultureAPI.FISH_DATA.add((Item)AquaItems.ATLANTIC_COD.get(), 10.0, 211.0, 6);
        AquacultureAPI.FISH_DATA.add((Item)AquaItems.BLACKFISH.get(), 1.0, 28.0, 2);
        AquacultureAPI.FISH_DATA.add((Item)AquaItems.PACIFIC_HALIBUT.get(), 25.0, 550.0, 12);
        AquacultureAPI.FISH_DATA.add((Item)AquaItems.ATLANTIC_HALIBUT.get(), 50.0, 710.0, 14);
        AquacultureAPI.FISH_DATA.add((Item)AquaItems.ATLANTIC_HERRING.get(), 0.5, 2.4, 1);
        AquacultureAPI.FISH_DATA.add((Item)AquaItems.PINK_SALMON.get(), 1.5, 15.0, 2);
        AquacultureAPI.FISH_DATA.add((Item)AquaItems.POLLOCK.get(), 3.0, 46.0, 2);
        AquacultureAPI.FISH_DATA.add((Item)AquaItems.RAINBOW_TROUT.get(), 2.0, 27.0, 2);
        AquacultureAPI.FISH_DATA.add((Item)AquaItems.BAYAD.get(), 5.0, 145.0, 4);
        AquacultureAPI.FISH_DATA.add((Item)AquaItems.BOULTI.get(), 1.0, 9.5, 1);
        AquacultureAPI.FISH_DATA.add((Item)AquaItems.CAPITAINE.get(), 20.0, 440.0, 10);
        AquacultureAPI.FISH_DATA.add((Item)AquaItems.SYNODONTIS.get(), 0.5, 2.5, 1);
        AquacultureAPI.FISH_DATA.add((Item)AquaItems.SMALLMOUTH_BASS.get(), 1.0, 12.0, 2);
        AquacultureAPI.FISH_DATA.add((Item)AquaItems.BLUEGILL.get(), 0.8, 4.5, 1);
        AquacultureAPI.FISH_DATA.add((Item)AquaItems.BROWN_TROUT.get(), 1.5, 44.0, 2);
        AquacultureAPI.FISH_DATA.add((Item)AquaItems.CARP.get(), 2.0, 40.0, 2);
        AquacultureAPI.FISH_DATA.add((Item)AquaItems.CATFISH.get(), 10.0, 220.0, 6);
        AquacultureAPI.FISH_DATA.add((Item)AquaItems.GAR.get(), 8.0, 100.0, 4);
        AquacultureAPI.FISH_DATA.add((Item)AquaItems.MINNOW.get(), 0.2, 1.5, 0);
        AquacultureAPI.FISH_DATA.add((Item)AquaItems.MUSKELLUNGE.get(), 5.0, 70.0, 3);
        AquacultureAPI.FISH_DATA.add((Item)AquaItems.PERCH.get(), 0.5, 6.0, 1);
        AquacultureAPI.FISH_DATA.add((Item)AquaItems.ARAPAIMA.get(), 20.0, 440.0, 10);
        AquacultureAPI.FISH_DATA.add((Item)AquaItems.PIRANHA.get(), 0.5, 7.7, 1);
        AquacultureAPI.FISH_DATA.add((Item)AquaItems.TAMBAQUI.get(), 7.0, 97.0, 3);
        AquacultureAPI.FISH_DATA.add((Item)AquaItems.BROWN_SHROOMA.get(), 1.0, 5.0, 0);
        AquacultureAPI.FISH_DATA.add((Item)AquaItems.RED_SHROOMA.get(), 1.0, 5.0, 0);
        AquacultureAPI.FISH_DATA.add((Item)AquaItems.JELLYFISH.get(), 5.0, 400.0, 0);
        AquacultureAPI.FISH_DATA.add((Item)AquaItems.RED_GROUPER.get(), 4.0, 50.0, 3);
        AquacultureAPI.FISH_DATA.add((Item)AquaItems.TUNA.get(), 30.0, 1508.0, 10);
        AquacultureAPI.FISH_DATA.add((Item)AquaItems.GOLDFISH.get(), 0.05, 5.0, 0);
        AquacultureAPI.FISH_DATA.add(Items.f_42526_, 12.0, 211.0, 4);
        AquacultureAPI.FISH_DATA.add(Items.f_42527_, 0.6, 15.0, 2);
        AquacultureAPI.FISH_DATA.add(Items.f_42528_, 0.01, 1.0, 0);
        AquacultureAPI.FISH_DATA.add(Items.f_42529_, 1.0, 25.0, 1);
    }
}

