/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.core.data.server.modifiers;

import com.teamabnormals.blueprint.common.advancement.modification.AdvancementModifierProvider;
import com.teamabnormals.blueprint.common.advancement.modification.modifiers.CriteriaModifier;
import com.teamabnormals.blueprint.core.util.modification.ObjectModifier;
import com.teamabnormals.endergetic.common.advancement.EECriteriaTriggers;
import com.teamabnormals.endergetic.core.registry.EEEntityTypes;
import com.teamabnormals.endergetic.core.registry.EEItems;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.BredAnimalsTrigger;
import net.minecraft.advancements.critereon.ConsumeItemTrigger;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.KilledTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.registries.ForgeRegistries;

public final class EEAdvancementModifierProvider
extends AdvancementModifierProvider {
    private static final EntityType<?>[] BREEDABLE_ANIMALS = new EntityType[]{(EntityType)EEEntityTypes.PUFF_BUG.get()};
    private static final EntityType<?>[] MOBS_TO_KILL = new EntityType[]{(EntityType)EEEntityTypes.BOOFLO.get(), (EntityType)EEEntityTypes.PUFF_BUG.get()};

    public EEAdvancementModifierProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> provider) {
        super("endergetic", output, provider);
    }

    protected void registerEntries(HolderLookup.Provider provider) {
        CriteriaModifier.Builder balancedDiet = CriteriaModifier.builder((String)this.modId);
        balancedDiet.addCriterion("bolloom_fruit", (CriterionTriggerInstance)ConsumeItemTrigger.TriggerInstance.m_23703_((ItemLike)((ItemLike)EEItems.BOLLOOM_FRUIT.get())));
        this.entry("husbandry/balanced_diet").selects(new String[]{"husbandry/balanced_diet"}).addModifier((ObjectModifier)balancedDiet.requirements(RequirementsStrategy.f_15978_).build(), new ICondition[0]);
        CriteriaModifier.Builder breedAllAnimals = CriteriaModifier.builder((String)this.modId);
        breedAllAnimals.addCriterion("booflo", (CriterionTriggerInstance)EECriteriaTriggers.BRED_BOOFLO.createInstance());
        for (EntityType<?> entityType : BREEDABLE_ANIMALS) {
            breedAllAnimals.addCriterion(ForgeRegistries.ENTITY_TYPES.getKey(entityType).m_135815_(), (CriterionTriggerInstance)BredAnimalsTrigger.TriggerInstance.m_18667_((EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36636_(entityType)));
        }
        this.entry("husbandry/bred_all_animals").selects(new String[]{"husbandry/bred_all_animals"}).addModifier((ObjectModifier)breedAllAnimals.requirements(RequirementsStrategy.f_15978_).build(), new ICondition[0]);
        CriteriaModifier.Builder breedAnAnimal = CriteriaModifier.builder((String)this.modId);
        breedAnAnimal.addCriterion("bred_booflo", (CriterionTriggerInstance)EECriteriaTriggers.BRED_BOOFLO.createInstance());
        breedAnAnimal.addIndexedRequirements(0, false, new String[]{"bred_booflo"});
        this.entry("husbandry/breed_an_animal").selects(new String[]{"husbandry/breed_an_animal"}).addModifier((ObjectModifier)breedAnAnimal.build(), new ICondition[0]);
        CriteriaModifier.Builder killAMob = CriteriaModifier.builder((String)this.modId);
        CriteriaModifier.Builder killAllMobs = CriteriaModifier.builder((String)this.modId);
        ArrayList<String> names = new ArrayList<String>();
        for (EntityType<?> entityType : MOBS_TO_KILL) {
            String name = ForgeRegistries.ENTITY_TYPES.getKey(entityType).m_135815_();
            KilledTrigger.TriggerInstance triggerInstance = KilledTrigger.TriggerInstance.m_48134_((EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36636_(entityType));
            killAMob.addCriterion(name, (CriterionTriggerInstance)triggerInstance);
            killAllMobs.addCriterion(name, (CriterionTriggerInstance)triggerInstance);
            names.add(name);
        }
        this.entry("adventure/kill_a_mob").selects(new String[]{"adventure/kill_a_mob"}).addModifier((ObjectModifier)killAMob.addIndexedRequirements(0, false, names.toArray(new String[0])).build(), new ICondition[0]);
        this.entry("adventure/kill_all_mobs").selects(new String[]{"adventure/kill_all_mobs"}).addModifier((ObjectModifier)killAllMobs.requirements(RequirementsStrategy.f_15978_).build(), new ICondition[0]);
    }
}

