/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.core.other;

import com.teamabnormals.endergetic.common.entity.bolloom.BalloonColor;
import com.teamabnormals.endergetic.common.entity.eetle.BroodEetle;
import com.teamabnormals.endergetic.common.entity.eetle.flying.TargetFlyingRotations;
import com.teamabnormals.endergetic.common.entity.purpoid.PurpoidSize;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;

public final class EEDataSerializers {
    public static final DeferredRegister<EntityDataSerializer<?>> SERIALIZERS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.ENTITY_DATA_SERIALIZERS, (String)"endergetic");
    public static final EntityDataSerializer<Optional<Vec3>> OPTIONAL_VEC3D = new EntityDataSerializer<Optional<Vec3>>(){

        public void write(FriendlyByteBuf buf, Optional<Vec3> value) {
            buf.writeBoolean(value.isPresent());
            if (value.isPresent()) {
                Vec3 vec3d = value.get();
                buf.writeDouble(vec3d.m_7096_());
                buf.writeDouble(vec3d.m_7098_());
                buf.writeDouble(vec3d.m_7094_());
            }
        }

        public Optional<Vec3> read(FriendlyByteBuf buf) {
            return !buf.readBoolean() ? Optional.empty() : Optional.of(new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble()));
        }

        public Optional<Vec3> copy(Optional<Vec3> value) {
            return value;
        }
    };
    public static final EntityDataSerializer<BalloonColor> BALLOON_COLOR = new EntityDataSerializer<BalloonColor>(){

        public void write(FriendlyByteBuf buf, BalloonColor value) {
            buf.m_130068_((Enum)value);
        }

        public BalloonColor read(FriendlyByteBuf buf) {
            return (BalloonColor)buf.m_130066_(BalloonColor.class);
        }

        public BalloonColor copy(BalloonColor value) {
            return value;
        }
    };
    public static final EntityDataSerializer<TargetFlyingRotations> TARGET_FLYING_ROTATIONS = new EntityDataSerializer<TargetFlyingRotations>(){

        public void write(FriendlyByteBuf buf, TargetFlyingRotations value) {
            buf.writeFloat(value.getTargetFlyPitch());
            buf.writeFloat(value.getTargetFlyRoll());
        }

        public TargetFlyingRotations read(FriendlyByteBuf buf) {
            return new TargetFlyingRotations(buf.readFloat(), buf.readFloat());
        }

        public TargetFlyingRotations copy(TargetFlyingRotations value) {
            return value;
        }
    };
    public static final EntityDataSerializer<EntityDimensions> ENTITY_SIZE = new EntityDataSerializer<EntityDimensions>(){

        public void write(FriendlyByteBuf buf, EntityDimensions value) {
            buf.writeFloat(value.f_20377_);
            buf.writeFloat(value.f_20378_);
            buf.writeBoolean(value.f_20379_);
        }

        public EntityDimensions read(FriendlyByteBuf buf) {
            return new EntityDimensions(buf.readFloat(), buf.readFloat(), buf.readBoolean());
        }

        public EntityDimensions copy(EntityDimensions value) {
            return value;
        }
    };
    public static final EntityDataSerializer<BroodEetle.HealthStage> BROOD_HEALTH_STAGE = new EntityDataSerializer<BroodEetle.HealthStage>(){

        public void write(FriendlyByteBuf buf, BroodEetle.HealthStage value) {
            buf.m_130068_((Enum)value);
        }

        public BroodEetle.HealthStage read(FriendlyByteBuf buf) {
            return (BroodEetle.HealthStage)buf.m_130066_(BroodEetle.HealthStage.class);
        }

        public BroodEetle.HealthStage copy(BroodEetle.HealthStage value) {
            return value;
        }
    };
    public static final EntityDataSerializer<PurpoidSize> PURPOID_SIZE = new EntityDataSerializer<PurpoidSize>(){

        public void write(FriendlyByteBuf buf, PurpoidSize value) {
            buf.m_130068_((Enum)value);
        }

        public PurpoidSize read(FriendlyByteBuf buf) {
            return (PurpoidSize)buf.m_130066_(PurpoidSize.class);
        }

        public PurpoidSize copy(PurpoidSize value) {
            return value;
        }
    };

    static {
        SERIALIZERS.register("optional_vec3d", () -> OPTIONAL_VEC3D);
        SERIALIZERS.register("balloon_color", () -> BALLOON_COLOR);
        SERIALIZERS.register("target_flying_rotations", () -> TARGET_FLYING_ROTATIONS);
        SERIALIZERS.register("entity_size", () -> ENTITY_SIZE);
        SERIALIZERS.register("brood_health_stage", () -> BROOD_HEALTH_STAGE);
        SERIALIZERS.register("purpoid_size", () -> PURPOID_SIZE);
    }
}

