/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.core.registry;

import com.teamabnormals.endergetic.common.entity.BoofBlockEntity;
import com.teamabnormals.endergetic.common.entity.PoiseClusterEntity;
import com.teamabnormals.endergetic.common.entity.bolloom.BolloomBalloon;
import com.teamabnormals.endergetic.common.entity.bolloom.BolloomFruit;
import com.teamabnormals.endergetic.common.entity.bolloom.BolloomKnot;
import com.teamabnormals.endergetic.common.entity.booflo.Booflo;
import com.teamabnormals.endergetic.common.entity.booflo.BoofloAdolescent;
import com.teamabnormals.endergetic.common.entity.booflo.BoofloBaby;
import com.teamabnormals.endergetic.common.entity.eetle.BroodEetle;
import com.teamabnormals.endergetic.common.entity.eetle.BroodEggSack;
import com.teamabnormals.endergetic.common.entity.eetle.ChargerEetle;
import com.teamabnormals.endergetic.common.entity.eetle.EetleEgg;
import com.teamabnormals.endergetic.common.entity.eetle.GliderEetle;
import com.teamabnormals.endergetic.common.entity.puffbug.PuffBug;
import com.teamabnormals.endergetic.common.entity.purpoid.Purpoid;
import com.teamabnormals.endergetic.core.EndergeticExpansion;
import com.teamabnormals.endergetic.core.registry.EEBlocks;
import com.teamabnormals.endergetic.core.registry.util.EndergeticEntitySubRegistryHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="endergetic", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class EEEntityTypes {
    public static final MobCategory END_CREATURE = MobCategory.create((String)"endergetic:end_creature", (String)"end_creature", (int)20, (boolean)false, (boolean)true, (int)128);
    public static final EndergeticEntitySubRegistryHelper HELPER = (EndergeticEntitySubRegistryHelper)EndergeticExpansion.REGISTRY_HELPER.getEntitySubHelper();
    public static final RegistryObject<EntityType<PoiseClusterEntity>> POISE_CLUSTER = HELPER.createLivingEntity("poise_cluster", PoiseClusterEntity::new, MobCategory.MISC, 1.0f, 1.0f);
    public static final RegistryObject<EntityType<BolloomFruit>> BOLLOOM_FRUIT = HELPER.createManuallyUpdatedEntity("bolloom_fruit", BolloomFruit::new, BolloomFruit::new, MobCategory.MISC, 0.5f, 0.5f);
    public static final RegistryObject<EntityType<BoofBlockEntity>> BOOF_BLOCK = HELPER.createEntity("boof_block", BoofBlockEntity::new, BoofBlockEntity::new, MobCategory.MISC, 1.75f, 1.75f);
    public static final RegistryObject<EntityType<PuffBug>> PUFF_BUG = HELPER.createLivingEntity("puff_bug", PuffBug::new, MobCategory.CREATURE, 0.3f, 1.15f);
    public static final RegistryObject<EntityType<BolloomBalloon>> BOLLOOM_BALLOON = HELPER.createManuallyUpdatedEntity("bolloom_balloon", BolloomBalloon::new, BolloomBalloon::new, MobCategory.MISC, 0.5f, 0.5f);
    public static final RegistryObject<EntityType<BolloomKnot>> BOLLOOM_KNOT = HELPER.createEntity("bolloom_knot", BolloomKnot::new, BolloomKnot::new, MobCategory.MISC, 0.375f, 0.19f);
    public static final RegistryObject<EntityType<BoofloBaby>> BOOFLO_BABY = HELPER.createLivingEntity("booflo_baby", BoofloBaby::new, MobCategory.CREATURE, 0.375f, 0.325f);
    public static final RegistryObject<EntityType<BoofloAdolescent>> BOOFLO_ADOLESCENT = HELPER.createLivingEntity("booflo_adolescent", BoofloAdolescent::new, MobCategory.CREATURE, 0.8f, 0.7f);
    public static final RegistryObject<EntityType<Booflo>> BOOFLO = HELPER.createLivingEntity("booflo", Booflo::new, MobCategory.CREATURE, 1.3f, 1.3f);
    public static final RegistryObject<EntityType<ChargerEetle>> CHARGER_EETLE = HELPER.createLivingEntity("charger_eetle", ChargerEetle::new, MobCategory.MONSTER, 1.05f, 0.85f);
    public static final RegistryObject<EntityType<GliderEetle>> GLIDER_EETLE = HELPER.createLivingEntity("glider_eetle", GliderEetle::new, MobCategory.MONSTER, 1.05f, 0.85f);
    public static final RegistryObject<EntityType<BroodEetle>> BROOD_EETLE = HELPER.createLivingEntity("brood_eetle", BroodEetle::new, MobCategory.MONSTER, 3.4375f, 2.125f);
    public static final RegistryObject<EntityType<EetleEgg>> EETLE_EGG = HELPER.createEntity("eetle_egg", EetleEgg::new, EetleEgg::new, MobCategory.MISC, 0.98f, 0.98f);
    public static final RegistryObject<EntityType<BroodEggSack>> BROOD_EGG_SACK = HELPER.createUnsummonableEntity("brood_egg_sack", BroodEggSack::new, BroodEggSack::new, MobCategory.MISC, 1.25f, 1.25f);
    public static final RegistryObject<EntityType<Purpoid>> PURPOID = HELPER.createLivingEntity("purpoid", Purpoid::new, MobCategory.CREATURE, 1.0f, 1.0f);

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)BOOFLO.get(), Booflo.registerAttributes().m_22265_());
        event.put((EntityType)BOOFLO_ADOLESCENT.get(), BoofloAdolescent.registerAttributes().m_22265_());
        event.put((EntityType)BOOFLO_BABY.get(), BoofloBaby.registerAttributes().m_22265_());
        event.put((EntityType)PUFF_BUG.get(), PuffBug.registerAttributes().m_22265_());
        event.put((EntityType)POISE_CLUSTER.get(), LivingEntity.m_21183_().m_22265_());
        event.put((EntityType)CHARGER_EETLE.get(), ChargerEetle.registerAttributes().m_22265_());
        event.put((EntityType)GLIDER_EETLE.get(), GliderEetle.registerAttributes().m_22265_());
        event.put((EntityType)BROOD_EETLE.get(), BroodEetle.registerAttributes().m_22265_());
        event.put((EntityType)PURPOID.get(), Purpoid.registerAttributes().m_22265_());
    }

    @SubscribeEvent
    public static void registerSpawnPlacements(SpawnPlacementRegisterEvent event) {
        event.register((EntityType)BOOFLO.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING, EEEntityTypes::endIslandCondition, SpawnPlacementRegisterEvent.Operation.OR);
        event.register((EntityType)BOOFLO_ADOLESCENT.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING, EEEntityTypes::endIslandCondition, SpawnPlacementRegisterEvent.Operation.OR);
        event.register((EntityType)PUFF_BUG.get(), SpawnPlacements.Type.NO_RESTRICTIONS, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EEEntityTypes::endIslandCondition, SpawnPlacementRegisterEvent.Operation.OR);
        event.register((EntityType)CHARGER_EETLE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EEEntityTypes::eetleCondition, SpawnPlacementRegisterEvent.Operation.OR);
        event.register((EntityType)GLIDER_EETLE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EEEntityTypes::eetleCondition, SpawnPlacementRegisterEvent.Operation.OR);
    }

    private static boolean eetleCondition(EntityType<? extends Monster> entityType, ServerLevelAccessor world, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        if (Monster.m_219013_(entityType, (ServerLevelAccessor)world, (MobSpawnType)spawnReason, (BlockPos)pos, (RandomSource)random) || EEEntityTypes.isInfestedCorrockNearby(world, pos)) {
            BlockPos down = pos.m_7495_();
            Block downBlock = world.m_8055_(down).m_60734_();
            if (downBlock == EEBlocks.END_CORROCK_BLOCK.get() || downBlock == EEBlocks.EUMUS.get() || downBlock == EEBlocks.INFESTED_CORROCK.get()) {
                return true;
            }
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                Block offsetBlock = world.m_8055_(down.m_121945_(direction)).m_60734_();
                if (offsetBlock != EEBlocks.END_CORROCK_BLOCK.get() && offsetBlock != EEBlocks.EUMUS.get()) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isInfestedCorrockNearby(ServerLevelAccessor world, BlockPos pos) {
        int radius = 1;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        Block infestedCorrock = (Block)EEBlocks.INFESTED_CORROCK.get();
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    if (world.m_8055_((BlockPos)mutable.m_122154_((Vec3i)pos, x, y, z)).m_60734_() != infestedCorrock) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean endIslandCondition(EntityType<? extends PathfinderMob> entityType, LevelAccessor world, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        return pos.m_123342_() >= 40;
    }
}

