/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.impl;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import io.wispforest.accessories.AccessoriesInternals;
import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.AccessoriesHolder;
import io.wispforest.accessories.api.Accessory;
import io.wispforest.accessories.api.EquipAction;
import io.wispforest.accessories.api.EquipCheck;
import io.wispforest.accessories.api.EquipmentChecking;
import io.wispforest.accessories.api.slot.ExtraSlotTypeProperties;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.data.EntitySlotLoader;
import io.wispforest.accessories.endec.NbtMapCarrier;
import io.wispforest.accessories.impl.AccessoriesContainerImpl;
import io.wispforest.accessories.impl.AccessoriesHolderImpl;
import io.wispforest.accessories.impl.AccessoryNestUtils;
import io.wispforest.accessories.impl.ExpandedSimpleContainer;
import io.wispforest.accessories.impl.InstanceEndec;
import io.wispforest.accessories.networking.client.SyncEntireContainer;
import io.wispforest.endec.SerializationContext;
import io.wispforest.endec.util.MapCarrier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@ApiStatus.Internal
public class AccessoriesCapabilityImpl
implements AccessoriesCapability,
InstanceEndec {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final LivingEntity entity;
    private boolean updateContainersLock = false;

    public AccessoriesCapabilityImpl(LivingEntity entity) {
        this.entity = entity;
        this.getHolder();
    }

    @Override
    public LivingEntity entity() {
        return this.entity;
    }

    @Override
    public AccessoriesHolder getHolder() {
        AccessoriesHolderImpl holder = (AccessoriesHolderImpl)AccessoriesInternals.getHolder(this.entity);
        if (holder.loadedFromTag) {
            this.reset(true);
        }
        if (holder.getSlotContainers().size() != EntitySlotLoader.getEntitySlots(this.entity).size()) {
            holder.init(this);
        }
        return holder;
    }

    private AccessoriesHolderImpl holder() {
        return (AccessoriesHolderImpl)this.getHolder();
    }

    @Override
    public Map<String, AccessoriesContainer> getContainers() {
        Map<String, AccessoriesContainer> containers = this.holder().getSlotContainers();
        for (AccessoriesContainer container : containers.values()) {
            if (this.entity == container.capability().entity()) break;
            ((AccessoriesContainerImpl)container).capability = this;
        }
        return containers;
    }

    @Override
    public void reset(boolean loadedFromTag) {
        ServerPlayer serverPlayer;
        AccessoriesHolderImpl holder;
        block7: {
            block6: {
                Object currentContainers;
                if (this.entity.m_9236_().m_5776_()) {
                    return;
                }
                holder = (AccessoriesHolderImpl)AccessoriesInternals.getHolder(this.entity);
                if (!loadedFromTag) {
                    Map<String, AccessoriesContainer> oldContainers = Map.copyOf(holder.getSlotContainers());
                    holder.init(this);
                    currentContainers = holder.getSlotContainers();
                    oldContainers.forEach((arg_0, arg_1) -> AccessoriesCapabilityImpl.lambda$reset$0((Map)currentContainers, arg_0, arg_1));
                } else {
                    holder.init(this);
                }
                currentContainers = this.entity;
                if (!(currentContainers instanceof ServerPlayer)) break block6;
                serverPlayer = (ServerPlayer)currentContainers;
                if (serverPlayer.f_8906_ != null) break block7;
            }
            return;
        }
        NbtMapCarrier carrier = NbtMapCarrier.of();
        holder.write(carrier, SerializationContext.empty());
        AccessoriesInternals.getNetworkHandler().sendToTrackingAndSelf((Entity)serverPlayer, new SyncEntireContainer(serverPlayer.m_19879_(), carrier));
    }

    @Override
    public void updateContainers() {
        boolean hasUpdateOccurred;
        if (this.updateContainersLock) {
            return;
        }
        Collection<AccessoriesContainer> containers = this.getContainers().values();
        this.updateContainersLock = true;
        do {
            hasUpdateOccurred = false;
            for (AccessoriesContainer container : containers) {
                if (!container.hasChanged()) continue;
                container.update();
                hasUpdateOccurred = true;
            }
        } while (hasUpdateOccurred);
        this.updateContainersLock = false;
    }

    @Override
    public void addTransientSlotModifiers(Multimap<String, AttributeModifier> modifiers) {
        Map<String, AccessoriesContainer> containers = this.getContainers();
        for (Map.Entry entry : modifiers.asMap().entrySet()) {
            if (!containers.containsKey(entry.getKey())) continue;
            AccessoriesContainer container = containers.get(entry.getKey());
            ((Collection)entry.getValue()).forEach(container::addTransientModifier);
        }
    }

    @Override
    public void addPersistentSlotModifiers(Multimap<String, AttributeModifier> modifiers) {
        Map<String, AccessoriesContainer> containers = this.getContainers();
        for (Map.Entry entry : modifiers.asMap().entrySet()) {
            if (!containers.containsKey(entry.getKey())) continue;
            AccessoriesContainer container = containers.get(entry.getKey());
            ((Collection)entry.getValue()).forEach(container::addPersistentModifier);
        }
    }

    @Override
    public void removeSlotModifiers(Multimap<String, AttributeModifier> modifiers) {
        Map<String, AccessoriesContainer> containers = this.getContainers();
        for (Map.Entry entry : modifiers.asMap().entrySet()) {
            if (!containers.containsKey(entry.getKey())) continue;
            AccessoriesContainer container = containers.get(entry.getKey());
            ((Collection)entry.getValue()).forEach(modifier -> container.removeModifier(modifier.m_22209_()));
        }
    }

    @Override
    public Multimap<String, AttributeModifier> getSlotModifiers() {
        HashMultimap modifiers = HashMultimap.create();
        this.getContainers().forEach((arg_0, arg_1) -> AccessoriesCapabilityImpl.lambda$getSlotModifiers$2((Multimap)modifiers, arg_0, arg_1));
        return modifiers;
    }

    @Override
    public void clearSlotModifiers() {
        this.getContainers().forEach((s, container) -> container.clearModifiers());
    }

    @Override
    public void clearCachedSlotModifiers() {
        HashMultimap slotModifiers = HashMultimap.create();
        Map<String, AccessoriesContainer> containers = this.getContainers();
        containers.forEach((name, container) -> {
            Set<AttributeModifier> modifiers = container.getCachedModifiers();
            if (modifiers.isEmpty()) {
                return;
            }
            ExpandedSimpleContainer accessories = container.getAccessories();
            for (int i = 0; i < accessories.m_6643_(); ++i) {
                ItemStack stack = accessories.m_8020_(i);
                if (stack.m_41619_()) continue;
                SlotReference slotReference = container.createReference(i);
                slotModifiers.putAll(AccessoriesAPI.getAttributeModifiers(stack, slotReference).getSlotModifiers());
            }
        });
        slotModifiers.asMap().forEach((name, modifiers) -> {
            if (!containers.containsKey(name)) {
                return;
            }
            AccessoriesContainer container = (AccessoriesContainer)containers.get(name);
            modifiers.forEach(container.getCachedModifiers()::remove);
            container.clearCachedModifiers();
        });
    }

    public Map<AccessoriesContainer, Boolean> getUpdatingInventories() {
        return this.holder().containersRequiringUpdates;
    }

    @Override
    @Nullable
    public it.unimi.dsi.fastutil.Pair<SlotReference, EquipAction> canEquipAccessory(ItemStack stack, boolean allowSwapping, EquipCheck extraCheck) {
        Accessory accessory = AccessoriesAPI.getOrDefaultAccessory(stack);
        if (accessory == null) {
            return null;
        }
        HashMap<String, AccessoriesContainer> validContainers = new HashMap<String, AccessoriesContainer>();
        if (stack.m_41619_() && allowSwapping) {
            Map<String, AccessoriesContainer> allContainers = this.getContainers();
            EntitySlotLoader.getEntitySlots(this.entity()).forEach((s, slotType) -> validContainers.put((String)s, (AccessoriesContainer)allContainers.get(slotType.name())));
        } else {
            for (AccessoriesContainer container : this.getContainers().values()) {
                boolean isValid;
                if (container.getSize() <= 0 || !(isValid = AccessoriesAPI.canInsertIntoSlot(stack, container.createReference(0))) || !ExtraSlotTypeProperties.getProperty(container.getSlotName(), this.entity.m_9236_().f_46443_).allowEquipFromUse()) continue;
                if (allowSwapping) {
                    validContainers.put(container.getSlotName(), container);
                }
                ExpandedSimpleContainer accessories = container.getAccessories();
                for (int i = 0; i < container.getSize(); ++i) {
                    ItemStack slotStack = accessories.m_8020_(i);
                    SlotReference slotReference = container.createReference(i);
                    if (!slotStack.m_41619_() || !AccessoriesAPI.canUnequip(slotStack, slotReference) || !AccessoriesAPI.canInsertIntoSlot(stack, slotReference) || !extraCheck.isValid(slotStack, false)) continue;
                    return it.unimi.dsi.fastutil.Pair.of((Object)container.createReference(i), newStack -> this.setStack(slotReference, newStack, false));
                }
            }
        }
        for (AccessoriesContainer validContainer : validContainers.values()) {
            ExpandedSimpleContainer accessories = validContainer.getAccessories();
            for (int i = 0; i < accessories.m_6643_(); ++i) {
                ItemStack slotStack = accessories.m_8020_(i).m_41777_();
                SlotReference slotReference = validContainer.createReference(i);
                if (slotStack.m_41619_() || !AccessoriesAPI.canUnequip(slotStack, slotReference) || !stack.m_41619_() && (!AccessoriesAPI.canInsertIntoSlot(stack, slotReference) || !extraCheck.isValid(slotStack, true))) continue;
                return it.unimi.dsi.fastutil.Pair.of((Object)slotReference, newStack -> this.setStack(slotReference, newStack, true));
            }
        }
        return null;
    }

    private Optional<ItemStack> setStack(SlotReference reference, ItemStack newStack, boolean shouldSwapStacks) {
        ItemStack oldStack = reference.getStack().m_41777_();
        Accessory accessory = AccessoriesAPI.getOrDefaultAccessory(oldStack);
        if (shouldSwapStacks) {
            ItemStack splitStack;
            ItemStack itemStack = splitStack = newStack.m_41619_() ? ItemStack.f_41583_ : newStack.m_41620_(accessory.maxStackSize(newStack));
            if (!this.entity.m_9236_().f_46443_) {
                reference.setStack(splitStack);
            }
            return Optional.of(oldStack);
        }
        if (!this.entity.m_9236_().f_46443_) {
            ItemStack splitStack = newStack.m_41620_(accessory.maxStackSize(newStack));
            reference.setStack(splitStack);
        }
        return Optional.empty();
    }

    @Override
    public SlotEntryReference getFirstEquipped(Predicate<ItemStack> predicate, EquipmentChecking check) {
        for (AccessoriesContainer container : this.getContainers().values()) {
            for (Pair<Integer, ItemStack> stackEntry : container.getAccessories()) {
                SlotEntryReference entryReference;
                ItemStack cosmetic;
                ItemStack stack = (ItemStack)stackEntry.getSecond();
                SlotReference reference = container.createReference((Integer)stackEntry.getFirst());
                if (check == EquipmentChecking.COSMETICALLY_OVERRIDABLE && !(cosmetic = container.getCosmeticAccessories().m_8020_(reference.slot())).m_41619_()) {
                    stack = cosmetic;
                }
                if ((entryReference = AccessoryNestUtils.recursiveStackHandling(stack, reference, (innerStack, ref) -> !innerStack.m_41619_() && predicate.test((ItemStack)innerStack) ? new SlotEntryReference(reference, (ItemStack)innerStack) : null)) == null) continue;
                return entryReference;
            }
        }
        return null;
    }

    @Override
    public List<SlotEntryReference> getEquipped(Predicate<ItemStack> predicate) {
        return this.getAllEquipped().stream().filter(reference -> predicate.test(reference.stack())).toList();
    }

    @Override
    public List<SlotEntryReference> getAllEquipped(boolean recursiveStackLookup) {
        ArrayList<SlotEntryReference> references = new ArrayList<SlotEntryReference>();
        for (AccessoriesContainer container : this.getContainers().values()) {
            for (Pair<Integer, ItemStack> stackEntry : container.getAccessories()) {
                ItemStack stack = (ItemStack)stackEntry.getSecond();
                if (stack.m_41619_()) continue;
                SlotReference reference = container.createReference((Integer)stackEntry.getFirst());
                if (recursiveStackLookup) {
                    AccessoryNestUtils.recursiveStackConsumption(stack, reference, (innerStack, ref) -> references.add(new SlotEntryReference((SlotReference)ref, (ItemStack)innerStack)));
                    continue;
                }
                references.add(new SlotEntryReference(reference, stack));
            }
        }
        return references;
    }

    @Override
    public void write(MapCarrier carrier, SerializationContext ctx) {
        this.holder().write(carrier, ctx);
    }

    @Override
    public void read(MapCarrier carrier, SerializationContext ctx) {
        this.holder().read(carrier, ctx);
    }

    private static /* synthetic */ void lambda$getSlotModifiers$2(Multimap modifiers, String s, AccessoriesContainer container) {
        modifiers.putAll((Object)s, container.getModifiers().values());
    }

    private static /* synthetic */ void lambda$reset$0(Map currentContainers, String s, AccessoriesContainer oldContainer) {
        AccessoriesContainer currentContainer = (AccessoriesContainer)currentContainers.get(s);
        currentContainer.getAccessories().setFromPrev(oldContainer.getAccessories());
        currentContainer.markChanged(false);
    }
}

