/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.neoforge;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.commands.AccessoriesCommands;
import io.wispforest.accessories.data.EntitySlotLoader;
import io.wispforest.accessories.data.SlotGroupLoader;
import io.wispforest.accessories.data.SlotTypeLoader;
import io.wispforest.accessories.endec.CodecUtils;
import io.wispforest.accessories.forge.AccessoriesInternalsImpl;
import io.wispforest.accessories.impl.AccessoriesEventHandler;
import io.wispforest.accessories.impl.AccessoriesHolderImpl;
import io.wispforest.accessories.impl.InstanceEndec;
import io.wispforest.accessories.neoforge.AccessoriesForgeNetworkHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.attachment.v1.AttachmentRegistry;
import net.fabricmc.fabric.api.attachment.v1.AttachmentType;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.RegisterEvent;
import org.slf4j.Logger;

@Mod(value="accessories")
public class AccessoriesForge {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final AttachmentType<AccessoriesHolderImpl> HOLDER_ATTACHMENT_TYPE = AttachmentRegistry.builder().initializer(AccessoriesHolderImpl::of).persistent(CodecUtils.ofEndec(InstanceEndec.constructed(AccessoriesHolderImpl::new))).copyOnDeath().buildAndRegister(Accessories.of("inventory_holder"));
    public static IEventBus BUS;

    public AccessoriesForge() {
        IEventBus eventBus;
        BUS = eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        Accessories.init();
        MinecraftForge.EVENT_BUS.addListener(this::attemptEquipFromUse);
        MinecraftForge.EVENT_BUS.addListener(this::attemptEquipOnEntity);
        MinecraftForge.EVENT_BUS.addListener(this::onEntityDeath);
        MinecraftForge.EVENT_BUS.addListener(this::onLivingEntityTick);
        MinecraftForge.EVENT_BUS.addListener(this::onDataSync);
        MinecraftForge.EVENT_BUS.addListener(this::onEntityLoad);
        MinecraftForge.EVENT_BUS.addListener(this::onStartTracking);
        MinecraftForge.EVENT_BUS.addListener(this::onWorldTick);
        MinecraftForge.EVENT_BUS.addListener(this::registerCommands);
        eventBus.register((Object)AccessoriesForgeNetworkHandler.INSTANCE);
        eventBus.addListener(this::registerStuff);
        MinecraftForge.EVENT_BUS.addListener(this::registerReloadListeners);
        MinecraftForge.EVENT_BUS.addListener(event -> {
            Player patt0$temp = event.getEntity();
            if (!(patt0$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
            AccessoriesEventHandler.onTracking((LivingEntity)serverPlayer, serverPlayer);
        });
        AccessoriesForgeNetworkHandler.INSTANCE.initializeNetworking();
        eventBus.addListener(event -> {
            Accessories.registerCriteria();
            Accessories.RULE_KEEP_ACCESSORY_INVENTORY = GameRules.m_46189_((String)"accessories.keepAccessoryInventory", (GameRules.Category)GameRules.Category.PLAYER, (GameRules.Type)GameRules.BooleanValue.m_46250_((boolean)false));
        });
    }

    public void registerCommands(RegisterCommandsEvent event) {
        AccessoriesCommands.registerCommands((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext());
    }

    public void registerStuff(RegisterEvent event) {
        event.register(Registries.f_256798_, helper -> Accessories.registerMenuType());
        event.register(Registries.f_256982_, helper -> AccessoriesCommands.registerCommandArgTypes());
    }

    public void registerReloadListeners(AddReloadListenerEvent event) {
        this.intermediateRegisterListeners(arg_0 -> ((AddReloadListenerEvent)event).addListener(arg_0));
        AccessoriesInternalsImpl.setContext(event.getConditionContext());
    }

    public void intermediateRegisterListeners(Consumer<PreparableReloadListener> registrationMethod) {
        registrationMethod.accept((PreparableReloadListener)SlotTypeLoader.INSTANCE);
        registrationMethod.accept((PreparableReloadListener)EntitySlotLoader.INSTANCE);
        registrationMethod.accept((PreparableReloadListener)SlotGroupLoader.INSTANCE);
        registrationMethod.accept((PreparableReloadListener)new SimplePreparableReloadListener<Void>(){

            protected Void prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
                return null;
            }

            protected void apply(Void object, ResourceManager resourceManager, ProfilerFiller profiler) {
                AccessoriesEventHandler.dataReloadOccurred = true;
                AccessoriesInternalsImpl.setContext(null);
            }
        });
    }

    public void attemptEquipFromUse(PlayerInteractEvent.RightClickItem event) {
        InteractionResultHolder<ItemStack> resultHolder = AccessoriesEventHandler.attemptEquipFromUse(event.getEntity(), event.getHand());
        if (!resultHolder.m_19089_().m_19077_()) {
            return;
        }
        event.getEntity().m_21008_(event.getHand(), (ItemStack)resultHolder.m_19095_());
        event.setCancellationResult(resultHolder.m_19089_());
    }

    public void attemptEquipOnEntity(PlayerInteractEvent.EntityInteract event) {
        AccessoriesEventHandler.attemptEquipOnEntity(event.getEntity(), event.getHand(), event.getTarget());
    }

    public void onEntityDeath(LivingDropsEvent event) {
        List<ItemStack> stacks = AccessoriesEventHandler.onDeath(event.getEntity(), event.getSource());
        event.getDrops().addAll(stacks.stream().flatMap(itemStack -> {
            Vec3 pos = event.getEntity().m_20182_();
            return AccessoriesForge.getItemEntities(event.getEntity().m_9236_(), pos.f_82479_, pos.f_82480_, pos.f_82481_, itemStack);
        }).toList());
    }

    private static Stream<ItemEntity> getItemEntities(Level level, double x, double y, double z, ItemStack stack) {
        double d = EntityType.f_20461_.m_20678_();
        double e = 1.0 - d;
        double f = d / 2.0;
        double g = Math.floor(x) + level.f_46441_.m_188500_() * e + f;
        double h = Math.floor(y) + level.f_46441_.m_188500_() * e;
        double i = Math.floor(z) + level.f_46441_.m_188500_() * e + f;
        ArrayList<ItemEntity> itemEntities = new ArrayList<ItemEntity>();
        while (!stack.m_41619_()) {
            ItemEntity itemEntity = new ItemEntity(level, g, h, i, stack.m_41620_(level.f_46441_.m_188503_(21) + 10));
            itemEntity.m_20334_(level.f_46441_.m_216328_(0.0, 0.11485000171139836), level.f_46441_.m_216328_(0.2, 0.11485000171139836), level.f_46441_.m_216328_(0.0, 0.11485000171139836));
            itemEntities.add(itemEntity);
        }
        return itemEntities.stream();
    }

    public void onLivingEntityTick(LivingEvent.LivingTickEvent event) {
        AccessoriesEventHandler.onLivingEntityTick(event.getEntity());
    }

    public void onDataSync(OnDatapackSyncEvent event) {
        ServerPlayer player = event.getPlayer();
        AccessoriesEventHandler.dataSync(player == null ? event.getPlayerList() : null, player);
    }

    public void onEntityLoad(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        AccessoriesEventHandler.entityLoad(livingEntity, event.getLevel());
    }

    public void onStartTracking(PlayerEvent.StartTracking event) {
        Entity entity = event.getTarget();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        AccessoriesEventHandler.onTracking(livingEntity, (ServerPlayer)event.getEntity());
    }

    public void onWorldTick(TickEvent.LevelTickEvent event) {
        if (!event.phase.equals((Object)TickEvent.Phase.START)) {
            return;
        }
        AccessoriesEventHandler.onWorldTick(event.level);
    }
}

