/*
 * Decompiled with CFR 0.152.
 */
package net.untitledduckmod.common.init.forge;

import net.minecraft.core.Holder;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.untitledduckmod.common.config.UntitledConfig;
import net.untitledduckmod.common.entity.CustomSpawnGroup;
import net.untitledduckmod.common.entity.DuckEntity;
import net.untitledduckmod.common.entity.GooseEntity;
import net.untitledduckmod.common.init.ModEntityTypes;
import net.untitledduckmod.common.init.ModTags;

public class ModEntityTypesImpl {
    public static void registerAttributes(Object optionalEvent) {
        if (optionalEvent instanceof EntityAttributeCreationEvent) {
            EntityAttributeCreationEvent event = (EntityAttributeCreationEvent)optionalEvent;
            event.put(ModEntityTypes.getDuck(), DuckEntity.getDefaultAttributes().m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 3.0).m_22265_());
            event.put(ModEntityTypes.getGoose(), GooseEntity.getDefaultAttributes().m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 3.0).m_22265_());
        }
    }

    public static void setupSpawning(Object optionalEvent) {
        if (optionalEvent instanceof SpawnPlacementRegisterEvent) {
            SpawnPlacementRegisterEvent event = (SpawnPlacementRegisterEvent)optionalEvent;
            event.register(ModEntityTypes.getDuck(), SpawnPlacements.Type.NO_RESTRICTIONS, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, DuckEntity::checkDuckSpawnRules, SpawnPlacementRegisterEvent.Operation.OR);
            event.register(ModEntityTypes.getGoose(), SpawnPlacements.Type.NO_RESTRICTIONS, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, GooseEntity::checkGooseSpawnRules, SpawnPlacementRegisterEvent.Operation.OR);
        }
    }

    public static void addBiomeSpawns(Holder<Biome> biome, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (biome.m_203656_(ModTags.BiomeTags.DUCK_BIOMES)) {
            builder.getMobSpawnSettings().getSpawner(CustomSpawnGroup.WATERFOWL.spawnGroup).add(new MobSpawnSettings.SpawnerData(ModEntityTypes.getDuck(), UntitledConfig.duckWeight(), UntitledConfig.duckMinGroupSize(), UntitledConfig.duckMaxGroupSize()));
        }
        if (biome.m_203656_(ModTags.BiomeTags.GOOSE_BIOMES)) {
            builder.getMobSpawnSettings().getSpawner(CustomSpawnGroup.WATERFOWL.spawnGroup).add(new MobSpawnSettings.SpawnerData(ModEntityTypes.getGoose(), UntitledConfig.gooseWeight(), UntitledConfig.gooseMinGroupSize(), UntitledConfig.gooseMaxGroupSize()));
        }
    }
}

