/*
 * Decompiled with CFR 0.152.
 */
package fuzs.visualworkbench.world.level.block.entity;

import fuzs.visualworkbench.VisualWorkbench;
import fuzs.visualworkbench.config.ClientConfig;
import fuzs.visualworkbench.init.ModRegistry;
import fuzs.visualworkbench.util.MathHelper;
import fuzs.visualworkbench.world.inventory.ModCraftingMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class CraftingTableBlockEntity
extends BaseContainerBlockEntity {
    private static final String TAG_LAST_RECIPE = "LastRecipe";
    private final NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_);
    private ItemStack lastResult = ItemStack.f_41583_;
    public int ticks;
    public float currentAngle;
    public float nextAngle;
    private int sector;
    private boolean animating;
    private float animationAngleStart;
    private float animationAngleEnd;
    private double startTicks;
    private double playerAngle;

    public CraftingTableBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModRegistry.CRAFTING_TABLE_BLOCK_ENTITY.get(), pos, state);
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"container.crafting");
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inventory.clear();
        ContainerHelper.m_18980_((CompoundTag)tag, this.inventory);
        this.lastResult = tag.m_128441_(TAG_LAST_RECIPE) ? ItemStack.m_41712_((CompoundTag)tag.m_128469_(TAG_LAST_RECIPE)) : ItemStack.f_41583_;
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ContainerHelper.m_18976_((CompoundTag)tag, this.inventory, (boolean)true);
        if (!this.lastResult.m_41619_()) {
            CompoundTag compoundTag = new CompoundTag();
            this.lastResult.m_41739_(compoundTag);
            tag.m_128365_(TAG_LAST_RECIPE, (Tag)compoundTag);
        }
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public boolean m_7013_(int slot, ItemStack stack) {
        ItemStack itemStackInSlot = (ItemStack)this.inventory.get(slot);
        if (itemStackInSlot.m_41619_()) {
            return !this.smallerStackExist(stack.m_41741_(), stack, -1);
        }
        return !this.smallerStackExist(itemStackInSlot.m_41613_(), itemStackInSlot, slot);
    }

    private boolean smallerStackExist(int currentSize, ItemStack itemStackInSlot, int slot) {
        for (int i = slot + 1; i < this.m_6643_(); ++i) {
            ItemStack itemStack = this.m_8020_(i);
            if (itemStack.m_41619_() || itemStack.m_41613_() >= currentSize || !ItemStack.m_150942_((ItemStack)itemStack, (ItemStack)itemStackInSlot)) continue;
            return true;
        }
        return false;
    }

    public boolean m_271862_(Container target, int slot, ItemStack stack) {
        return false;
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public int m_6643_() {
        return this.inventory.size();
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.inventory) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int index) {
        return index >= 0 && index < this.inventory.size() ? (ItemStack)this.inventory.get(index) : ItemStack.f_41583_;
    }

    public ItemStack m_7407_(int index, int count) {
        ItemStack itemStack = ContainerHelper.m_18969_(this.inventory, (int)index, (int)count);
        if (!itemStack.m_41619_()) {
            this.m_6596_();
        }
        return itemStack;
    }

    public ItemStack m_8016_(int index) {
        ItemStack itemStack = ContainerHelper.m_18966_(this.inventory, (int)index);
        if (!itemStack.m_41619_()) {
            this.m_6596_();
        }
        return itemStack;
    }

    public void m_6836_(int index, ItemStack stack) {
        if (index >= 0 && index < this.inventory.size()) {
            this.inventory.set(index, (Object)stack);
            this.m_6596_();
        }
    }

    public boolean m_6542_(Player player) {
        if (this.m_58904_().m_7702_(this.f_58858_) != this) {
            return false;
        }
        return !(player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) > 64.0);
    }

    protected AbstractContainerMenu m_6555_(int id, Inventory playerInventory) {
        return new ModCraftingMenu(id, playerInventory, (Container)this, ContainerLevelAccess.m_39289_((Level)this.m_58904_(), (BlockPos)this.m_58899_()), this::setLastResult);
    }

    public void m_6211_() {
        this.inventory.clear();
    }

    public ItemStack getLastResult() {
        return this.lastResult;
    }

    private void setLastResult(ItemStack lastResult) {
        this.lastResult = lastResult;
        this.m_6596_();
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, CraftingTableBlockEntity blockEntity) {
        int sector;
        ++blockEntity.ticks;
        if (blockEntity.m_7983_() || !((ClientConfig)VisualWorkbench.CONFIG.get(ClientConfig.class)).rotateIngredients) {
            return;
        }
        Player player = level.m_45924_((double)blockEntity.f_58858_.m_123341_() + 0.5, (double)blockEntity.f_58858_.m_123342_() + 0.5, (double)blockEntity.f_58858_.m_123343_() + 0.5, 3.0, false);
        if (player != null) {
            double d0 = player.m_20185_() - ((double)blockEntity.f_58858_.m_123341_() + 0.5);
            double d1 = player.m_20189_() - ((double)blockEntity.f_58858_.m_123343_() + 0.5);
            blockEntity.playerAngle = (Math.atan2(-d0, -d1) + 3.9269908169872414) % (Math.PI * 2);
        }
        if (blockEntity.sector != (sector = (int)(blockEntity.playerAngle * 2.0 / Math.PI))) {
            blockEntity.animating = true;
            blockEntity.animationAngleStart = blockEntity.currentAngle;
            float delta1 = (float)sector * 90.0f - blockEntity.currentAngle;
            float abs1 = Math.abs(delta1);
            float delta2 = delta1 + 360.0f;
            float shift = Math.abs(delta2);
            float delta3 = delta1 - 360.0f;
            float abs3 = Math.abs(delta3);
            blockEntity.animationAngleEnd = abs3 < abs1 && abs3 < shift ? delta3 + blockEntity.currentAngle : (shift < abs1 && shift < abs3 ? delta2 + blockEntity.currentAngle : delta1 + blockEntity.currentAngle);
            blockEntity.startTicks = blockEntity.ticks;
            blockEntity.sector = sector;
        }
        if (blockEntity.animating) {
            if ((double)blockEntity.ticks >= blockEntity.startTicks + 20.0) {
                blockEntity.animating = false;
                blockEntity.currentAngle = blockEntity.nextAngle = (blockEntity.animationAngleEnd + 360.0f) % 360.0f;
            } else {
                blockEntity.currentAngle = (MathHelper.easeOutQuad((double)blockEntity.ticks - blockEntity.startTicks, blockEntity.animationAngleStart, blockEntity.animationAngleEnd - blockEntity.animationAngleStart, 20.0) + 360.0f) % 360.0f;
                blockEntity.nextAngle = (MathHelper.easeOutQuad(Math.min((double)(blockEntity.ticks + 1) - blockEntity.startTicks, 20.0), blockEntity.animationAngleStart, blockEntity.animationAngleEnd - blockEntity.animationAngleStart, 20.0) + 360.0f) % 360.0f;
                if (blockEntity.currentAngle != 0.0f || blockEntity.nextAngle != 0.0f) {
                    if (blockEntity.currentAngle == 0.0f && blockEntity.nextAngle >= 180.0f) {
                        blockEntity.currentAngle = 360.0f;
                    }
                    if (blockEntity.nextAngle == 0.0f && blockEntity.currentAngle >= 180.0f) {
                        blockEntity.nextAngle = 360.0f;
                    }
                }
            }
        }
    }
}

