/*
 * Decompiled with CFR 0.152.
 */
package net.lavabucket.hourglass.client.gui;

import com.mojang.serialization.Codec;
import java.util.Arrays;
import net.lavabucket.hourglass.client.gui.ScreenAlignment;
import net.lavabucket.hourglass.config.HourglassConfig;
import net.lavabucket.hourglass.wrappers.TextWrapper;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.OptionsList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.event.lifecycle.FMLConstructModEvent;

public final class ConfigScreen
extends Screen {
    private static final int TITLE_MARGIN = 8;
    private static final int OPTIONS_LIST_MARGIN = 24;
    private static final int OPTIONS_LIST_BOTTOM_MARGIN = 32;
    private static final int OPTION_HEIGHT = 25;
    private static final int BUTTON_WIDTH = 200;
    private static final int BUTTON_HEIGHT = 20;
    private static final int DONE_BUTTON_BOTTOM_MARGIN = 6;
    private static final String KEY_TITLE = "hourglass.configgui.title";
    private static final String KEY_CLOCK_ALIGNMENT = "hourglass.configgui.clockAlignment";
    private static final String KEY_CLOCK_SCALE = "hourglass.configgui.clockScale";
    private static final String KEY_CLOCK_MARGIN = "hourglass.configgui.clockMargin";
    private static final String KEY_PREVENT_CLOCK_WOBBLE = "hourglass.configgui.preventClockWobble";
    private static final String KEY_PIXELS = "hourglass.configgui.pixels";
    private static final String KEY_DONE = "gui.done";
    private static final String KEY_GENERIC_OPTION = "options.generic_value";
    protected Screen lastScreen;
    protected OptionsList optionsList;
    protected Button doneButton;
    private ScreenAlignment clockAlignment;
    private int clockScale;
    private int clockMargin;
    private boolean preventClockWobble;

    @SubscribeEvent
    public static void onConstructModEvent(FMLConstructModEvent event) {
        ModLoadingContext context = ModLoadingContext.get();
        context.registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((mc, screen) -> new ConfigScreen((Screen)screen)));
    }

    public ConfigScreen(Screen lastScreen) {
        super((Component)TextWrapper.translation(KEY_TITLE).get());
        this.lastScreen = lastScreen;
    }

    protected void m_7856_() {
        this.fetchSettings();
        this.optionsList = new OptionsList(this.f_96541_, this.f_96543_, this.f_96544_, 24, this.f_96544_ - 32, 25);
        this.optionsList.m_232528_(new OptionInstance(KEY_CLOCK_ALIGNMENT, OptionInstance.m_231498_(), (i, value) -> (Component)TextWrapper.translation(value.getKey()).get(), (OptionInstance.ValueSet)new OptionInstance.Enum(Arrays.asList(ScreenAlignment.values()), Codec.STRING.xmap(ScreenAlignment::valueOf, Enum::name)), (Object)this.clockAlignment, value -> {
            this.clockAlignment = value;
        }));
        this.optionsList.m_232528_(new OptionInstance(KEY_CLOCK_SCALE, OptionInstance.m_231498_(), (i, value) -> (Component)ConfigScreen.pixelOptionText(KEY_CLOCK_SCALE, value).get(), (OptionInstance.ValueSet)new OptionInstance.IntRange(0, 128).m_231657_(value -> value, value -> value.intValue()), Codec.doubleRange((double)0.0, (double)128.0), (Object)this.clockScale, value -> {
            this.clockScale = value.intValue();
        }));
        this.optionsList.m_232528_(new OptionInstance(KEY_CLOCK_MARGIN, OptionInstance.m_231498_(), (i, value) -> (Component)ConfigScreen.pixelOptionText(KEY_CLOCK_MARGIN, value).get(), (OptionInstance.ValueSet)new OptionInstance.IntRange(0, 128).m_231657_(value -> value, value -> value.intValue()), Codec.doubleRange((double)0.0, (double)128.0), (Object)this.clockMargin, value -> {
            this.clockMargin = value.intValue();
        }));
        this.optionsList.m_232528_(OptionInstance.m_231528_((String)KEY_PREVENT_CLOCK_WOBBLE, (boolean)this.preventClockWobble, value -> {
            this.preventClockWobble = value;
        }));
        this.m_7787_((GuiEventListener)this.optionsList);
        int doneX = (this.f_96543_ - 200) / 2;
        int doneY = this.f_96544_ - 20 - 6;
        TextWrapper doneText = TextWrapper.translation(KEY_DONE);
        this.doneButton = Button.m_253074_((Component)((Component)doneText.get()), button -> this.m_7379_()).m_252794_(doneX, doneY).m_253046_(200, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.doneButton);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        this.optionsList.m_88315_(graphics, mouseX, mouseY, partialTicks);
        graphics.m_280137_(this.f_96547_, this.f_96539_.getString(), this.f_96543_ / 2, 8, 0xFFFFFF);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
    }

    public void m_7379_() {
        this.saveSettings();
        if (this.f_96541_ != null) {
            this.f_96541_.m_91152_(this.lastScreen);
        }
    }

    private void fetchSettings() {
        this.clockAlignment = (ScreenAlignment)((Object)HourglassConfig.CLIENT_CONFIG.clockAlignment.get());
        this.clockScale = (Integer)HourglassConfig.CLIENT_CONFIG.clockScale.get();
        this.clockMargin = (Integer)HourglassConfig.CLIENT_CONFIG.clockMargin.get();
        this.preventClockWobble = (Boolean)HourglassConfig.CLIENT_CONFIG.preventClockWobble.get();
    }

    private void saveSettings() {
        HourglassConfig.CLIENT_CONFIG.clockAlignment.set((Object)this.clockAlignment);
        HourglassConfig.CLIENT_CONFIG.clockScale.set((Object)this.clockScale);
        HourglassConfig.CLIENT_CONFIG.clockMargin.set((Object)this.clockMargin);
        HourglassConfig.CLIENT_CONFIG.preventClockWobble.set((Object)this.preventClockWobble);
    }

    public static TextWrapper pixelOptionText(String key, double pixelCount) {
        return TextWrapper.translation(KEY_GENERIC_OPTION, TextWrapper.translation(key).get(), TextWrapper.translation(KEY_PIXELS, (int)pixelCount).get());
    }
}

