/*
 * Decompiled with CFR 0.152.
 */
package net.lavabucket.hourglass.command.config;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.lavabucket.hourglass.command.config.ConfigCommandEntry;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.server.command.EnumArgument;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigCommand {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final Map<String, ConfigCommandEntry<?>> entries = new HashMap();
    protected BiConsumer<CommandContext<CommandSourceStack>, ConfigCommandEntry<?>> querySuccessHandler;
    protected BiConsumer<CommandContext<CommandSourceStack>, ConfigCommandEntry<?>> modifySuccessHandler;
    protected BiConsumer<CommandContext<CommandSourceStack>, ConfigCommandEntry<?>> modifyFailureHandler;

    public ConfigCommand register(ForgeConfigSpec.IntValue configValue) {
        return this.register((ForgeConfigSpec.ConfigValue)configValue, (ArgumentType)IntegerArgumentType.integer(), (Class)Integer.class);
    }

    public ConfigCommand register(ForgeConfigSpec.IntValue configValue, ArgumentType<Integer> argumentType) {
        return this.register((ForgeConfigSpec.ConfigValue)configValue, (ArgumentType)argumentType, (Class)Integer.class);
    }

    public ConfigCommand register(ForgeConfigSpec.DoubleValue configValue) {
        return this.register((ForgeConfigSpec.ConfigValue)configValue, (ArgumentType)DoubleArgumentType.doubleArg(), (Class)Double.class);
    }

    public ConfigCommand register(ForgeConfigSpec.DoubleValue configValue, ArgumentType<Double> argumentType) {
        return this.register((ForgeConfigSpec.ConfigValue)configValue, (ArgumentType)argumentType, (Class)Double.class);
    }

    public ConfigCommand register(ForgeConfigSpec.BooleanValue configValue) {
        return this.register((ForgeConfigSpec.ConfigValue)configValue, (ArgumentType)BoolArgumentType.bool(), (Class)Boolean.class);
    }

    public <T extends Enum<T>> ConfigCommand register(ForgeConfigSpec.EnumValue<T> configValue, Class<T> valueClass) {
        return this.register((ForgeConfigSpec.ConfigValue<T>)configValue, (ArgumentType<T>)EnumArgument.enumArgument(valueClass), valueClass);
    }

    public <T> ConfigCommand register(ForgeConfigSpec.ConfigValue<T> configValue, ArgumentType<T> argumentType, Class<T> valueClass) {
        return this.register(new ConfigCommandEntry<T>(configValue, argumentType, valueClass));
    }

    public <T> ConfigCommand register(ConfigCommandEntry<T> entry) {
        this.entries.put(entry.getIdentifier(), entry);
        return this;
    }

    public ConfigCommand setQuerySuccessHandler(BiConsumer<CommandContext<CommandSourceStack>, ConfigCommandEntry<?>> listener) {
        this.querySuccessHandler = listener;
        return this;
    }

    public ConfigCommand setModifySuccessHandler(BiConsumer<CommandContext<CommandSourceStack>, ConfigCommandEntry<?>> listener) {
        this.modifySuccessHandler = listener;
        return this;
    }

    public ConfigCommand setModifyFailureHandler(BiConsumer<CommandContext<CommandSourceStack>, ConfigCommandEntry<?>> listener) {
        this.modifyFailureHandler = listener;
        return this;
    }

    public ArgumentBuilder<CommandSourceStack, ?> build(ArgumentBuilder<CommandSourceStack, ?> parent) {
        for (ConfigCommandEntry<?> entry : this.entries.values()) {
            parent.then(((LiteralArgumentBuilder)Commands.m_82127_((String)entry.getIdentifier()).then(entry.createArgument().executes(context -> this.modifyConfigCommand((CommandContext<CommandSourceStack>)context, entry)))).executes(context -> this.queryConfigCommand((CommandContext<CommandSourceStack>)context, entry)));
        }
        return parent;
    }

    protected <T> int queryConfigCommand(CommandContext<CommandSourceStack> context, ConfigCommandEntry<T> entry) {
        if (this.querySuccessHandler != null) {
            this.querySuccessHandler.accept(context, entry);
            return 1;
        }
        return 0;
    }

    protected <T> int modifyConfigCommand(CommandContext<CommandSourceStack> context, ConfigCommandEntry<T> entry) {
        T argument;
        try {
            argument = entry.getArgument(context);
        }
        catch (IllegalArgumentException e) {
            if (this.modifyFailureHandler != null) {
                LOGGER.error("Command failed to fetch config argument.", (Throwable)e);
                this.modifyFailureHandler.accept(context, entry);
                return 0;
            }
            throw e;
        }
        try {
            entry.getConfigValue().set(argument);
        }
        catch (Exception e) {
            if (this.modifyFailureHandler != null) {
                LOGGER.error("Command failed to set config to value: " + argument, (Throwable)e);
                this.modifyFailureHandler.accept(context, entry);
                return 0;
            }
            throw e;
        }
        if (this.modifySuccessHandler != null) {
            this.modifySuccessHandler.accept(context, entry);
        }
        return 1;
    }
}

