/*
 * Decompiled with CFR 0.152.
 */
package mc.recraftors.blahaj;

import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mc.recraftors.blahaj.item.CuddlyItem;
import mc.recraftors.unruled_api.UnruledApi;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Blahaj {
    public static final ResourceLocation BLAHAJ_ID;
    public static final ResourceLocation KLAPPAR_HAJ_ID;
    public static final ResourceLocation BEYOU_BLAHAJ_ID;
    public static final ResourceLocation BLAVINGAD_ID;
    public static final ResourceLocation ORCA_HAJ_ID;
    public static final ResourceLocation BREAD_ID;
    public static final ResourceLocation SEAL_ID;
    public static final ResourceLocation NON_CONTAINABLE_ITEMS_TAG_ID;
    public static final ResourceLocation BLAVINGAD_USABLE_ITEMS_ID;
    public static final TagKey<Item> NON_CONTAINABLE_ITEMS;
    public static final TagKey<Item> BLAVINGAD_USABLE_ITEMS;
    public static final GameRules.Key<GameRules.BooleanValue> ENABLE_CONTAINER_USE;
    public static final String MOD_ID = "blahaj";
    public static final String TOOLTIP_PRE;
    private static final Map<ResourceLocation, CuddlyItem> ITEM_MAP;
    public static final Logger LOGGER;

    public static void init() {
        Blahaj.injectTrades();
    }

    public static void storeItem(ResourceLocation id, CuddlyItem item) {
        Objects.requireNonNull(id);
        Objects.requireNonNull(item);
        ITEM_MAP.put(id, item);
    }

    public static Collection<CuddlyItem> getItems() {
        return ITEM_MAP.values();
    }

    public static Optional<CuddlyItem> itemSupplier(ResourceLocation id) {
        return Optional.ofNullable(ITEM_MAP.get(id));
    }

    public static void injectTrades() {
        Optional<CuddlyItem> blahajSupplier = Blahaj.itemSupplier(BLAHAJ_ID);
        Optional<CuddlyItem> klapparSupplier = Blahaj.itemSupplier(KLAPPAR_HAJ_ID);
        Optional<CuddlyItem> beyouSupplier = Blahaj.itemSupplier(BEYOU_BLAHAJ_ID);
        klapparSupplier.ifPresent(klappar -> VillagerTrades.f_35627_.computeIfAbsent(VillagerProfession.f_35597_, key -> new Int2ObjectLinkedOpenHashMap()).compute(5, (i, v) -> {
            v = v == null ? new VillagerTrades.ItemListing[1] : Arrays.copyOf(v, ((VillagerTrades.ItemListing[])v).length + 1);
            v[v.length - 1] = (entity, random) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 15), new ItemStack((ItemLike)klappar), 2, 30, 0.1f);
            return v;
        }));
        beyouSupplier.ifPresent(beyou -> {
            if (blahajSupplier.isEmpty()) {
                return;
            }
            VillagerTrades.f_35627_.computeIfAbsent(VillagerProfession.f_35593_, key -> new Int2ObjectLinkedOpenHashMap()).compute(4, (i, v) -> {
                v = v == null ? new VillagerTrades.ItemListing[1] : Arrays.copyOf(v, ((VillagerTrades.ItemListing[])v).length + 1);
                v[v.length - 1] = (entity, random) -> new MerchantOffer(new ItemStack((ItemLike)blahajSupplier.get(), 1), new ItemStack((ItemLike)Items.f_42616_, 20), new ItemStack((ItemLike)beyou), 2, 20, 0.1f);
                return v;
            });
        });
    }

    public static void injectTable(LootTable table, Item item, int weight, int total) {
        LootPool[] initPools = (LootPool[])((Supplier)table).get();
        int i = initPools.length;
        LootPool[] pools = new LootPool[i + 1];
        System.arraycopy(initPools, 0, pools, 0, i);
        pools[i] = LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)item).m_79707_(weight)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41852_).m_79707_(total - weight)).m_79082_();
        ((Consumer)table).accept(pools);
    }

    public static boolean holdsOnlyCuddlyItem(LivingEntity entity) {
        return entity.m_21205_().m_41720_() instanceof CuddlyItem && entity.m_21206_().m_41619_() || entity.m_21206_().m_41720_() instanceof CuddlyItem && entity.m_21205_().m_41619_();
    }

    static {
        TOOLTIP_PRE = String.format("item.%s.%%s.tooltip", MOD_ID);
        BLAHAJ_ID = new ResourceLocation(MOD_ID, "blue_shark");
        KLAPPAR_HAJ_ID = new ResourceLocation(MOD_ID, "gray_shark");
        BEYOU_BLAHAJ_ID = new ResourceLocation(MOD_ID, "trans_shark");
        BLAVINGAD_ID = new ResourceLocation(MOD_ID, "blue_whale");
        ORCA_HAJ_ID = new ResourceLocation(MOD_ID, "killer_whale");
        SEAL_ID = new ResourceLocation(MOD_ID, "seal");
        BREAD_ID = new ResourceLocation(MOD_ID, "bread");
        NON_CONTAINABLE_ITEMS_TAG_ID = new ResourceLocation(MOD_ID, "not_containable");
        BLAVINGAD_USABLE_ITEMS_ID = new ResourceLocation(MOD_ID, "blavingad_usable");
        NON_CONTAINABLE_ITEMS = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)NON_CONTAINABLE_ITEMS_TAG_ID);
        BLAVINGAD_USABLE_ITEMS = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)BLAVINGAD_USABLE_ITEMS_ID);
        ENABLE_CONTAINER_USE = UnruledApi.registerBoolean((String)"blahaj.contained.enable_use", (GameRules.Category)GameRules.Category.PLAYER, (boolean)false);
        ITEM_MAP = new HashMap<ResourceLocation, CuddlyItem>();
        LOGGER = LogManager.getLogger((String)MOD_ID);
    }
}

