/*
 * Decompiled with CFR 0.152.
 */
package mc.recraftors.blahaj.item;

import com.google.common.collect.Multimap;
import java.util.List;
import java.util.function.Consumer;
import mc.recraftors.blahaj.item.ItemContainerCuddlyItem;
import mc.recraftors.blahaj.item.ItemStackProvider;
import mc.recraftors.blahaj.item.nbt.ContainedNbtCompound;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import org.jetbrains.annotations.Nullable;

public final class ContainedItemStack
extends ItemStack
implements ItemStackProvider {
    private final ItemStack current;
    private final ItemStack parent;
    private final ItemContainerCuddlyItem containerItem;
    private ContainedNbtCompound nbt;

    public ContainedItemStack(ItemStack container, ItemStack content) {
        super((ItemLike)content.m_41720_(), content.m_41613_());
        Item item = container.m_41720_();
        if (!(item instanceof ItemContainerCuddlyItem)) {
            throw new UnsupportedOperationException("Cannot contain from a non-container class");
        }
        ItemContainerCuddlyItem cuddly = (ItemContainerCuddlyItem)item;
        cuddly = (ItemContainerCuddlyItem)Item.m_41445_((int)BuiltInRegistries.f_257033_.m_7447_((Object)cuddly));
        this.current = cuddly.getContainedStack(container);
        this.parent = container;
        this.containerItem = cuddly;
    }

    public void dirty() {
        Player player;
        Entity entity = this.m_41609_();
        if (entity instanceof Player && (player = (Player)entity).m_7500_()) {
            return;
        }
        if (this.parent == null) {
            return;
        }
        this.containerItem.extract(this.parent);
        this.containerItem.setContent(this.parent, this.containerItem.getContainedStack(this.parent));
    }

    public boolean isContainerEmpty() {
        return this.containerItem.getContainedStack(this.parent).m_41619_();
    }

    public void tryInsertOrDrop(LivingEntity entity, ItemStack target) {
        if (target.m_41619_() || this == target) {
            return;
        }
        if (this.isContainerEmpty()) {
            this.containerItem.setContent(this.containerItem.getContainedStack(this.parent), target);
        } else {
            if (entity.m_142389_() && ((Player)entity).m_7500_() && target.m_150930_(this.containerItem.getContainedStack(this.parent).m_41720_())) {
                return;
            }
            if (entity.m_9236_().m_5776_()) {
                entity.m_6674_(InteractionHand.MAIN_HAND);
            }
            double eyeY = entity.m_20188_();
            ItemEntity itemEntity = new ItemEntity(entity.m_9236_(), entity.m_20185_(), eyeY, entity.m_20189_(), target);
            itemEntity.m_32010_(40);
            RandomSource random = entity.m_217043_();
            float g = Mth.m_14031_((float)(entity.m_146909_() * ((float)Math.PI / 180)));
            float h = Mth.m_14089_((float)(entity.m_146909_() * ((float)Math.PI / 180)));
            float i = Mth.m_14031_((float)(entity.m_146908_() * ((float)Math.PI / 180)));
            float j = Mth.m_14089_((float)(entity.m_146908_() * ((float)Math.PI / 180)));
            float k = random.m_188501_() * ((float)Math.PI * 2);
            float l = 0.02f * random.m_188501_();
            float f = random.m_188501_();
            itemEntity.m_20334_((double)(-i * h * 0.3f) + Math.cos(k) * (double)l, (double)(-g * 0.3f + 0.1f + (random.m_188501_() - f) * 0.1f), (double)(j * h * 0.3f) + Math.sin(k) * (double)l);
            entity.m_9236_().m_7967_((Entity)itemEntity);
        }
    }

    void updateContainedNbt(CompoundTag compound) {
        this.current.m_41751_(compound);
    }

    @Override
    public ItemStack blahaj$getStack() {
        return this.current;
    }

    public boolean m_41619_() {
        if (this.current == null) {
            if (this.parent == null) {
                return true;
            }
            return this.parent.m_41619_();
        }
        return this.current.m_41619_();
    }

    public InteractionResult m_41661_(UseOnContext itemUsageContext) {
        InteractionResult result = this.current.m_41661_(itemUsageContext);
        this.dirty();
        return result;
    }

    public InteractionResultHolder<ItemStack> m_41682_(Level world, Player player, InteractionHand hand) {
        InteractionResultHolder result = this.current.m_41682_(world, player, hand);
        this.dirty();
        return new InteractionResultHolder(result.m_19089_(), (Object)this.parent);
    }

    public ItemStack m_41671_(Level world, LivingEntity livingEntity) {
        this.current.m_41671_(world, livingEntity);
        this.dirty();
        return this.parent;
    }

    public CompoundTag m_41739_(CompoundTag nbtCompound) {
        if (this.current == null) {
            return null;
        }
        CompoundTag result = this.current.m_41739_(nbtCompound);
        this.dirty();
        return result;
    }

    public boolean m_41753_() {
        return false;
    }

    public boolean m_41768_() {
        return this.current.m_41768_();
    }

    public int m_41773_() {
        if (this.current == null) {
            return 0;
        }
        return this.current.m_41773_();
    }

    public void m_41721_(int i) {
        if (this.current == null) {
            return;
        }
        this.current.m_41721_(i);
        this.dirty();
    }

    public boolean m_220157_(int i, RandomSource random, @Nullable ServerPlayer player) {
        if (this.current == null) {
            return false;
        }
        boolean result = this.current.m_220157_(i, random, player);
        this.dirty();
        return result;
    }

    public <T extends LivingEntity> void m_41622_(int i, T livingEntity, Consumer<T> consumer) {
        if (this.current == null) {
            return;
        }
        this.current.m_41622_(i, livingEntity, consumer);
        this.dirty();
    }

    public boolean m_150932_(ItemStack stack, Slot slot, ClickAction clickType, Player player, SlotAccess reference) {
        boolean result = this.current.m_150932_(stack, slot, clickType, player, reference);
        this.dirty();
        return result;
    }

    public InteractionResult m_41647_(Player player, LivingEntity livingEntity, InteractionHand hand) {
        InteractionResult result = this.current.m_41647_(player, livingEntity, hand);
        this.dirty();
        return result;
    }

    public ItemStack m_41777_() {
        if (this.current == null) {
            return null;
        }
        return this.current.m_41777_();
    }

    public ItemStack m_255036_(int i) {
        if (this.current == null) {
            return null;
        }
        return this.current.m_255036_(i);
    }

    public void m_41666_(Level world, Entity entity, int i, boolean bl) {
        this.current.m_41666_(world, entity, i, bl);
    }

    public void m_41674_(Level world, LivingEntity livingEntity, int i) {
        this.current.m_41674_(world, livingEntity, i);
        this.dirty();
    }

    public boolean m_41782_() {
        return this.current.m_41782_();
    }

    @Nullable
    public CompoundTag m_41783_() {
        if (this.nbt == null) {
            CompoundTag compound = this.current.m_41783_();
            if (compound == null) {
                return null;
            }
            this.nbt = new ContainedNbtCompound(compound, e -> this.updateContainedNbt(compound));
        }
        return this.nbt;
    }

    public void m_41700_(String string, Tag nbtElement) {
        this.current.m_41700_(string, nbtElement);
        this.dirty();
    }

    public CompoundTag m_41784_() {
        CompoundTag result = this.current.m_41784_();
        this.dirty();
        return result;
    }

    public CompoundTag m_41698_(String string) {
        CompoundTag result = this.current.m_41698_(string);
        this.dirty();
        return result;
    }

    @Nullable
    public CompoundTag m_41737_(String string) {
        return this.current.m_41737_(string);
    }

    public void m_41749_(String string) {
        this.current.m_41749_(string);
        this.dirty();
    }

    public ListTag m_41785_() {
        return this.current.m_41785_();
    }

    public void m_41751_(@Nullable CompoundTag nbtCompound) {
        this.current.m_41751_(nbtCompound);
        this.dirty();
    }

    public Component m_41786_() {
        return this.current.m_41786_();
    }

    public ItemStack m_41714_(@Nullable Component text) {
        this.current.m_41714_(text);
        this.dirty();
        return this.current;
    }

    public void m_41787_() {
        if (this.current.m_41788_()) {
            this.current.m_41787_();
            this.dirty();
        }
    }

    public boolean m_41788_() {
        return this.current.m_41788_();
    }

    public List<Component> m_41651_(@Nullable Player playerEntity, TooltipFlag context) {
        return this.current.m_41651_(playerEntity, context);
    }

    public void m_41654_(ItemStack.TooltipPart tooltipSection) {
        this.current.m_41654_(tooltipSection);
        this.dirty();
    }

    public void m_41663_(Enchantment enchantment, int i) {
        this.current.m_41663_(enchantment, i);
        this.dirty();
    }

    public boolean m_41793_() {
        return this.current.m_41793_();
    }

    public boolean m_41794_() {
        return this.parent.m_41794_();
    }

    public void m_41636_(@Nullable Entity entity) {
        this.parent.m_41636_(entity);
    }

    @Nullable
    public ItemFrame m_41795_() {
        return this.parent.m_41795_();
    }

    @Nullable
    public Entity m_41609_() {
        return this.parent.m_41609_();
    }

    public int m_41610_() {
        return this.current.m_41610_();
    }

    public void m_41742_(int i) {
        if (i != this.current.m_41610_()) {
            this.current.m_41742_(i);
            this.dirty();
        }
    }

    public Multimap<Attribute, AttributeModifier> m_41638_(EquipmentSlot equipmentSlot) {
        return this.current.m_41638_(equipmentSlot);
    }

    public void m_41643_(Attribute attribute, AttributeModifier modifier, @Nullable EquipmentSlot slot) {
        this.current.m_41643_(attribute, modifier, slot);
        this.dirty();
    }

    public boolean m_204121_(Registry<Block> registry, BlockInWorld position) {
        return this.current.m_204121_(registry, position);
    }

    public boolean m_204128_(Registry<Block> registry, BlockInWorld position) {
        return this.current.m_204128_(registry, position);
    }

    public int m_41612_() {
        return this.current.m_41612_();
    }

    public void m_41754_(int i) {
        this.current.m_41754_(i);
        this.dirty();
    }

    public int m_41613_() {
        return this.current.m_41613_();
    }

    public void m_41764_(int i) {
        this.current.m_41764_(i);
        this.dirty();
    }

    public void m_41731_(Level world, LivingEntity livingEntity, int i) {
        this.current.m_41731_(world, livingEntity, i);
    }
}

