/*
 * Decompiled with CFR 0.152.
 */
package mc.recraftors.blahaj.item;

import mc.recraftors.blahaj.item.CuddlyContainerTooltipData;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientBundleTooltip;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CuddlyContainerTooltipComponent
implements ClientTooltipComponent {
    private final ItemStack stack;

    public CuddlyContainerTooltipComponent(CuddlyContainerTooltipData data) {
        this.stack = data.getStoredStack();
    }

    public boolean isHolding() {
        return this.stack != null;
    }

    public int m_142103_() {
        if (!this.isHolding()) {
            return 0;
        }
        return 26;
    }

    public int m_142069_(Font textRenderer) {
        if (this.isHolding()) {
            return 20;
        }
        return 0;
    }

    public void m_183452_(Font textRenderer, int i, int j, GuiGraphics drawContext) {
        this.drawSlot(i + 1, j + 1, drawContext, textRenderer);
        this.drawOutline(i, j, drawContext);
    }

    protected void drawSlot(int i, int j, GuiGraphics drawContext, Font textRenderer) {
        if (!this.isHolding()) {
            return;
        }
        ItemStack itemStack = this.stack;
        this.draw(drawContext, i, j, Sprite.SLOT);
        drawContext.m_280256_(itemStack, i + 1, j + 1, 0);
        drawContext.m_280370_(textRenderer, itemStack, i + 1, j + 1);
        AbstractContainerScreen.m_280359_((GuiGraphics)drawContext, (int)(i + 1), (int)(j + 1), (int)0);
    }

    protected void drawOutline(int i, int j, GuiGraphics drawContext) {
        this.draw(drawContext, i, j, Sprite.BORDER_CORNER_TOP);
        this.draw(drawContext, i + 19, j, Sprite.BORDER_CORNER_TOP);
        this.draw(drawContext, i + 1, j, Sprite.BORDER_HORIZONTAL_TOP);
        this.draw(drawContext, i + 1, j + 20, Sprite.BORDER_HORIZONTAL_BOTTOM);
        this.draw(drawContext, i, j + 1, Sprite.BORDER_VERTICAL);
        this.draw(drawContext, i + 19, j + 1, Sprite.BORDER_VERTICAL);
        this.draw(drawContext, i, j + 20, Sprite.BORDER_CORNER_BOTTOM);
        this.draw(drawContext, i + 19, j + 20, Sprite.BORDER_CORNER_BOTTOM);
    }

    protected void draw(GuiGraphics drawContext, int i, int j, Sprite sprite) {
        drawContext.m_280398_(ClientBundleTooltip.f_169863_, i, j, 0, (float)sprite.u, (float)sprite.v, sprite.width, sprite.height, 128, 128);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum Sprite {
        SLOT(0, 0, 18, 20),
        BORDER_VERTICAL(0, 18, 1, 20),
        BORDER_HORIZONTAL_TOP(0, 20, 18, 1),
        BORDER_HORIZONTAL_BOTTOM(0, 60, 18, 1),
        BORDER_CORNER_TOP(0, 20, 1, 1),
        BORDER_CORNER_BOTTOM(0, 60, 1, 1);

        public final int u;
        public final int v;
        public final int width;
        public final int height;

        private Sprite(int j, int k, int l, int m) {
            this.u = j;
            this.v = k;
            this.width = l;
            this.height = m;
        }
    }
}

