/*
 * Decompiled with CFR 0.152.
 */
package mc.recraftors.blahaj.item.nbt;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import mc.recraftors.blahaj.item.nbt.ContainedNbtElement;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagVisitor;
import org.jetbrains.annotations.NotNull;

public class ContainedNbtIntArray
extends IntArrayTag
implements ContainedNbtElement<IntArrayTag> {
    @NotNull
    private final IntArrayTag containedArray;
    @NotNull
    private final Set<Consumer<ContainedNbtElement<?>>> dirtyListeners;
    private boolean modified;
    private boolean busy;

    public ContainedNbtIntArray(IntArrayTag nbtIntArray, Consumer<ContainedNbtElement<?>> ... listeners) {
        super(new int[0]);
        this.containedArray = nbtIntArray;
        this.dirtyListeners = new HashSet();
        this.modified = false;
        this.busy = false;
        Arrays.stream(listeners).forEach(this.dirtyListeners::add);
    }

    @Override
    public void dirty() {
        this.modified = true;
        if (this.busy) {
            return;
        }
        this.busy = true;
        this.dirtyListeners.forEach(listener -> listener.accept(this));
        this.busy = false;
    }

    @Override
    public void clean() {
        this.modified = false;
    }

    @Override
    public IntArrayTag getContained() {
        return this.containedArray;
    }

    @Override
    public boolean isDirty() {
        return this.modified;
    }

    @Override
    public Consumer<ContainedNbtElement<?>>[] getListeners() {
        return (Consumer[])this.dirtyListeners.toArray(Consumer[]::new);
    }

    public String toString() {
        return this.containedArray.toString();
    }

    public IntArrayTag m_6426_() {
        return this.containedArray.m_6426_();
    }

    public boolean equals(Object object) {
        return this.containedArray.equals(object);
    }

    public int hashCode() {
        return this.containedArray.hashCode();
    }

    public void m_142327_(TagVisitor nbtElementVisitor) {
        this.containedArray.m_142327_(nbtElementVisitor);
    }

    public int[] m_128648_() {
        return this.containedArray.m_128648_();
    }

    public int size() {
        return this.containedArray.size();
    }

    public IntTag get(int i) {
        return this.containedArray.get(i);
    }

    public IntTag set(int i, IntTag nbtInt) {
        IntTag result = this.containedArray.set(i, nbtInt);
        this.dirty();
        return result;
    }

    public void add(int i, IntTag nbtInt) {
        this.containedArray.add(i, nbtInt);
        this.dirty();
    }

    public boolean m_7615_(int i, Tag nbtElement) {
        boolean result = this.containedArray.m_7615_(i, nbtElement);
        if (result) {
            this.dirty();
        }
        return result;
    }

    public boolean m_7614_(int i, Tag nbtElement) {
        boolean result = this.containedArray.m_7614_(i, nbtElement);
        if (result) {
            this.dirty();
        }
        return result;
    }

    public void clear() {
        this.containedArray.clear();
        this.dirty();
    }
}

