/*
 * Decompiled with CFR 0.152.
 */
package mc.recraftors.blahaj.item.nbt;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import mc.recraftors.blahaj.item.nbt.ContainedNbtCompound;
import mc.recraftors.blahaj.item.nbt.ContainedNbtElement;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.NotNull;

public class ContainedNbtList
extends ListTag
implements ContainedNbtElement<ListTag> {
    @NotNull
    private final ListTag containedList;
    @NotNull
    private final Set<Consumer<ContainedNbtElement<?>>> dirtyListeners;
    private boolean modified;
    private boolean busy;

    public ContainedNbtList(ListTag containedNbtList, Consumer<ContainedNbtElement<?>> ... listeners) {
        this.containedList = containedNbtList;
        this.dirtyListeners = new HashSet();
        this.modified = false;
        this.busy = false;
        Arrays.stream(listeners).forEach(this.dirtyListeners::add);
    }

    @Override
    public final void dirty() {
        this.modified = true;
        if (this.busy) {
            return;
        }
        this.busy = true;
        this.dirtyListeners.forEach(listener -> listener.accept(this));
        this.busy = false;
    }

    @Override
    public void clean() {
        this.modified = false;
    }

    @Override
    public ListTag getContained() {
        return this.containedList;
    }

    @Override
    public boolean isDirty() {
        return this.modified;
    }

    @Override
    public Consumer<ContainedNbtElement<?>>[] getListeners() {
        return (Consumer[])this.dirtyListeners.toArray(Consumer[]::new);
    }

    public String toString() {
        return this.containedList.toString();
    }

    public Tag remove(int i) {
        Tag result = this.containedList.remove(i);
        this.dirty();
        return result;
    }

    public boolean isEmpty() {
        return this.containedList.isEmpty();
    }

    public CompoundTag m_128728_(int i) {
        return new ContainedNbtCompound(this.containedList.m_128728_(i), this.getListeners());
    }

    public ListTag m_128744_(int i) {
        return new ContainedNbtList(this.containedList.m_128744_(i), this.getListeners());
    }

    public short m_128757_(int i) {
        return this.containedList.m_128757_(i);
    }

    public int m_128763_(int i) {
        return this.containedList.m_128763_(i);
    }

    public int[] m_128767_(int i) {
        return this.containedList.m_128767_(i);
    }

    public long[] m_177991_(int i) {
        return this.containedList.m_177991_(i);
    }

    public double m_128772_(int i) {
        return this.containedList.m_128772_(i);
    }

    public float m_128775_(int i) {
        return this.containedList.m_128775_(i);
    }

    public String m_128778_(int i) {
        return this.containedList.m_128778_(i);
    }

    public int size() {
        return this.containedList.size();
    }

    public Tag get(int i) {
        return ContainedNbtElement.getContained(this.containedList.get(i), this.getListeners());
    }

    public Tag set(int i, Tag nbtElement) {
        Tag result = this.containedList.set(i, nbtElement);
        this.dirty();
        return result;
    }

    public void add(int i, Tag nbtElement) {
        this.containedList.add(i, nbtElement);
        this.dirty();
    }

    public boolean m_7615_(int i, Tag nbtElement) {
        boolean result = this.containedList.m_7615_(i, nbtElement);
        if (result) {
            this.dirty();
        }
        return result;
    }

    public boolean m_7614_(int i, Tag nbtElement) {
        boolean result = this.containedList.m_7614_(i, nbtElement);
        if (result) {
            this.dirty();
        }
        return result;
    }

    public ListTag m_6426_() {
        return this.containedList.m_6426_();
    }

    public boolean equals(Object object) {
        return this.containedList.equals(object);
    }

    public int hashCode() {
        return this.containedList.hashCode();
    }

    public void m_197573_(StreamTagVisitor nbtScanner) {
        this.containedList.m_197573_(nbtScanner);
        this.dirty();
    }

    public void clear() {
        this.containedList.clear();
        this.dirty();
    }

    public StreamTagVisitor.ValueResult m_196533_(StreamTagVisitor nbtScanner) {
        StreamTagVisitor.ValueResult result = this.containedList.m_196533_(nbtScanner);
        this.dirty();
        return result;
    }
}

