/*
 * Decompiled with CFR 0.152.
 */
package mc.recraftors.blahaj.mixin.compat;

import java.util.List;
import java.util.Set;
import mc.recraftors.blahaj.PreLaunchUtils;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public final class Plugin
implements IMixinConfigPlugin {
    private static final String COMPAT_PACKAGE_ROOT = Plugin.class.getPackageName();
    private static final int COMPAT_PACKAGE_LENGTH;
    private static final String COMPAT_PRESENT_KEY = "present";
    private static final String COMPAT_ABSENT_KEY = "absent";
    private static final String COMPAT_ANY_KEY = "any";
    private static final String COMPAT_AND_KEY = "and";
    private static final String COMPAT_BUT_KEY = "and_not";
    private static final String COMPAT_NOR_KEY = "nor";
    private static final String COMPAT_OR_KEY = "or";
    private static final String COMPAT_XOR_KEY = "xor";
    private static final String AUTHOR_KEY = "author";

    public void onLoad(String mixinPackage) {
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        String s;
        if (!mixinClassName.startsWith(COMPAT_PACKAGE_ROOT)) {
            return true;
        }
        String[] mixinPath = mixinClassName.split("\\.");
        int i = COMPAT_PACKAGE_LENGTH;
        String compatModId = mixinPath[i++];
        if (mixinPath[i].equals(AUTHOR_KEY) && !PreLaunchUtils.modHasAuthor(compatModId, mixinPath[++i])) {
            return false;
        }
        int n = ++i;
        ++i;
        return switch (s = mixinPath[n]) {
            case COMPAT_PRESENT_KEY -> PreLaunchUtils.isModLoaded(compatModId);
            case COMPAT_ABSENT_KEY -> {
                if (!PreLaunchUtils.isModLoaded(compatModId)) {
                    yield true;
                }
                yield false;
            }
            case COMPAT_AND_KEY -> {
                if (PreLaunchUtils.isModLoaded(compatModId) && PreLaunchUtils.isModLoaded(mixinPath[i])) {
                    yield true;
                }
                yield false;
            }
            case COMPAT_BUT_KEY -> {
                if (PreLaunchUtils.isModLoaded(compatModId) && !PreLaunchUtils.isModLoaded(mixinPath[i])) {
                    yield true;
                }
                yield false;
            }
            case COMPAT_NOR_KEY -> {
                if (!PreLaunchUtils.isModLoaded(compatModId) && !PreLaunchUtils.isModLoaded(mixinPath[i])) {
                    yield true;
                }
                yield false;
            }
            case COMPAT_OR_KEY -> {
                if (PreLaunchUtils.isModLoaded(compatModId) || PreLaunchUtils.isModLoaded(mixinPath[i])) {
                    yield true;
                }
                yield false;
            }
            case COMPAT_XOR_KEY -> PreLaunchUtils.isModLoaded(compatModId) ^ PreLaunchUtils.isModLoaded(mixinPath[i]);
            default -> s.equals(COMPAT_ANY_KEY);
        };
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    static {
        String[] compatRoot = COMPAT_PACKAGE_ROOT.split("\\.");
        COMPAT_PACKAGE_LENGTH = compatRoot.length;
    }
}

