/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.simpleradio.core.registry.blocks;

import com.codinglitch.simpleradio.api.central.Receiving;
import com.codinglitch.simpleradio.api.central.Speaking;
import com.codinglitch.simpleradio.api.central.WorldlyPosition;
import com.codinglitch.simpleradio.client.ClientRadioManager;
import com.codinglitch.simpleradio.client.core.central.AnimationInstance;
import com.codinglitch.simpleradio.core.central.Animatable;
import com.codinglitch.simpleradio.core.registry.SimpleRadioBlockEntities;
import com.codinglitch.simpleradio.core.registry.SimpleRadioBlocks;
import com.codinglitch.simpleradio.core.registry.SimpleRadioSounds;
import com.codinglitch.simpleradio.core.registry.blocks.AuditoryBlockEntity;
import com.codinglitch.simpleradio.platform.Services;
import com.codinglitch.simpleradio.radio.RadioManager;
import com.codinglitch.simpleradio.radio.RadioReceiver;
import com.codinglitch.simpleradio.radio.RadioSpeaker;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class RadioBlockEntity
extends AuditoryBlockEntity
implements Receiving,
Speaking,
Animatable {
    public boolean isActive = false;
    public int antennaPower = 0;
    private final Map<Integer, AnimationInstance> animations = new HashMap<Integer, AnimationInstance>();
    public float time = 0.0f;
    public static final int PLAYING = 0;

    public RadioBlockEntity(BlockPos pos, BlockState state) {
        super(SimpleRadioBlockEntities.RADIO, pos, state);
        this.allocate(0);
    }

    @Override
    public Map<Integer, AnimationInstance> getStates() {
        return this.animations;
    }

    @Override
    public float getTime() {
        return this.time;
    }

    @Override
    public void setTime(float time) {
        this.time = time;
    }

    public void m_7651_() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_ && this.speaker != null) {
            this.f_58857_.m_6263_(null, (double)this.speaker.location.x, (double)this.speaker.location.y, (double)this.speaker.location.z, SimpleRadioSounds.RADIO_CLOSE, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        this.inactivate();
        super.m_7651_();
    }

    @Override
    public void loadTag(CompoundTag tag) {
        super.loadTag(tag);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.loadTag(tag);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        this.saveTag(tag);
        super.m_183515_(tag);
    }

    public void m_187476_(ItemStack stack) {
        this.saveTag(stack.m_41784_());
        super.m_187476_(stack);
    }

    public static void tick(Level level, BlockPos pos, BlockState blockState, RadioBlockEntity blockEntity) {
        if (blockEntity.frequency != null && blockEntity.id != null && !blockEntity.isActive) {
            blockEntity.activate();
        }
        if (level.f_46443_) {
            blockEntity.time += 0.05f;
        }
    }

    public void inactivate() {
        if (this.frequency != null) {
            RadioManager.removeRouterSided(this.id, this.f_58857_.f_46443_);
            if (!this.f_58857_.f_46443_) {
                this.stopReceiving(this.frequency.frequency, this.frequency.modulation, this.id);
            }
            if (!this.f_58857_.f_46443_) {
                this.stopSpeaking();
            }
        }
        this.isActive = false;
    }

    public void activate() {
        WorldlyPosition location = Services.COMPAT.modifyPosition(WorldlyPosition.of(this.f_58858_, this.f_58857_, this.f_58858_));
        if (!this.f_58857_.f_46443_) {
            this.speaker = SimpleRadioBlocks.RADIO.getOrCreateSpeaker(location, this.id, this.m_58900_());
            this.receiver = SimpleRadioBlocks.RADIO.getOrCreateReceiver(location, this.frequency, this.id, this.m_58900_());
            this.f_58857_.m_6263_(null, (double)location.x, (double)location.y, (double)location.z, SimpleRadioSounds.RADIO_OPEN, SoundSource.PLAYERS, 1.0f, 1.0f);
        } else {
            this.receiver = new RadioReceiver(this.frequency, location, this.id);
            this.speaker = new RadioSpeaker(location, this.id);
            ClientRadioManager.registerRouter(this.receiver);
            ClientRadioManager.registerRouter(this.speaker);
        }
        this.receiver.routers.add(this.speaker);
        this.isActive = true;
    }

    @Override
    public int getAntennaPower() {
        return this.antennaPower;
    }
}

