/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.simpleradio.core.registry.blocks;

import com.codinglitch.simpleradio.api.central.Receiving;
import com.codinglitch.simpleradio.api.central.WorldlyPosition;
import com.codinglitch.simpleradio.client.ClientRadioManager;
import com.codinglitch.simpleradio.core.registry.SimpleRadioBlockEntities;
import com.codinglitch.simpleradio.core.registry.SimpleRadioBlocks;
import com.codinglitch.simpleradio.core.registry.SimpleRadioSounds;
import com.codinglitch.simpleradio.core.registry.blocks.CatalyzingBlockEntity;
import com.codinglitch.simpleradio.core.registry.blocks.ReceiverBlock;
import com.codinglitch.simpleradio.platform.Services;
import com.codinglitch.simpleradio.radio.RadioManager;
import com.codinglitch.simpleradio.radio.RadioReceiver;
import com.codinglitch.simpleradio.radio.RadioRouter;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ReceiverBlockEntity
extends CatalyzingBlockEntity
implements Receiving {
    public boolean isActive = false;
    public boolean isDirty = true;
    public int antennaPower = 0;

    public ReceiverBlockEntity(BlockPos pos, BlockState state) {
        super(SimpleRadioBlockEntities.RECEIVER, pos, state);
    }

    @Override
    public BlockPos getAdaptorLocation() {
        return this.m_58899_().m_121945_(((Direction)this.m_58900_().m_61143_((Property)ReceiverBlock.FACING)).m_122424_());
    }

    public void m_7651_() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_ && this.receiver != null) {
            this.f_58857_.m_6263_(null, (double)this.receiver.location.x, (double)this.receiver.location.y, (double)this.receiver.location.z, SimpleRadioSounds.RADIO_CLOSE, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        this.inactivate();
        super.m_7651_();
    }

    @Override
    public void loadTag(CompoundTag tag) {
        super.loadTag(tag);
    }

    @Override
    public void saveTag(CompoundTag tag) {
        super.saveTag(tag);
        tag.m_128405_("antennaPower", this.antennaPower);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.loadTag(tag);
        if (tag.m_128441_("antennaPower")) {
            this.antennaPower = tag.m_128451_("antennaPower");
        }
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        this.saveTag(tag);
        super.m_183515_(tag);
    }

    public void m_187476_(ItemStack stack) {
        this.saveTag(stack.m_41784_());
        super.m_187476_(stack);
    }

    @Override
    public void markDirty() {
        this.isDirty = true;
    }

    public static void tick(Level level, BlockPos pos, BlockState blockState, ReceiverBlockEntity blockEntity) {
        if (blockEntity.frequency != null && blockEntity.id != null && !blockEntity.isActive) {
            blockEntity.activate();
        }
        CatalyzingBlockEntity.tick(level, pos, blockState, blockEntity);
        if (blockEntity.receiver != null) {
            boolean bl = blockEntity.receiver.active = blockEntity.catalyst != null;
        }
        if (!blockEntity.catalyzed) {
            return;
        }
        if (blockEntity.isDirty && level.m_46467_() % 200L == 0L && !level.f_46443_) {
            blockEntity.antennaPower = blockEntity.calculateAntennaPower(blockEntity.getAdaptorLocation(), level);
            RadioRouter router = blockEntity.getRouter();
            if (router instanceof RadioReceiver) {
                RadioReceiver receiver = (RadioReceiver)router;
                receiver.antennaPower = blockEntity.antennaPower;
            }
            level.m_7260_(pos, blockState, blockState, 2);
            blockEntity.m_6596_();
            blockEntity.isDirty = false;
        }
    }

    public void inactivate() {
        if (this.frequency != null) {
            RadioManager.removeRouterSided(this.id, this.m_58904_().f_46443_);
            if (!this.f_58857_.f_46443_) {
                this.stopReceiving(this.frequency.frequency, this.frequency.modulation, this.id);
            }
        }
        this.isActive = false;
    }

    public void activate() {
        WorldlyPosition location = Services.COMPAT.modifyPosition(WorldlyPosition.of(this.f_58858_, this.f_58857_, this.f_58858_));
        if (!this.f_58857_.f_46443_) {
            this.receiver = SimpleRadioBlocks.RECEIVER.getOrCreateReceiver(location, this.frequency, this.id, this.m_58900_());
            this.f_58857_.m_6263_(null, (double)location.x, (double)location.y, (double)location.z, SimpleRadioSounds.RADIO_OPEN, SoundSource.PLAYERS, 1.0f, 1.0f);
        } else {
            this.receiver = new RadioReceiver(this.frequency, location, this.id);
            ClientRadioManager.registerRouter(this.receiver);
        }
        this.isActive = true;
        this.markDirty();
    }

    @Override
    public int getAntennaPower() {
        return this.antennaPower;
    }
}

