/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.resources.pack;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.gson.JsonElement;
import dev.architectury.injectables.annotations.PlatformOnly;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.integration.ModernFixCompat;
import net.mehvahdjukaar.moonlight.api.misc.PathTrie;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.SimpleTagBuilder;
import net.mehvahdjukaar.moonlight.api.resources.StaticResource;
import net.mehvahdjukaar.moonlight.api.resources.assets.LangBuilder;
import net.mehvahdjukaar.moonlight.core.CommonConfigs;
import net.mehvahdjukaar.moonlight.core.CompatHandler;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.SharedConstants;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.metadata.pack.PackMetadataSectionSerializer;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.world.flag.FeatureFlagSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public abstract class DynamicResourcePack
implements PackResources {
    protected static final Logger LOGGER = LogManager.getLogger();
    protected final boolean hidden;
    protected final boolean fixed;
    protected final Pack.Position position;
    protected final PackType packType;
    protected final Supplier<PackMetadataSection> metadata;
    protected final Component title;
    protected final ResourceLocation resourcePackName;
    protected final Set<String> namespaces = new HashSet<String>();
    protected final Map<ResourceLocation, byte[]> resources = new ConcurrentHashMap<ResourceLocation, byte[]>();
    protected final ResourceLocPathTrie searchTrie = new ResourceLocPathTrie();
    protected final Map<String, byte[]> rootResources = new ConcurrentHashMap<String, byte[]>();
    protected final String mainNamespace;
    protected Set<ResourceLocation> staticResources = new HashSet<ResourceLocation>();
    protected boolean generateDebugResources;
    private boolean needsClearingNonStatic = false;
    boolean addToStatic = false;
    private boolean wasRegistered = false;
    private static final boolean MODERN_FIX = CompatHandler.MODERNFIX && ModernFixCompat.areLazyResourcesOn();

    protected DynamicResourcePack(ResourceLocation name, PackType type) {
        this(name, type, Pack.Position.TOP, false, false);
    }

    protected DynamicResourcePack(ResourceLocation name, PackType type, Pack.Position position, boolean fixed, boolean hidden) {
        this.packType = type;
        this.resourcePackName = name;
        this.mainNamespace = name.m_135827_();
        this.namespaces.add(this.mainNamespace);
        this.title = Component.m_237115_((String)LangBuilder.getReadableName(name.toString()));
        this.position = position;
        this.fixed = fixed;
        this.hidden = hidden;
        this.metadata = Suppliers.memoize(() -> new PackMetadataSection(this.makeDescription(), SharedConstants.m_183709_().m_264084_(type)));
        this.generateDebugResources = PlatHelper.isDev();
    }

    public Component makeDescription() {
        return Component.m_237115_((String)LangBuilder.getReadableName(this.mainNamespace + "_dynamic_resources"));
    }

    @Deprecated(forRemoval=true)
    public void setClearOnReload(boolean canBeCleared) {
    }

    @Deprecated(forRemoval=true)
    public void clearOnReload(boolean canBeCleared) {
    }

    public void markNotClearable(ResourceLocation staticResources) {
        this.staticResources.add(staticResources);
    }

    public void unMarkNotClearable(ResourceLocation staticResources) {
        this.staticResources.remove(staticResources);
    }

    public void setGenerateDebugResources(boolean generateDebugResources) {
        this.generateDebugResources = generateDebugResources;
    }

    public void addNamespaces(String ... namespaces) {
        this.namespaces.addAll(Arrays.asList(namespaces));
    }

    public Component getTitle() {
        return this.title;
    }

    public String m_5542_() {
        return this.title.getString();
    }

    public ResourceLocation id() {
        return this.resourcePackName;
    }

    public String toString() {
        return this.m_5542_();
    }

    protected void registerPack() {
        if (this.wasRegistered) {
            return;
        }
        this.wasRegistered = true;
        RegHelper.registerResourcePack(this.packType, () -> Pack.m_245512_((String)this.m_5542_(), (Component)this.getTitle(), (boolean)true, s -> this, (Pack.Info)new Pack.Info(this.metadata.get().m_10373_(), this.metadata.get().m_10374_(), FeatureFlagSet.m_246902_()), (PackType)this.packType, (Pack.Position)Pack.Position.TOP, (boolean)this.fixed, (PackSource)PackSource.f_10528_));
    }

    @PlatformOnly(value={"forge"})
    public boolean isHidden() {
        return this.hidden;
    }

    public Set<String> m_5698_(PackType packType) {
        return this.namespaces;
    }

    public <T> T m_5550_(MetadataSectionSerializer<T> serializer) {
        return (T)(serializer instanceof PackMetadataSectionSerializer ? this.metadata : null);
    }

    public void addRootResource(String name, byte[] resource) {
        this.rootResources.put(name, resource);
    }

    @Nullable
    public IoSupplier<InputStream> m_8017_(String ... strings) {
        String fileName = String.join((CharSequence)"/", strings);
        byte[] resource = this.rootResources.get(fileName);
        return resource == null ? null : () -> new ByteArrayInputStream(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void m_8031_(PackType packType, String namespace, String id, PackResources.ResourceOutput output) {
        if (PlatHelper.isDev()) {
            for (ResourceLocation r2 : this.searchTrie.search("")) {
                if (this.resources.containsKey(r2)) continue;
                Moonlight.LOGGER.error("Resource {} not ", (Object)r2);
                throw new IllegalStateException("Resource " + String.valueOf(r2) + " not found in resources");
            }
        }
        DynamicResourcePack dynamicResourcePack = this;
        synchronized (dynamicResourcePack) {
            if (packType == this.packType) {
                this.searchTrie.search(namespace + "/" + id).forEach(r -> {
                    byte[] buf = this.resources.get(r);
                    if (buf == null) {
                        throw new IllegalStateException("Somehow search trie returned a resource not in resources " + String.valueOf(r));
                    }
                    output.accept(r, () -> new ByteArrayInputStream(buf));
                });
            }
        }
    }

    public IoSupplier<InputStream> m_214146_(PackType type, ResourceLocation id) {
        byte[] res = this.resources.get(id);
        if (res != null) {
            return () -> {
                if (type != this.packType) {
                    throw new IOException(String.format("Tried to access wrong type of resource on %s.", this.resourcePackName));
                }
                return new ByteArrayInputStream(res);
            };
        }
        return null;
    }

    public void close() {
    }

    public FileNotFoundException makeFileNotFoundException(String path) {
        return new FileNotFoundException(String.format("'%s' in ResourcePack '%s'", path, this.resourcePackName));
    }

    protected void addBytes(ResourceLocation id, byte[] bytes) {
        this.namespaces.add(id.m_135827_());
        this.resources.put(id, (byte[])Preconditions.checkNotNull((Object)bytes));
        this.searchTrie.insert(id);
        if (this.addToStatic) {
            this.markNotClearable(id);
        }
        if (this.generateDebugResources) {
            DynamicResourcePack.saveBytes(id, bytes);
        }
    }

    public static void saveJson(ResourceLocation id, JsonElement json) {
        try {
            DynamicResourcePack.saveBytes(id, RPUtils.serializeJson(json).getBytes());
        }
        catch (IOException e) {
            LOGGER.error("Failed to deserialize JSON {}", (Object)json, (Object)e);
        }
    }

    public static void saveBytes(ResourceLocation id, byte[] bytes) {
        try {
            Path p = Paths.get("debug", "generated_resource_pack").resolve(id.m_135827_() + "/" + id.m_135815_());
            Files.createDirectories(p.getParent(), new FileAttribute[0]);
            Files.write(p, bytes, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated(forRemoval=true)
    public void removeResource(ResourceLocation res) {
        DynamicResourcePack dynamicResourcePack = this;
        synchronized (dynamicResourcePack) {
            this.searchTrie.remove(res);
            this.resources.remove(res);
            this.staticResources.remove(res);
        }
    }

    @Deprecated(forRemoval=true)
    public void addResource(StaticResource resource) {
        this.addBytes(resource.location, resource.data);
    }

    @Deprecated(forRemoval=true)
    private void addJson(ResourceLocation path, JsonElement json) {
        try {
            this.addBytes(path, RPUtils.serializeJson(json).getBytes());
        }
        catch (IOException e) {
            LOGGER.error("Failed to write JSON {} to resource pack {}.", (Object)path, (Object)this.resourcePackName, (Object)e);
        }
    }

    @Deprecated(forRemoval=true)
    public void addJson(ResourceLocation location, JsonElement json, ResType resType) {
        this.addJson(resType.getPath(location), json);
    }

    @Deprecated(forRemoval=true)
    public void addBytes(ResourceLocation location, byte[] bytes, ResType resType) {
        this.addBytes(resType.getPath(location), bytes);
    }

    public PackType getPackType() {
        return this.packType;
    }

    @ApiStatus.Internal
    protected void clearNonStatic() {
        if (!CommonConfigs.CLEAR_RESOURCES.get().booleanValue()) {
            return;
        }
        if (this.needsClearingNonStatic) {
            boolean mf;
            this.needsClearingNonStatic = false;
            boolean bl = mf = MODERN_FIX && this.getPackType() == PackType.CLIENT_RESOURCES;
            if (!mf) {
                this.searchTrie.clear();
            }
            for (ResourceLocation resourceLocation : this.resources.keySet()) {
                if (mf && this.modernFixHack(resourceLocation.m_135815_()) || this.staticResources.contains(resourceLocation)) continue;
                this.resources.remove(resourceLocation);
            }
            if (mf) {
                ArrayList<CallSite> toRemove = new ArrayList<CallSite>();
                for (String namespace : this.searchTrie.listFolders("")) {
                    for (String f : this.searchTrie.listFolders(namespace)) {
                        if (this.modernFixHack(f)) continue;
                        toRemove.add((CallSite)((Object)(namespace + "/" + f)));
                    }
                }
                toRemove.forEach(this.searchTrie::remove);
            }
            for (ResourceLocation resourceLocation : this.staticResources) {
                this.searchTrie.insert(resourceLocation);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    protected void clearAllContent() {
        DynamicResourcePack dynamicResourcePack = this;
        synchronized (dynamicResourcePack) {
            this.searchTrie.clear();
            this.resources.clear();
            this.needsClearingNonStatic = true;
        }
    }

    private boolean modernFixHack(String s) {
        return s.startsWith("model") || s.startsWith("blockstate");
    }

    public void addTag(SimpleTagBuilder tag, ResourceKey<?> key) {
    }

    protected static class ResourceLocPathTrie
    extends PathTrie<ResourceLocation> {
        protected ResourceLocPathTrie() {
        }

        public boolean remove(ResourceLocation object) {
            String path = object.m_135827_() + "/" + object.m_135815_().substring(0, object.m_135815_().lastIndexOf(47));
            return super.remove(path);
        }

        public void insert(ResourceLocation object) {
            String path = object.m_135827_() + "/" + object.m_135815_().substring(0, object.m_135815_().lastIndexOf(47));
            super.insert(path, object);
        }
    }
}

