/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.caverns_and_chasms.client.model;

import com.google.common.collect.ImmutableList;
import com.teamabnormals.caverns_and_chasms.common.entity.monster.Mime;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import org.joml.Vector3f;

public class MimeModel
extends PlayerModel<Mime> {
    private final ModelPart rightHorn;
    private final ModelPart leftHorn;
    private final ModelPart bipedCape;

    public MimeModel(ModelPart root) {
        super(root, false);
        this.rightHorn = this.f_102808_.m_171324_("right_horn");
        this.leftHorn = this.f_102808_.m_171324_("left_horn");
        this.bipedCape = root.m_171324_("biped_cape");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = PlayerModel.m_170825_((CubeDeformation)CubeDeformation.f_171458_, (boolean)false);
        PartDefinition root = meshdefinition.m_171576_();
        PartDefinition head = root.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171506_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, false), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)0.0f));
        head.m_171599_("right_horn", CubeListBuilder.m_171558_().m_171514_(8, 60).m_171506_(-2.0f, -14.0f, 0.0f, 1.0f, 4.0f, 0.0f, false).m_171514_(0, 59).m_171506_(-4.0f, -11.0f, -1.0f, 2.0f, 3.0f, 2.0f, false), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        head.m_171599_("left_horn", CubeListBuilder.m_171558_().m_171514_(18, 60).m_171506_(1.0f, -14.0f, 0.0f, 1.0f, 4.0f, 0.0f, false).m_171514_(10, 59).m_171506_(2.0f, -11.0f, -1.0f, 2.0f, 3.0f, 2.0f, false), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        root.m_171599_("hat", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171506_(-4.0f, -10.0f, -4.0f, 8.0f, 8.0f, 8.0f, false), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(16, 16).m_171506_(-4.0f, 0.0f, -2.0f, 8.0f, 13.0f, 4.0f, false), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)0.0f));
        root.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(40, 33).m_171506_(-3.0f, -2.0f, -2.0f, 4.0f, 13.0f, 4.0f, false), PartPose.m_171419_((float)-5.0f, (float)0.0f, (float)0.0f));
        root.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(40, 16).m_171506_(-1.0f, -2.0f, -2.0f, 4.0f, 13.0f, 4.0f, true), PartPose.m_171419_((float)5.0f, (float)0.0f, (float)0.0f));
        root.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171506_(-2.0f, 0.0f, -2.0f, 4.0f, 13.0f, 4.0f, false), PartPose.m_171419_((float)-1.9f, (float)12.0f, (float)0.0f));
        root.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 33).m_171506_(-2.0f, 0.0f, -2.0f, 4.0f, 13.0f, 4.0f, true), PartPose.m_171419_((float)1.9f, (float)12.0f, (float)0.0f));
        root.m_171599_("biped_cape", CubeListBuilder.m_171558_().m_171514_(16, 33).m_171506_(-4.0f, 0.0f, 0.0f, 8.0f, 21.0f, 1.0f, false), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.f_102810_, (Object)this.f_102811_, (Object)this.f_102812_, (Object)this.f_102813_, (Object)this.f_102814_, (Object)this.bipedCape, (Object)this.f_102809_);
    }

    public void prepareMobModel(Mime mime, float limbSwing, float limbSwingAmount, float partialTicks) {
        boolean showhorns;
        super.m_6839_((LivingEntity)mime, limbSwing, limbSwingAmount, partialTicks);
        double d0 = mime.prevChasingPosX + (mime.chasingPosX - mime.prevChasingPosX) * (double)partialTicks - (mime.f_19854_ + (mime.m_20185_() - mime.f_19854_) * (double)partialTicks);
        double d1 = mime.prevChasingPosY + (mime.chasingPosY - mime.prevChasingPosY) * (double)partialTicks - (mime.f_19855_ + (mime.m_20186_() - mime.f_19855_) * (double)partialTicks);
        double d2 = mime.prevChasingPosZ + (mime.chasingPosZ - mime.prevChasingPosZ) * (double)partialTicks - (mime.f_19856_ + (mime.m_20189_() - mime.f_19856_) * (double)partialTicks);
        float f = mime.f_20884_ + (mime.f_20883_ - mime.f_20884_) * partialTicks;
        double d3 = Mth.m_14031_((float)(f * ((float)Math.PI / 180)));
        double d4 = -Mth.m_14089_((float)(f * ((float)Math.PI / 180)));
        float f1 = (float)d1 * 10.0f;
        f1 = Mth.m_14036_((float)f1, (float)-6.0f, (float)32.0f);
        float f2 = (float)(d0 * d3 + d2 * d4) * 100.0f;
        f2 = Mth.m_14036_((float)f2, (float)0.0f, (float)150.0f);
        float f3 = (float)(d0 * d4 - d2 * d3) * 100.0f;
        f3 = Mth.m_14036_((float)f3, (float)-20.0f, (float)20.0f);
        float f4 = mime.prevCameraYaw + (mime.cameraYaw - mime.prevCameraYaw) * partialTicks;
        f1 += Mth.m_14031_((float)((mime.f_19867_ + (mime.f_19787_ - mime.f_19867_) * partialTicks) * 6.0f)) * 32.0f * f4;
        if (mime.m_6144_()) {
            f1 += 25.0f;
        }
        this.rightHorn.f_104207_ = showhorns = mime.m_6844_(EquipmentSlot.HEAD).m_41619_();
        this.leftHorn.f_104207_ = showhorns;
        this.bipedCape.f_104203_ = (float)Math.toRadians(6.0f + f2 / 2.0f + f1);
        this.bipedCape.f_104204_ = (float)Math.toRadians(f3 / 2.0f);
        this.bipedCape.f_104205_ = (float)Math.toRadians(f3 / 2.0f);
    }

    public void setupAnim(Mime mime, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.f_102817_ = mime.m_6047_();
        float f = limbSwing * 0.75f;
        super.m_6973_((LivingEntity)mime, f, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        if (mime.m_6844_(EquipmentSlot.CHEST).m_41619_()) {
            if (mime.m_6047_()) {
                this.bipedCape.f_104202_ = -1.4f;
                this.bipedCape.f_104201_ = 1.85f;
            } else {
                this.bipedCape.f_104202_ = 0.0f;
                this.bipedCape.f_104201_ = 0.0f;
            }
        } else if (mime.m_6047_()) {
            this.bipedCape.f_104202_ = -0.3f;
            this.bipedCape.f_104201_ = 1.85f;
        } else {
            this.bipedCape.f_104202_ = 1.1f;
            this.bipedCape.f_104201_ = 0.0f;
        }
        if (!this.f_102609_ && this.f_102818_ <= 0.0f) {
            float f1;
            this.f_102810_.f_104205_ = f1 = Mth.m_14089_((float)(f * 0.6662f)) * limbSwingAmount * 0.2f;
            this.f_102808_.f_104205_ = Mth.m_14089_((float)(f * 0.6662f - 1.5707964f)) * limbSwingAmount * 0.2f;
            this.f_102808_.f_104200_ = Mth.m_14031_((float)f1) * 11.0f;
            this.f_102808_.f_104201_ += 11.0f - Mth.m_14089_((float)f1) * 11.0f;
            this.f_102810_.f_104200_ = Mth.m_14031_((float)f1) * 11.0f;
            this.f_102810_.f_104201_ += 11.0f - Mth.m_14089_((float)f1) * 11.0f;
            this.f_102811_.f_104200_ += Mth.m_14031_((float)f1) * 11.0f;
            this.f_102811_.f_104201_ += 11.0f - Mth.m_14089_((float)f1) * 11.0f;
            this.f_102812_.f_104200_ += Mth.m_14031_((float)f1) * 11.0f;
            this.f_102812_.f_104201_ += 11.0f - Mth.m_14089_((float)f1) * 11.0f;
            this.bipedCape.f_104200_ = Mth.m_14031_((float)f1) * 11.0f;
            this.bipedCape.f_104201_ += 11.0f - Mth.m_14089_((float)f1) * 11.0f;
            if (this.f_102813_.f_104203_ < 0.0f) {
                this.f_102813_.f_104204_ += (1.0f + Mth.m_14089_((float)(f * 0.6662f * 2.0f))) * limbSwingAmount * 0.4f;
                this.f_102813_.f_104205_ += this.f_102813_.f_104204_ * 0.25f;
            }
            if (this.f_102814_.f_104203_ < 0.0f) {
                this.f_102814_.f_104204_ += (-1.0f - Mth.m_14089_((float)(f * 0.6662f * 2.0f))) * limbSwingAmount * 0.4f;
                this.f_102814_.f_104205_ += this.f_102813_.f_104204_ * 0.25f;
            }
        } else {
            this.f_102808_.f_104205_ = 0.0f;
            this.f_102810_.f_104205_ = 0.0f;
            this.f_102808_.f_104200_ = 0.0f;
            this.f_102810_.f_104200_ = 0.0f;
            this.bipedCape.f_104200_ = 0.0f;
        }
        this.f_102808_.f_104201_ -= 2.0f;
        this.f_102810_.f_104201_ -= 2.0f;
        this.f_102811_.f_104201_ -= 2.0f;
        this.f_102812_.f_104201_ -= 2.0f;
        this.f_102813_.f_104201_ -= 1.0f;
        this.f_102814_.f_104201_ -= 1.0f;
        this.bipedCape.f_104201_ -= 2.0f;
        this.bipedCape.f_104202_ += 2.0f;
        this.saveAnimationValues(mime);
    }

    private void saveAnimationValues(Mime mime) {
        mime.armPositions[0] = this.getPositionVector(this.f_102811_);
        mime.armPositions[1] = this.getPositionVector(this.f_102812_);
        mime.armRotations[0] = this.getRotationVector(this.f_102811_);
        mime.armRotations[1] = this.getRotationVector(this.f_102812_);
    }

    private Vector3f getRotationVector(ModelPart modelPart) {
        return new Vector3f(modelPart.f_104203_, modelPart.f_104204_, modelPart.f_104205_);
    }

    private Vector3f getPositionVector(ModelPart modelPart) {
        return new Vector3f(modelPart.f_104200_, modelPart.f_104201_, modelPart.f_104202_);
    }

    public void m_8009_(boolean visible) {
        super.m_8009_(visible);
        this.bipedCape.f_104207_ = visible;
    }
}

