/*
 * Decompiled with CFR 0.152.
 */
package com.soytutta.mynethersdelight.common.loot;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;

public class RemplaceLootModifier
extends LootModifier {
    private final Item replacedItem;
    private final Item newItem;
    private final EntityType<?> entity;
    public static final Supplier<Codec<RemplaceLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> RemplaceLootModifier.codecStart((RecordCodecBuilder.Instance)inst).and(inst.group((App)ForgeRegistries.ITEMS.getCodec().fieldOf("replaces").forGetter(m -> m.replacedItem), (App)ForgeRegistries.ITEMS.getCodec().fieldOf("item").forGetter(m -> m.newItem), (App)ForgeRegistries.ENTITY_TYPES.getCodec().fieldOf("entity").forGetter(m -> m.entity))).apply((Applicative)inst, RemplaceLootModifier::new)));

    protected RemplaceLootModifier(LootItemCondition[] conditionsIn, Item replacedItem, Item newItem, EntityType<?> entity) {
        super(conditionsIn);
        this.replacedItem = replacedItem;
        this.newItem = newItem;
        this.entity = entity;
    }

    @Nonnull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        Entity t = (Entity)context.m_78953_(LootContextParams.f_81455_);
        if (t == null || t.m_6095_() != this.entity) {
            return generatedLoot;
        }
        int amountOfItems = 0;
        for (ItemStack i2 : generatedLoot) {
            if (i2.m_41720_() != this.replacedItem) continue;
            amountOfItems += i2.m_41613_();
        }
        generatedLoot.removeIf(i -> i.m_41720_() == this.replacedItem);
        generatedLoot.add((Object)new ItemStack((ItemLike)this.newItem, amountOfItems));
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

