/*
 * Decompiled with CFR 0.152.
 */
package com.soytutta.mynethersdelight.core.data;

import com.soytutta.mynethersdelight.common.registry.MNDBlocks;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import vectorwing.farmersdelight.common.block.CabinetBlock;
import vectorwing.farmersdelight.common.block.FeastBlock;
import vectorwing.farmersdelight.common.block.MushroomColonyBlock;

public class MNDBlockStates
extends BlockStateProvider {
    public MNDBlockStates(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "mynethersdelight", exFileHelper);
    }

    private String blockName(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_();
    }

    public ResourceLocation resourceBlock(String path) {
        return new ResourceLocation("mynethersdelight", "block/" + path);
    }

    protected void registerStatesAndModels() {
        this.simpleBlock(MNDBlocks.RESURGENT_SOIL.get(), this.cubeRandomRotation(MNDBlocks.RESURGENT_SOIL.get(), ""));
        this.stageBlock(MNDBlocks.CRIMSON_FUNGUS_COLONY.get(), MushroomColonyBlock.COLONY_AGE, new Property[0]);
        this.stageBlock(MNDBlocks.WARPED_FUNGUS_COLONY.get(), MushroomColonyBlock.COLONY_AGE, new Property[0]);
        this.cabinetBlock(MNDBlocks.NETHER_BRICKS_CABINET.get(), "nether_bricks");
        this.cabinetBlock(MNDBlocks.RED_NETHER_BRICKS_CABINET.get(), "red_nether_bricks");
        this.crateBlock(MNDBlocks.BULLET_PEPPER_CRATE.get(), "bullet_pepper");
        this.cabinetBlock(MNDBlocks.POWDERY_CABINET.get(), "powdery");
        this.simpleBlock(MNDBlocks.POWDERY_PLANKS.get());
        this.logBlock((RotatedPillarBlock)MNDBlocks.BLOCK_OF_POWDERY_CANNON.get());
        this.logBlock((RotatedPillarBlock)MNDBlocks.BLOCK_OF_STRIPPED_POWDERY_CANNON.get());
        this.stairsBlock((StairBlock)MNDBlocks.POWDERY_PLANKS_STAIRS.get(), this.blockTexture(MNDBlocks.POWDERY_PLANKS.get()));
        this.slabBlock((SlabBlock)MNDBlocks.POWDERY_PLANKS_SLAB.get(), this.blockTexture(MNDBlocks.POWDERY_PLANKS.get()), this.blockTexture(MNDBlocks.POWDERY_PLANKS.get()));
        this.doorBlockWithRenderType((DoorBlock)MNDBlocks.POWDERY_DOOR.get(), this.modLoc("block/powdery_door_bottom"), this.modLoc("block/powdery_door_top"), "cutout");
        this.trapdoorBlockWithRenderType((TrapDoorBlock)MNDBlocks.POWDERY_TRAPDOOR.get(), this.modLoc("block/powdery_trapdoor"), true, "cutout");
        this.buttonBlock((ButtonBlock)MNDBlocks.POWDERY_BUTTON.get(), this.blockTexture(MNDBlocks.POWDERY_PLANKS.get()));
        this.pressurePlateBlock((PressurePlateBlock)MNDBlocks.POWDERY_PRESSURE_PLATE.get(), this.blockTexture(MNDBlocks.POWDERY_PLANKS.get()));
        this.simpleBlock(MNDBlocks.POWDERY_MOSAIC.get());
        this.stairsBlock((StairBlock)MNDBlocks.POWDERY_MOSAIC_STAIRS.get(), this.blockTexture(MNDBlocks.POWDERY_MOSAIC.get()));
        this.slabBlock((SlabBlock)MNDBlocks.POWDERY_MOSAIC_SLAB.get(), this.blockTexture(MNDBlocks.POWDERY_MOSAIC.get()), this.blockTexture(MNDBlocks.POWDERY_MOSAIC.get()));
        this.signBlock((StandingSignBlock)MNDBlocks.POWDERY_SIGN.get(), (WallSignBlock)MNDBlocks.POWDERY_WALL_SIGN.get(), this.blockTexture(MNDBlocks.POWDERY_PLANKS.get()));
        this.hangingSignBlock(MNDBlocks.POWDERY_HANGING_SIGN.get(), MNDBlocks.POWDERY_WALL_HANGING_SIGN.get(), this.blockTexture(MNDBlocks.POWDERY_PLANKS.get()));
        this.feastBlock((FeastBlock)MNDBlocks.GHASTA_WITH_CREAM_BLOCK.get());
        this.feastBlock((FeastBlock)MNDBlocks.STRIDERLOAF_BLOCK.get());
        this.feastBlock((FeastBlock)MNDBlocks.COLD_STRIDERLOAF_BLOCK.get());
    }

    public void feastBlock(FeastBlock block) {
        this.getVariantBuilder((Block)block).forAllStates(state -> {
            IntegerProperty servingsProperty = block.getServingsProperty();
            int servings = (Integer)state.m_61143_((Property)servingsProperty);
            Object suffix = "_stage" + (block.getMaxServings() - servings);
            if (servings == 0) {
                suffix = block.hasLeftovers ? "_leftover" : "_stage" + (servingsProperty.m_6908_().toArray().length - 2);
            }
            ConfiguredModel.Builder var10000 = ConfiguredModel.builder();
            String var10002 = this.blockName((Block)block);
            return var10000.modelFile(this.existingModel(var10002 + (String)suffix)).rotationY(((int)((Direction)state.m_61143_((Property)FeastBlock.FACING)).m_122435_() + 180) % 360).build();
        });
    }

    public ModelFile existingModel(String path) {
        return new ModelFile.ExistingModelFile(this.resourceBlock(path), this.models().existingFileHelper);
    }

    public void hangingSignBlock(Block signBlock, Block wallSignBlock, ResourceLocation texture) {
        ModelBuilder sign = this.models().sign(this.name(signBlock), texture);
        this.hangingSignBlock(signBlock, wallSignBlock, (ModelFile)sign);
    }

    public void hangingSignBlock(Block signBlock, Block wallSignBlock, ModelFile sign) {
        this.simpleBlock(signBlock, sign);
        this.simpleBlock(wallSignBlock, sign);
    }

    public void crateBlock(Block block, String cropName) {
        this.simpleBlock(block, (ModelFile)this.models().cubeBottomTop(this.blockName(block), this.resourceBlock(cropName + "_crate_side"), this.resourceBlock(cropName + "_crate_bottom"), this.resourceBlock(cropName + "_crate_top")));
    }

    private String name(Block block) {
        return this.key(block).m_135815_();
    }

    private ResourceLocation key(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block);
    }

    private void blockItem(RegistryObject<Block> blockRegistryObject) {
        this.simpleBlockItem((Block)blockRegistryObject.get(), (ModelFile)new ModelFile.UncheckedModelFile("mynethersdelight:block/" + ForgeRegistries.BLOCKS.getKey((Object)((Block)blockRegistryObject.get())).m_135815_()));
    }

    public ConfiguredModel[] cubeRandomRotation(Block block, String suffix) {
        String var10000 = this.blockName(block);
        String formattedName = var10000 + (String)(suffix.isEmpty() ? "" : "_" + suffix);
        return ConfiguredModel.allYRotations((ModelFile)this.models().cubeAll(formattedName, this.resourceBlock(formattedName)), (int)0, (boolean)false);
    }

    public void stageBlock(Block block, IntegerProperty ageProperty, Property<?> ... ignored) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            int ageSuffix = (Integer)state.m_61143_((Property)ageProperty);
            String blockName = this.blockName(block);
            String stageName = blockName + "_stage" + ageSuffix;
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().cross(stageName, this.resourceBlock(stageName))).renderType("cutout")).build();
        }, ignored);
    }

    public void cabinetBlock(Block block, String woodType) {
        this.horizontalBlock(block, state -> {
            String suffix = (Boolean)state.m_61143_((Property)CabinetBlock.OPEN) != false ? "_open" : "";
            return this.models().orientable(this.blockName(block) + suffix, this.resourceBlock(woodType + "_cabinet_side"), this.resourceBlock(woodType + "_cabinet_front" + suffix), this.resourceBlock(woodType + "_cabinet_top"));
        });
    }
}

