/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting.builders;

import blusunrize.immersiveengineering.api.crafting.ArcFurnaceRecipe;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.builders.IEFinishedRecipe;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.conditions.ICondition;

public class ArcFurnaceRecipeBuilder
extends IEFinishedRecipe<ArcFurnaceRecipeBuilder> {
    private final JsonArray secondaryArray = new JsonArray();

    private ArcFurnaceRecipeBuilder() {
        super((IERecipeSerializer)ArcFurnaceRecipe.SERIALIZER.get());
        this.setMultipleResults(6);
        this.setUseInputArray(4, "additives");
        this.addWriter(jsonObject -> {
            if (!this.secondaryArray.isEmpty()) {
                jsonObject.add("secondaries", (JsonElement)this.secondaryArray);
            }
        });
    }

    public static ArcFurnaceRecipeBuilder builder(Item result) {
        return (ArcFurnaceRecipeBuilder)new ArcFurnaceRecipeBuilder().addResult((ItemLike)result);
    }

    public static ArcFurnaceRecipeBuilder builder(ItemStack result) {
        return (ArcFurnaceRecipeBuilder)new ArcFurnaceRecipeBuilder().addResult(result);
    }

    public static ArcFurnaceRecipeBuilder builder(TagKey<Item> result, int count) {
        return (ArcFurnaceRecipeBuilder)new ArcFurnaceRecipeBuilder().addResult(new IngredientWithSize(result, count));
    }

    public ArcFurnaceRecipeBuilder addSlag(ItemLike itemProvider) {
        return (ArcFurnaceRecipeBuilder)this.addItem("slag", new ItemStack(itemProvider));
    }

    public ArcFurnaceRecipeBuilder addSlag(ItemStack itemStack) {
        return (ArcFurnaceRecipeBuilder)this.addItem("slag", itemStack);
    }

    public ArcFurnaceRecipeBuilder addSlag(TagKey<Item> tag, int count) {
        return (ArcFurnaceRecipeBuilder)this.addIngredient("slag", new IngredientWithSize(tag, count));
    }

    public ArcFurnaceRecipeBuilder addSecondary(TagKey<Item> tag, float chance) {
        this.secondaryArray.add((JsonElement)ArcFurnaceRecipeBuilder.serializeStackWithChance(new IngredientWithSize(tag), chance, new ICondition[0]));
        return this;
    }
}

