/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.tile;

import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockBEHelper;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import blusunrize.immersiveengineering.api.multiblocks.blocks.registry.MultiblockBlockEntityMaster;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.render.tile.BERenderUtils;
import blusunrize.immersiveengineering.client.render.tile.DynamicModel;
import blusunrize.immersiveengineering.client.render.tile.IEBlockEntityRenderer;
import blusunrize.immersiveengineering.client.utils.RenderUtils;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.sawmill.SawmillLogic;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.sawmill.SawmillProcess;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.joml.Quaternionf;

public class SawmillRenderer
extends IEBlockEntityRenderer<MultiblockBlockEntityMaster<SawmillLogic.State>> {
    public static final String NAME = "sawmill_blade";
    public static DynamicModel BLADE;

    public void render(MultiblockBlockEntityMaster<SawmillLogic.State> te, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        boolean sawblade;
        IMultiblockBEHelper helper = te.getHelper();
        IMultiblockLevel level = helper.getContext().getLevel();
        SawmillLogic.State state = (SawmillLogic.State)helper.getState();
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, 0.0, 0.5);
        bufferIn = BERenderUtils.mirror(level.getOrientation(), matrixStack, bufferIn);
        VertexConsumer solidBuilder = bufferIn.m_6299_(RenderType.m_110451_());
        Direction facing = level.getOrientation().front();
        float dir = facing == Direction.SOUTH ? (float)Math.PI : (facing == Direction.NORTH ? 0.0f : (facing == Direction.EAST ? -1.5707964f : 1.5707964f));
        matrixStack.m_252781_(new Quaternionf().rotateY(dir));
        boolean bl = sawblade = !state.sawblade.m_41619_();
        if (sawblade) {
            matrixStack.m_85836_();
            matrixStack.m_85837_(1.0, 0.125, -0.5);
            float spin = state.animation_bladeRotation;
            if (state.active != SawmillLogic.ActiveState.DISABLED) {
                spin += 36.0f * partialTicks;
            }
            matrixStack.m_252781_(new Quaternionf().rotateZ(spin * ((float)Math.PI / 180)));
            RenderUtils.renderModelTESRFast(BLADE.getNullQuads(), solidBuilder, matrixStack, combinedLightIn, combinedOverlayIn);
            matrixStack.m_85849_();
        }
        for (SawmillProcess process : state.sawmillProcessQueue) {
            float relative = process.getRelativeProcessStep(te.m_58904_());
            ItemStack rendered = process.getCurrentStack(te.m_58904_(), sawblade);
            this.renderItem(rendered, relative, matrixStack, bufferIn, combinedLightIn, combinedOverlayIn, te.m_58904_());
        }
        matrixStack.m_85849_();
    }

    private void renderItem(ItemStack stack, float progress, PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, Level level) {
        float xOffset = -2.5f + progress * 5.0f;
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)xOffset, 0.375, 0.0);
        matrixStack.m_252781_(new Quaternionf().rotateZ(1.5707964f));
        ClientUtils.mc().m_91291_().m_269128_(stack, ItemDisplayContext.FIXED, combinedLightIn, combinedOverlayIn, matrixStack, bufferIn, level, 0);
        matrixStack.m_85849_();
    }
}

