/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks.logic;

import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IClientTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.common.blocks.multiblocks.shapes.BucketWheelShapes;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BucketWheelLogic
implements IMultiblockLogic<State>,
IClientTickableComponent<State>,
IServerTickableComponent<State> {
    @Override
    public void tickServer(IMultiblockContext<State> context) {
        this.tickClient(context);
        if (context.getState().active && context.getLevel().shouldTickModulo(20)) {
            context.requestMasterBESync();
        }
    }

    @Override
    public void tickClient(IMultiblockContext<State> context) {
        State state = context.getState();
        if (state.active) {
            state.rotation = (float)((double)state.rotation + (Double)IEServerConfig.MACHINES.excavator_speed.get());
            state.rotation %= 360.0f;
        }
    }

    @Override
    public State createInitialState(IInitialMultiblockContext<State> ctx) {
        return new State();
    }

    @Override
    public Function<BlockPos, VoxelShape> shapeGetter(ShapeType forType) {
        return BucketWheelShapes.SHAPE_GETTER;
    }

    public static class State
    implements IMultiblockState {
        public float rotation = 0.0f;
        public final NonNullList<ItemStack> digStacks = NonNullList.m_122780_((int)8, (Object)ItemStack.f_41583_);
        public boolean active = false;
        public boolean reverseRotation = false;
        public boolean outputLeft = false;

        @Override
        public void writeSaveNBT(CompoundTag nbt) {
            nbt.m_128350_("rotation", this.rotation);
            ListTag stacksNBT = new ListTag();
            for (ItemStack stack : this.digStacks) {
                stacksNBT.add((Object)stack.m_41739_(new CompoundTag()));
            }
            nbt.m_128365_("stacks", (Tag)stacksNBT);
            nbt.m_128379_("active", this.active);
            nbt.m_128379_("renderReverse", this.reverseRotation);
            nbt.m_128379_("outputLeft", this.outputLeft);
        }

        @Override
        public void readSaveNBT(CompoundTag nbt) {
            this.rotation = nbt.m_128457_("rotation");
            ListTag stacksNBT = nbt.m_128437_("stacks", 10);
            for (int i = 0; i < stacksNBT.size(); ++i) {
                this.digStacks.set(i, (Object)ItemStack.m_41712_((CompoundTag)stacksNBT.m_128728_(i)));
            }
            this.active = nbt.m_128471_("active");
            this.reverseRotation = nbt.m_128471_("renderReverse");
            this.outputLeft = nbt.m_128471_("outputLeft");
        }

        @Override
        public void writeSyncNBT(CompoundTag nbt) {
            this.writeSaveNBT(nbt);
        }

        @Override
        public void readSyncNBT(CompoundTag nbt) {
            this.readSaveNBT(nbt);
        }
    }
}

