/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.RecipeSerializers;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.ItemHandlerHelper;

public class JerrycanRefillRecipe
extends CustomRecipe {
    private final int jerrycanIndex = 0;
    private final int containerIndex = 1;

    public JerrycanRefillRecipe(ResourceLocation resourceLocation) {
        super(resourceLocation, CraftingBookCategory.MISC);
    }

    public boolean matches(@Nonnull CraftingContainer inv, Level world) {
        ItemStack[] components = this.getComponents((Container)inv);
        if (!components[0].m_41619_() && !components[1].m_41619_() && this.countOccupiedSlots((Container)inv) == 2) {
            return FluidUtil.getFluidContained((ItemStack)components[0]).map(fs -> {
                IFluidHandler handler = (IFluidHandler)FluidUtil.getFluidHandler((ItemStack)components[1]).orElseThrow(RuntimeException::new);
                FluidStack containerFluid = handler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
                return containerFluid.getAmount() < handler.getTankCapacity(0) && handler.isFluidValid(0, fs);
            }).orElse(false);
        }
        return false;
    }

    @Nonnull
    public ItemStack assemble(@Nonnull CraftingContainer inv, RegistryAccess access) {
        ItemStack[] components = this.getComponents((Container)inv);
        ItemStack newContainer = ItemHandlerHelper.copyStackWithSize((ItemStack)components[1], (int)1);
        IFluidHandlerItem handler = (IFluidHandlerItem)FluidUtil.getFluidHandler((ItemStack)newContainer).orElseThrow(RuntimeException::new);
        FluidUtil.getFluidContained((ItemStack)components[0]).ifPresent(fs -> ItemNBTHelper.putInt(components[0], "jerrycanDrain", handler.fill(fs, IFluidHandler.FluidAction.EXECUTE)));
        newContainer = handler.getContainer();
        return newContainer;
    }

    private ItemStack[] getComponents(Container inv) {
        ItemStack[] ret = new ItemStack[]{ItemStack.f_41583_, ItemStack.f_41583_};
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stackInSlot = inv.m_8020_(i);
            if (stackInSlot.m_41619_()) continue;
            if (ret[0].m_41619_() && stackInSlot.m_150930_(IEItems.Misc.JERRYCAN.m_5456_()) && FluidUtil.getFluidContained((ItemStack)stackInSlot).map(fs -> !fs.isEmpty()).orElse(false).booleanValue()) {
                ret[0] = stackInSlot;
                continue;
            }
            if (ret[1].m_41619_() && FluidUtil.getFluidHandler((ItemStack)stackInSlot).isPresent()) {
                ret[1] = stackInSlot;
                continue;
            }
            return ret;
        }
        return ret;
    }

    private int countOccupiedSlots(Container inv) {
        int c = 0;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            if (inv.m_8020_(i).m_41619_()) continue;
            ++c;
        }
        return c;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    @Nonnull
    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        NonNullList remaining = super.m_7457_((Container)inv);
        boolean foundJerrycan = false;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stackInSlot = inv.m_8020_(i);
            if (stackInSlot.m_41619_()) continue;
            if (stackInSlot.m_150930_(IEItems.Misc.JERRYCAN.m_5456_()) && !foundJerrycan) {
                foundJerrycan = true;
                continue;
            }
            remaining.set(i, (Object)ItemStack.f_41583_);
        }
        return remaining;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeSerializers.JERRYCAN_REFILL.get();
    }
}

