/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.entities.ai;

import blusunrize.immersiveengineering.common.entities.illager.Fusilier;
import blusunrize.immersiveengineering.common.items.RailgunItem;
import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import java.util.EnumSet;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class RailgunAttackGoal<T extends Fusilier>
extends Goal {
    public static final UniformInt PATHFINDING_DELAY_RANGE = TimeUtil.m_145020_((int)1, (int)2);
    private final T mob;
    private RailgunState railgunState = RailgunState.COOLDOWN;
    private final double speedModifier;
    private final float attackRadiusSqr;
    private int seeTime;
    private int attackDelay;
    private int cooldownDelay;
    private int updatePathDelay;

    public RailgunAttackGoal(T mob, double speedModifier, float attackRadius) {
        this.mob = mob;
        this.speedModifier = speedModifier;
        this.attackRadiusSqr = attackRadius * attackRadius;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return this.isValidTarget() && this.isHoldingRailgun();
    }

    private boolean isHoldingRailgun() {
        return this.mob.m_21093_(is -> is.m_41720_() instanceof RailgunItem);
    }

    public boolean m_8045_() {
        return this.isValidTarget() && (this.m_8036_() || !this.mob.m_21573_().m_26571_()) && this.isHoldingRailgun();
    }

    private boolean isValidTarget() {
        return this.mob.m_5448_() != null && this.mob.m_5448_().m_6084_();
    }

    public void m_8041_() {
        super.m_8041_();
        this.mob.m_21561_(false);
        this.mob.m_6710_(null);
        this.seeTime = 0;
        if (this.mob.m_6117_()) {
            this.mob.m_5810_();
            ((Fusilier)((Object)this.mob)).setAimingRailgun(false);
        }
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        LivingEntity livingentity = this.mob.m_5448_();
        if (livingentity != null) {
            boolean shouldAttack;
            boolean hasBeenSeeing;
            boolean hasLineOfSight = this.mob.m_21574_().m_148306_((Entity)livingentity);
            boolean bl = hasBeenSeeing = this.seeTime > 0;
            if (hasLineOfSight != hasBeenSeeing) {
                this.seeTime = 0;
            }
            this.seeTime = hasLineOfSight ? ++this.seeTime : --this.seeTime;
            double d0 = this.mob.m_20280_((Entity)livingentity);
            boolean bl2 = shouldAttack = (d0 > (double)this.attackRadiusSqr || this.seeTime < 5) && this.attackDelay == 0;
            if (shouldAttack) {
                --this.updatePathDelay;
                if (this.updatePathDelay <= 0) {
                    this.mob.m_21573_().m_5624_((Entity)livingentity, this.canRun() ? this.speedModifier : this.speedModifier * 0.5);
                    this.updatePathDelay = PATHFINDING_DELAY_RANGE.m_214085_(this.mob.m_217043_());
                }
            } else {
                this.updatePathDelay = 0;
                this.mob.m_21573_().m_26573_();
            }
            this.mob.m_21563_().m_24960_((Entity)livingentity, 30.0f, 30.0f);
            if (this.railgunState == RailgunState.COOLDOWN) {
                if (!shouldAttack && --this.cooldownDelay <= 0) {
                    this.mob.m_6672_(ProjectileUtil.getWeaponHoldingHand(this.mob, item -> item instanceof RailgunItem));
                    RailgunItem.playChargeSound(this.mob, this.mob.m_21211_());
                    this.railgunState = RailgunState.CHARGING;
                    ((Fusilier)((Object)this.mob)).setAimingRailgun(true);
                }
            } else if (this.railgunState == RailgunState.CHARGING) {
                ItemStack itemstack;
                int i;
                if (!this.mob.m_6117_()) {
                    this.railgunState = RailgunState.COOLDOWN;
                }
                if ((i = this.mob.m_21252_()) >= RailgunItem.getChargeTime(itemstack = this.mob.m_21211_())) {
                    this.railgunState = RailgunState.CHARGED;
                    this.attackDelay = 20 + this.mob.m_217043_().m_188503_(20);
                }
            } else if (this.railgunState == RailgunState.CHARGED) {
                --this.attackDelay;
                if (this.attackDelay == 0) {
                    this.railgunState = RailgunState.READY_TO_ATTACK;
                }
            } else if (this.railgunState == RailgunState.READY_TO_ATTACK && hasLineOfSight) {
                ItemStack itemstack = this.mob.m_21211_();
                Entity shot = RailgunItem.fireProjectile(itemstack, this.mob.m_9236_(), this.mob, new ItemStack(IEItems.Ingredients.STICK_STEEL));
                if (shot instanceof Projectile) {
                    Projectile projectile = (Projectile)shot;
                    this.shootProjectile((LivingEntity)this.mob, livingentity, projectile, 3.0f);
                }
                this.mob.m_21253_();
                ItemNBTHelper.remove(itemstack, "inUse");
                ((Fusilier)((Object)this.mob)).setAimingRailgun(false);
                this.railgunState = RailgunState.COOLDOWN;
                this.cooldownDelay = 40;
            }
        }
    }

    private void shootProjectile(LivingEntity user, LivingEntity target, Projectile projectile, float velocity) {
        double dx = target.m_20185_() - user.m_20185_();
        double dz = target.m_20189_() - user.m_20189_();
        double distSqrt = Math.sqrt(dx * dx + dz * dz);
        double dy = target.m_20227_(0.3333333333333333) - projectile.m_20186_() + distSqrt * (double)0.2f;
        Vec3 vec3 = new Vec3(dx, dy, dz).m_82541_();
        projectile.m_6686_(vec3.m_7096_(), vec3.m_7098_(), vec3.m_7094_(), velocity, (float)(14 - user.m_9236_().m_46791_().m_19028_() * 4));
    }

    private boolean canRun() {
        return this.railgunState == RailgunState.COOLDOWN;
    }

    static enum RailgunState {
        COOLDOWN,
        CHARGING,
        CHARGED,
        READY_TO_ATTACK;

    }
}

