/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.network;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.common.entities.SkylineHookEntity;
import blusunrize.immersiveengineering.common.network.IMessage;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class MessageSkyhookSync
implements IMessage {
    private int entityID;
    private Connection connection;
    private ConnectionPoint start;
    private double linePos;
    private double speed;

    public MessageSkyhookSync(SkylineHookEntity entity) {
        this.entityID = entity.m_19879_();
        this.connection = entity.getConnection();
        this.linePos = entity.linePos;
        this.start = entity.start;
        this.speed = entity.horizontalSpeed;
    }

    public MessageSkyhookSync(FriendlyByteBuf buf) {
        this.entityID = buf.readInt();
        CompoundTag tag = buf.m_130260_();
        this.connection = new Connection(tag);
        this.linePos = buf.readDouble();
        this.speed = buf.readDouble();
        this.start = new ConnectionPoint(buf.m_130260_());
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.entityID);
        buf.m_130079_(this.connection.toNBT());
        buf.writeDouble(this.linePos);
        buf.writeDouble(this.speed);
        buf.m_130079_(this.start.createTag());
    }

    @Override
    public void process(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            Entity ent;
            Level world = ImmersiveEngineering.proxy.getClientWorld();
            if (world != null && (ent = world.m_6815_(this.entityID)) instanceof SkylineHookEntity) {
                SkylineHookEntity hook = (SkylineHookEntity)ent;
                hook.setConnectionAndPos(this.connection, this.start, this.linePos, this.speed);
            }
        });
    }
}

