/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.crafter;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.content.kinetics.crafter.CrafterHelper;
import com.simibubi.create.content.kinetics.crafter.MechanicalCrafterBlock;
import com.simibubi.create.content.kinetics.crafter.MechanicalCrafterBlockEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class ConnectedInputHandler {
    public static boolean shouldConnect(Level world, BlockPos pos, Direction face, Direction direction) {
        BlockState refState = world.m_8055_(pos);
        if (!refState.m_61138_(HorizontalKineticBlock.HORIZONTAL_FACING)) {
            return false;
        }
        Direction refDirection = (Direction)refState.m_61143_(HorizontalKineticBlock.HORIZONTAL_FACING);
        if (direction.m_122434_() == refDirection.m_122434_()) {
            return false;
        }
        if (face == refDirection) {
            return false;
        }
        BlockState neighbour = world.m_8055_(pos.m_121945_(direction));
        if (!AllBlocks.MECHANICAL_CRAFTER.has(neighbour)) {
            return false;
        }
        return refDirection == neighbour.m_61143_(HorizontalKineticBlock.HORIZONTAL_FACING);
    }

    public static void toggleConnection(Level world, BlockPos pos, BlockPos pos2) {
        BlockPos controllerPos2;
        MechanicalCrafterBlockEntity crafter1 = CrafterHelper.getCrafter((BlockAndTintGetter)world, pos);
        MechanicalCrafterBlockEntity crafter2 = CrafterHelper.getCrafter((BlockAndTintGetter)world, pos2);
        if (crafter1 == null || crafter2 == null) {
            return;
        }
        BlockPos controllerPos1 = crafter1.m_58899_().m_121955_((Vec3i)crafter1.input.data.get(0));
        if (controllerPos1.equals((Object)(controllerPos2 = crafter2.m_58899_().m_121955_((Vec3i)crafter2.input.data.get(0))))) {
            MechanicalCrafterBlockEntity controller = CrafterHelper.getCrafter((BlockAndTintGetter)world, controllerPos1);
            Set<BlockPos> positions = controller.input.data.stream().map(arg_0 -> ((BlockPos)controllerPos1).m_121955_(arg_0)).collect(Collectors.toSet());
            LinkedList<BlockPos> frontier = new LinkedList<BlockPos>();
            ArrayList<BlockPos> splitGroup = new ArrayList<BlockPos>();
            frontier.add(pos2);
            positions.remove(pos2);
            positions.remove(pos);
            while (!frontier.isEmpty()) {
                BlockPos current = (BlockPos)frontier.remove(0);
                for (Direction direction : Iterate.directions) {
                    BlockPos next = current.m_121945_(direction);
                    if (!positions.remove(next)) continue;
                    splitGroup.add(next);
                    frontier.add(next);
                }
            }
            ConnectedInputHandler.initAndAddAll(world, crafter1, positions);
            ConnectedInputHandler.initAndAddAll(world, crafter2, splitGroup);
            crafter1.m_6596_();
            crafter1.connectivityChanged();
            crafter2.m_6596_();
            crafter2.connectivityChanged();
            return;
        }
        if (!crafter1.input.isController) {
            crafter1 = CrafterHelper.getCrafter((BlockAndTintGetter)world, controllerPos1);
        }
        if (!crafter2.input.isController) {
            crafter2 = CrafterHelper.getCrafter((BlockAndTintGetter)world, controllerPos2);
        }
        if (crafter1 == null || crafter2 == null) {
            return;
        }
        ConnectedInputHandler.connectControllers(world, crafter1, crafter2);
        world.m_7731_(crafter1.m_58899_(), crafter1.m_58900_(), 3);
        crafter1.m_6596_();
        crafter1.connectivityChanged();
        crafter2.m_6596_();
        crafter2.connectivityChanged();
    }

    public static void initAndAddAll(Level world, MechanicalCrafterBlockEntity crafter, Collection<BlockPos> positions) {
        crafter.input = new ConnectedInput();
        positions.forEach(splitPos -> ConnectedInputHandler.modifyAndUpdate(world, splitPos, input -> {
            input.attachTo(crafter.m_58899_(), (BlockPos)splitPos);
            crafter.input.data.add(splitPos.m_121996_((Vec3i)crafter.m_58899_()));
        }));
    }

    public static void connectControllers(Level world, MechanicalCrafterBlockEntity crafter1, MechanicalCrafterBlockEntity crafter2) {
        crafter1.input.data.forEach(offset -> {
            BlockPos connectedPos = crafter1.m_58899_().m_121955_((Vec3i)offset);
            ConnectedInputHandler.modifyAndUpdate(world, connectedPos, input -> {});
        });
        crafter2.input.data.forEach(offset -> {
            if (offset.equals((Object)BlockPos.f_121853_)) {
                return;
            }
            BlockPos connectedPos = crafter2.m_58899_().m_121955_((Vec3i)offset);
            ConnectedInputHandler.modifyAndUpdate(world, connectedPos, input -> {
                input.attachTo(crafter1.m_58899_(), connectedPos);
                crafter1.input.data.add(BlockPos.f_121853_.m_121996_((Vec3i)input.data.get(0)));
            });
        });
        crafter2.input.attachTo(crafter1.m_58899_(), crafter2.m_58899_());
        crafter1.input.data.add(BlockPos.f_121853_.m_121996_((Vec3i)crafter2.input.data.get(0)));
    }

    private static void modifyAndUpdate(Level world, BlockPos pos, Consumer<ConnectedInput> callback) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (!(blockEntity instanceof MechanicalCrafterBlockEntity)) {
            return;
        }
        MechanicalCrafterBlockEntity crafter = (MechanicalCrafterBlockEntity)blockEntity;
        callback.accept(crafter.input);
        crafter.m_6596_();
        crafter.connectivityChanged();
    }

    public static class ConnectedInput {
        boolean isController = true;
        List<BlockPos> data = Collections.synchronizedList(new ArrayList());

        public ConnectedInput() {
            this.data.add(BlockPos.f_121853_);
        }

        public void attachTo(BlockPos controllerPos, BlockPos myPos) {
            this.isController = false;
            this.data.clear();
            this.data.add(controllerPos.m_121996_((Vec3i)myPos));
        }

        public IItemHandler getItemHandler(Level world, BlockPos pos) {
            List<MechanicalCrafterBlockEntity.Inventory> inventories = this.getInventories(world, pos);
            return new CombinedInvWrapper((IItemHandlerModifiable[])inventories.toArray(IItemHandlerModifiable[]::new));
        }

        public List<MechanicalCrafterBlockEntity.Inventory> getInventories(Level world, BlockPos pos) {
            if (!this.isController) {
                BlockPos controllerPos = pos.m_121955_((Vec3i)this.data.get(0));
                ConnectedInput input = CrafterHelper.getInput((BlockAndTintGetter)world, controllerPos);
                if (input == this || input == null || !input.isController) {
                    return List.of();
                }
                return input.getInventories(world, controllerPos);
            }
            Direction facing = Direction.SOUTH;
            BlockState blockState = world.m_8055_(pos);
            if (blockState.m_61138_(MechanicalCrafterBlock.HORIZONTAL_FACING)) {
                facing = (Direction)blockState.m_61143_(MechanicalCrafterBlock.HORIZONTAL_FACING);
            }
            Direction.AxisDirection axisDirection = facing.m_122421_();
            Direction.Axis compareAxis = facing.m_122427_().m_122434_();
            Comparator invOrdering = (p1, p2) -> {
                int compareY = -Integer.compare(p1.m_123342_(), p2.m_123342_());
                int modifier = axisDirection.m_122540_() * (compareAxis == Direction.Axis.Z ? -1 : 1);
                int c1 = compareAxis.m_7863_(p1.m_123341_(), p1.m_123342_(), p1.m_123343_());
                int c2 = compareAxis.m_7863_(p2.m_123341_(), p2.m_123342_(), p2.m_123343_());
                return compareY != 0 ? compareY : modifier * Integer.compare(c1, c2);
            };
            return this.data.stream().sorted(invOrdering).map(l -> CrafterHelper.getCrafter((BlockAndTintGetter)world, pos.m_121955_((Vec3i)l))).filter(Objects::nonNull).map(MechanicalCrafterBlockEntity::getInventory).collect(Collectors.toList());
        }

        public void write(CompoundTag nbt) {
            nbt.m_128379_("Controller", this.isController);
            ListTag list = new ListTag();
            this.data.forEach(pos -> list.add((Object)NbtUtils.m_129224_((BlockPos)pos)));
            nbt.m_128365_("Data", (Tag)list);
        }

        public void read(CompoundTag nbt) {
            this.isController = nbt.m_128471_("Controller");
            this.data.clear();
            nbt.m_128437_("Data", 10).forEach(inbt -> this.data.add(NbtUtils.m_129239_((CompoundTag)((CompoundTag)inbt))));
            if (this.data.isEmpty()) {
                this.isController = true;
                this.data.add(BlockPos.f_121853_);
            }
        }
    }
}

