/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.cuisinedelight.events;

import dev.xkmc.cuisinedelight.content.item.CuisineSkilletItem;
import dev.xkmc.cuisinedelight.content.logic.IngredientConfig;
import dev.xkmc.cuisinedelight.init.data.TagGen;
import dev.xkmc.cuisinedelight.init.registrate.CDItems;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, modid="cuisinedelight")
public class SkilletUseEventListeners {
    private static boolean noBlockUse(Player player) {
        return player.m_21205_().m_150930_((Item)CDItems.SKILLET.get()) || player.m_21206_().m_150930_((Item)CDItems.SKILLET.get()) && CuisineSkilletItem.canUse(player.m_21206_(), player, player.m_9236_()) && IngredientConfig.get().getEntry(player.m_21205_()) != null;
    }

    private static boolean useOffHand(Player player) {
        if (player.m_21206_().m_150930_((Item)CDItems.SKILLET.get())) {
            return CuisineSkilletItem.canUse(player.m_21206_(), player, player.m_9236_()) && IngredientConfig.get().getEntry(player.m_21205_()) != null;
        }
        if (player.m_21205_().m_150930_((Item)CDItems.SKILLET.get())) {
            return player.m_21206_().m_204117_(TagGen.UTENSILS);
        }
        return false;
    }

    @SubscribeEvent
    public static void onItemRightClick(PlayerInteractEvent.RightClickItem event) {
        if (event.getHand() == InteractionHand.MAIN_HAND && SkilletUseEventListeners.useOffHand(event.getEntity())) {
            event.setCancellationResult(InteractionResult.PASS);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onBlockRightClick(PlayerInteractEvent.RightClickBlock event) {
        if (SkilletUseEventListeners.noBlockUse(event.getEntity())) {
            event.setUseBlock(Event.Result.DENY);
            if (SkilletUseEventListeners.useOffHand(event.getEntity())) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityRightClick(PlayerInteractEvent.EntityInteract event) {
        if (SkilletUseEventListeners.noBlockUse(event.getEntity())) {
            event.setCanceled(true);
        }
    }
}

