/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.respiteful;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.lang3.tuple.Pair;
import plus.dragons.respiteful.entries.RespitefulItems;

public class RespitefulConfig {
    public static final Common COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;

    static void register(ModLoadingContext context, IEventBus modBus) {
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)COMMON_SPEC);
        modBus.addListener(RespitefulConfig::onConfigUpdate);
    }

    public static void onConfigUpdate(ModConfigEvent event) {
        ModConfig config = event.getConfig();
        if (config.getSpec() == COMMON_SPEC) {
            RespitefulItems.Foods.replaceFoodEffects((Boolean)RespitefulConfig.COMMON.replaceFarmersRespiteFoodEffects.get());
        }
    }

    static {
        Pair common = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON = (Common)common.getLeft();
        COMMON_SPEC = (ForgeConfigSpec)common.getRight();
    }

    public static class Common {
        public final ForgeConfigSpec.ConfigValue<Boolean> enableSnowTopDrinkEffects;
        public final ForgeConfigSpec.ConfigValue<Integer> snowTopDrinkEffectMinDuration;
        public final ForgeConfigSpec.ConfigValue<Integer> snowTopDrinkEffectMaxDuration;
        public final ForgeConfigSpec.ConfigValue<Boolean> replaceFarmersRespiteFoodEffects;

        Common(ForgeConfigSpec.Builder builder) {
            builder.push("effects");
            this.enableSnowTopDrinkEffects = builder.comment("If the Snow Top drinks' special effects should be used").define("enableSnowTopDrinkEffects", true);
            this.snowTopDrinkEffectMinDuration = builder.comment("The minimum duration requirement for an effect to be upgraded by Snow Top Green Tea / Snow Top Coffee").defineInRange("snowTopDrinkEffectMinDuration", 400, 1, Integer.MAX_VALUE);
            this.snowTopDrinkEffectMaxDuration = builder.comment("The maximum duration of effects transformed by Snow Top Yellow Tea / Snow Top Black Tea").defineInRange("snowTopDrinkEffectMaxDuration", 32766, 1, Integer.MAX_VALUE);
            this.replaceFarmersRespiteFoodEffects = builder.comment("If the foods made from tea in Farmer's Respite should use Respiteful's effects instead").define("replaceFarmersRespiteFoodEffects", true);
            builder.pop();
        }
    }
}

