/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.respiteful.entries;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.teamabnormals.blueprint.core.util.TradeUtil;
import com.teamabnormals.neapolitan.common.block.FlavoredCakeBlock;
import com.teamabnormals.neapolitan.core.other.tags.NeapolitanItemTags;
import com.teamabnormals.neapolitan.core.registry.NeapolitanItems;
import com.teamabnormals.neapolitan.core.registry.NeapolitanMobEffects;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.util.DataIngredient;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import com.tterrag.registrate.util.nullness.NonNullUnaryOperator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.RegistryObject;
import plus.dragons.respiteful.Respiteful;
import plus.dragons.respiteful.RespitefulRegistrate;
import plus.dragons.respiteful.common.item.EffectExtendingDrinkItem;
import plus.dragons.respiteful.common.item.EffectStrengtheningDrinkItem;
import plus.dragons.respiteful.core.mixin.FoodPropertiesAccessor;
import plus.dragons.respiteful.data.RespitefulRecipes;
import plus.dragons.respiteful.entries.RespitefulBlocks;
import plus.dragons.respiteful.entries.RespitefulMobEffects;
import umpaz.farmersrespite.common.FRFoodValues;
import umpaz.farmersrespite.common.registry.FREffects;
import umpaz.farmersrespite.common.registry.FRItems;
import vectorwing.farmersdelight.common.Configuration;
import vectorwing.farmersdelight.common.item.ConsumableItem;
import vectorwing.farmersdelight.common.item.DrinkableItem;
import vectorwing.farmersdelight.common.registry.ModEffects;
import vectorwing.farmersdelight.common.tag.ForgeTags;

public class RespitefulItems {
    public static final ItemEntry<DrinkableItem> MINT_GREEN_TEA = Respiteful.REGISTRATE.item("mint_green_tea", prop -> new DrinkableItem(prop, true)).properties(prop -> prop.m_41489_(Foods.MINT_GREEN_TEA).m_41487_(16).m_41495_(Items.f_42590_)).register();
    public static final ItemEntry<DrinkableItem> VANILLA_MILK_TEA = Respiteful.REGISTRATE.item("vanilla_milk_tea", prop -> new DrinkableItem(prop, true)).properties(prop -> prop.m_41489_(Foods.VANILLA_MILK_TEA).m_41487_(16).m_41495_(Items.f_42590_)).register();
    public static final ItemEntry<DrinkableItem> ADZUKI_MILK_TEA = Respiteful.REGISTRATE.item("adzuki_milk_tea", prop -> new DrinkableItem(prop, true)).properties(prop -> prop.m_41489_(Foods.ADZUKI_MILK_TEA).m_41487_(16).m_41495_(Items.f_42590_)).register();
    public static final ItemEntry<DrinkableItem> MOCHA_COFFEE = Respiteful.REGISTRATE.item("mocha_coffee", prop -> new DrinkableItem(prop, true)).properties(prop -> prop.m_41489_(Foods.MOCHA_COFFEE).m_41487_(16).m_41495_(Items.f_42590_)).register();
    public static final ItemEntry<EffectStrengtheningDrinkItem> SNOW_TOP_GREEN_TEA = ((ItemBuilder)Respiteful.REGISTRATE.item("snow_top_green_tea", prop -> new EffectStrengtheningDrinkItem(MobEffectCategory.BENEFICIAL, (Item.Properties)prop)).properties(prop -> prop.m_41489_(Foods.SNOW_TOP_DRINK).m_41487_(16).m_41495_(Items.f_42590_)).recipe((ctx, prov) -> RespitefulRecipes.snowTopDrink((DataGenContext<Item, ? extends Item>)ctx, prov, (NonNullSupplier<? extends Item>)((NonNullSupplier)() -> ((RegistryObject)FRItems.GREEN_TEA).get()))).transform(RespitefulItems.tooltip("Strengthen all beneficial effects and reduce their duration"))).register();
    public static final ItemEntry<EffectExtendingDrinkItem> SNOW_TOP_YELLOW_TEA = ((ItemBuilder)Respiteful.REGISTRATE.item("snow_top_yellow_tea", prop -> new EffectExtendingDrinkItem(MobEffectCategory.HARMFUL, (Item.Properties)prop)).properties(prop -> prop.m_41489_(Foods.SNOW_TOP_DRINK).m_41487_(16).m_41495_(Items.f_42590_)).recipe((ctx, prov) -> RespitefulRecipes.snowTopDrink((DataGenContext<Item, ? extends Item>)ctx, prov, (NonNullSupplier<? extends Item>)((NonNullSupplier)() -> ((RegistryObject)FRItems.YELLOW_TEA).get()))).transform(RespitefulItems.tooltip("Weaken all harmful effects and extend their duration"))).register();
    public static final ItemEntry<EffectExtendingDrinkItem> SNOW_TOP_BLACK_TEA = ((ItemBuilder)Respiteful.REGISTRATE.item("snow_top_black_tea", prop -> new EffectExtendingDrinkItem(MobEffectCategory.BENEFICIAL, (Item.Properties)prop)).properties(prop -> prop.m_41489_(Foods.SNOW_TOP_DRINK).m_41487_(16).m_41495_(Items.f_42590_)).recipe((ctx, prov) -> RespitefulRecipes.snowTopDrink((DataGenContext<Item, ? extends Item>)ctx, prov, (NonNullSupplier<? extends Item>)((NonNullSupplier)() -> ((RegistryObject)FRItems.BLACK_TEA).get()))).transform(RespitefulItems.tooltip("Extend all beneficial effects' duration and weaken them"))).register();
    public static final ItemEntry<EffectStrengtheningDrinkItem> SNOW_TOP_COFFEE = ((ItemBuilder)Respiteful.REGISTRATE.item("snow_top_coffee", prop -> new EffectStrengtheningDrinkItem(MobEffectCategory.HARMFUL, (Item.Properties)prop)).properties(prop -> prop.m_41489_(Foods.SNOW_TOP_DRINK).m_41487_(16).m_41495_(Items.f_42590_)).recipe((ctx, prov) -> RespitefulRecipes.snowTopDrink((DataGenContext<Item, ? extends Item>)ctx, prov, (NonNullSupplier<? extends Item>)((NonNullSupplier)() -> ((RegistryObject)FRItems.COFFEE).get()))).transform(RespitefulItems.tooltip("Reduce all harmful effects' duration and strengthen them"))).register();
    public static final ItemEntry<ConsumableItem> GREEN_TEA_CAKE_SLICE = RespitefulItems.cakeSlice(RespitefulBlocks.GREEN_TEA_CAKE, Foods.GREEN_TEA_CAKE_SLICE).lang("Slice of Green Tea Cake").register();
    public static final ItemEntry<ConsumableItem> YELLOW_TEA_CAKE_SLICE = RespitefulItems.cakeSlice(RespitefulBlocks.YELLOW_TEA_CAKE, Foods.YELLOW_TEA_CAKE_SLICE).lang("Slice of Yellow Tea Cake").register();
    public static final ItemEntry<ConsumableItem> BLACK_TEA_CAKE_SLICE = RespitefulItems.cakeSlice(RespitefulBlocks.BLACK_TEA_CAKE, Foods.BLACK_TEA_CAKE_SLICE).lang("Slice of Black Tea Cake").register();
    public static final ItemEntry<ConsumableItem> GREEN_TEA_ICE_CREAM = RespitefulItems.iceCream("green_tea_ice_cream", Foods.GREEN_TEA_ICE_CREAM).recipe((ctx, prov) -> RespitefulRecipes.iceCream((DataGenContext<Item, ? extends Item>)ctx, prov, (NonNullSupplier<? extends Item>)((NonNullSupplier)() -> ((RegistryObject)FRItems.GREEN_TEA_LEAVES).get()))).register();
    public static final ItemEntry<ConsumableItem> YELLOW_TEA_ICE_CREAM = RespitefulItems.iceCream("yellow_tea_ice_cream", Foods.YELLOW_TEA_ICE_CREAM).recipe((ctx, prov) -> RespitefulRecipes.iceCream((DataGenContext<Item, ? extends Item>)ctx, prov, (NonNullSupplier<? extends Item>)((NonNullSupplier)() -> ((RegistryObject)FRItems.YELLOW_TEA_LEAVES).get()))).register();
    public static final ItemEntry<ConsumableItem> BLACK_TEA_ICE_CREAM = RespitefulItems.iceCream("black_tea_ice_cream", Foods.BLACK_TEA_ICE_CREAM).recipe((ctx, prov) -> RespitefulRecipes.iceCream((DataGenContext<Item, ? extends Item>)ctx, prov, (NonNullSupplier<? extends Item>)((NonNullSupplier)() -> ((RegistryObject)FRItems.BLACK_TEA_LEAVES).get()))).register();
    public static final ItemEntry<ConsumableItem> COFFEE_ICE_CREAM = RespitefulItems.iceCream("coffee_ice_cream", Foods.COFFEE_ICE_CREAM).recipe((ctx, prov) -> RespitefulRecipes.iceCream((DataGenContext<Item, ? extends Item>)ctx, prov, (NonNullSupplier<? extends Item>)((NonNullSupplier)() -> ((RegistryObject)FRItems.COFFEE_BEANS).get()))).register();
    public static final ItemEntry<ConsumableItem> RESPITEFUL_ICE_CREAM = RespitefulItems.iceCream("respiteful_ice_cream", Foods.RESPITEFUL_ICE_CREAM).recipe((ctx, prov) -> {
        DataIngredient greenTea = DataIngredient.items((ItemLike)((Item)FRItems.GREEN_TEA_LEAVES.get()), (ItemLike[])new Item[0]);
        DataIngredient yellowTea = DataIngredient.items((ItemLike)((Item)FRItems.YELLOW_TEA_LEAVES.get()), (ItemLike[])new Item[0]);
        DataIngredient blackTea = DataIngredient.items((ItemLike)((Item)FRItems.BLACK_TEA_LEAVES.get()), (ItemLike[])new Item[0]);
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ctx.getEntry())).m_126209_((ItemLike)Items.f_42399_).m_126184_((Ingredient)greenTea).m_126184_((Ingredient)yellowTea).m_126184_((Ingredient)blackTea).m_206419_(ForgeTags.MILK).m_126209_((ItemLike)NeapolitanItems.ICE_CUBES.get()).m_126209_((ItemLike)Items.f_42501_).m_126132_("has_" + prov.safeName(greenTea), (CriterionTriggerInstance)greenTea.getCritereon(prov)).m_126132_("has_" + prov.safeName(yellowTea), (CriterionTriggerInstance)yellowTea.getCritereon(prov)).m_126132_("has_" + prov.safeName(blackTea), (CriterionTriggerInstance)blackTea.getCritereon(prov)).m_176498_((Consumer)prov);
    }).register();

    private static <T extends Item> NonNullUnaryOperator<ItemBuilder<T, RespitefulRegistrate>> tooltip(String tooltip) {
        return builder -> {
            ResourceLocation id = new ResourceLocation(builder.getOwner().getModid(), builder.getName());
            return (ItemBuilder)builder.addMiscData(ProviderType.LANG, prov -> prov.add(Util.m_137492_((String)"tooltip", (ResourceLocation)id), tooltip));
        };
    }

    private static ItemBuilder<ConsumableItem, RespitefulRegistrate> cakeSlice(BlockEntry<FlavoredCakeBlock> cake, FoodProperties food) {
        return Respiteful.REGISTRATE.item(cake.getId().m_135815_() + "_slice", prop -> new ConsumableItem(prop, true)).properties(prop -> prop.m_41489_(food));
    }

    private static ItemBuilder<ConsumableItem, RespitefulRegistrate> iceCream(String name, FoodProperties food) {
        return Respiteful.REGISTRATE.item(name, prop -> new ConsumableItem(prop, true)).properties(prop -> prop.m_41489_(food).m_41487_(1).m_41495_(Items.f_42399_)).tag(new TagKey[]{NeapolitanItemTags.ICE_CREAM});
    }

    public static void register(IEventBus modBus) {
    }

    public static class Foods {
        public static final FoodProperties MINT_GREEN_TEA = new FoodProperties.Builder().m_38765_().effect(() -> new MobEffectInstance((MobEffect)RespitefulMobEffects.VITALITY.get(), 1200), 1.0f).effect(() -> new MobEffectInstance((MobEffect)NeapolitanMobEffects.BERSERKING.get(), 1200), 1.0f).m_38767_();
        public static final FoodProperties VANILLA_MILK_TEA = new FoodProperties.Builder().m_38765_().effect(() -> new MobEffectInstance((MobEffect)RespitefulMobEffects.TENACITY.get(), 1200), 1.0f).effect(() -> new MobEffectInstance((MobEffect)NeapolitanMobEffects.VANILLA_SCENT.get(), 1200), 1.0f).m_38767_();
        public static final FoodProperties ADZUKI_MILK_TEA = new FoodProperties.Builder().m_38765_().effect(() -> new MobEffectInstance((MobEffect)RespitefulMobEffects.MATURITY.get(), 1200), 1.0f).effect(() -> new MobEffectInstance((MobEffect)NeapolitanMobEffects.HARMONY.get(), 1200), 1.0f).m_38767_();
        public static final FoodProperties MOCHA_COFFEE = new FoodProperties.Builder().m_38765_().effect(() -> new MobEffectInstance((MobEffect)NeapolitanMobEffects.SUGAR_RUSH.get(), 3600), 1.0f).effect(() -> new MobEffectInstance((MobEffect)FREffects.CAFFEINATED.get(), 6000), 1.0f).m_38767_();
        public static final FoodProperties SNOW_TOP_DRINK = new FoodProperties.Builder().m_38760_(3).m_38758_(0.6f).m_38767_();
        public static final FoodProperties GREEN_TEA_CAKE = new FoodProperties.Builder().m_38760_(2).m_38758_(0.1f).m_38766_().m_38765_().effect(() -> new MobEffectInstance((MobEffect)RespitefulMobEffects.VITALITY.get(), 400), 1.0f).m_38767_();
        public static final FoodProperties GREEN_TEA_CAKE_SLICE = new FoodProperties.Builder().m_38760_(2).m_38758_(0.1f).m_38766_().m_38765_().effect(() -> new MobEffectInstance((MobEffect)RespitefulMobEffects.VITALITY.get(), 400), 1.0f).effect(() -> new MobEffectInstance(MobEffects.f_19596_, 400), 1.0f).m_38767_();
        public static final FoodProperties YELLOW_TEA_CAKE = new FoodProperties.Builder().m_38760_(2).m_38758_(0.1f).m_38766_().m_38765_().effect(() -> new MobEffectInstance((MobEffect)RespitefulMobEffects.TENACITY.get(), 400), 1.0f).m_38767_();
        public static final FoodProperties YELLOW_TEA_CAKE_SLICE = new FoodProperties.Builder().m_38760_(2).m_38758_(0.1f).m_38766_().m_38765_().effect(() -> new MobEffectInstance((MobEffect)RespitefulMobEffects.TENACITY.get(), 400), 1.0f).effect(() -> new MobEffectInstance(MobEffects.f_19596_, 400), 1.0f).m_38767_();
        public static final FoodProperties BLACK_TEA_CAKE = new FoodProperties.Builder().m_38760_(2).m_38758_(0.1f).m_38766_().m_38765_().effect(() -> new MobEffectInstance((MobEffect)RespitefulMobEffects.MATURITY.get(), 400), 1.0f).m_38767_();
        public static final FoodProperties BLACK_TEA_CAKE_SLICE = new FoodProperties.Builder().m_38760_(2).m_38758_(0.1f).m_38766_().m_38765_().effect(() -> new MobEffectInstance((MobEffect)RespitefulMobEffects.MATURITY.get(), 400), 1.0f).effect(() -> new MobEffectInstance(MobEffects.f_19596_, 400), 1.0f).m_38767_();
        public static final FoodProperties GREEN_TEA_ICE_CREAM = new FoodProperties.Builder().m_38760_(6).m_38758_(0.4f).m_38765_().effect(() -> new MobEffectInstance(MobEffects.f_19597_, 100, 2), 1.0f).effect(() -> new MobEffectInstance((MobEffect)RespitefulMobEffects.VITALITY.get(), 600, 1), 1.0f).m_38767_();
        public static final FoodProperties YELLOW_TEA_ICE_CREAM = new FoodProperties.Builder().m_38760_(6).m_38758_(0.4f).m_38765_().effect(() -> new MobEffectInstance(MobEffects.f_19597_, 100, 2), 1.0f).effect(() -> new MobEffectInstance((MobEffect)RespitefulMobEffects.TENACITY.get(), 600, 1), 1.0f).m_38767_();
        public static final FoodProperties BLACK_TEA_ICE_CREAM = new FoodProperties.Builder().m_38760_(6).m_38758_(0.4f).m_38765_().effect(() -> new MobEffectInstance(MobEffects.f_19597_, 100, 2), 1.0f).effect(() -> new MobEffectInstance((MobEffect)RespitefulMobEffects.MATURITY.get(), 600, 1), 1.0f).m_38767_();
        public static final FoodProperties COFFEE_ICE_CREAM = new FoodProperties.Builder().m_38760_(6).m_38758_(0.4f).m_38765_().effect(() -> new MobEffectInstance(MobEffects.f_19597_, 100, 2), 1.0f).effect(() -> new MobEffectInstance((MobEffect)FREffects.CAFFEINATED.get(), 1200, 2), 1.0f).m_38767_();
        public static final FoodProperties RESPITEFUL_ICE_CREAM = new FoodProperties.Builder().m_38760_(12).m_38758_(0.4f).m_38765_().effect(() -> new MobEffectInstance(MobEffects.f_19597_, 100, 2), 1.0f).effect(() -> new MobEffectInstance((MobEffect)RespitefulMobEffects.VITALITY.get(), 900), 1.0f).effect(() -> new MobEffectInstance((MobEffect)RespitefulMobEffects.TENACITY.get(), 900), 1.0f).effect(() -> new MobEffectInstance((MobEffect)RespitefulMobEffects.MATURITY.get(), 900), 1.0f).m_38767_();
        private static final Map<FoodProperties, Pair<List<Pair<Supplier<MobEffectInstance>, Float>>, List<Pair<Supplier<MobEffectInstance>, Float>>>> FOOD_EFFECTS_REPLACEMENTS = new HashMap<FoodProperties, Pair<List<Pair<Supplier<MobEffectInstance>, Float>>, List<Pair<Supplier<MobEffectInstance>, Float>>>>();

        @SafeVarargs
        private static void addReplacement(FoodProperties food, Pair<Supplier<MobEffectInstance>, Float> ... effects) {
            FOOD_EFFECTS_REPLACEMENTS.put(food, (Pair<List<Pair<Supplier<MobEffectInstance>, Float>>, List<Pair<Supplier<MobEffectInstance>, Float>>>)new Pair(((FoodPropertiesAccessor)food).getEffectSuppliers(), (Object)Lists.newArrayList((Object[])effects)));
        }

        public static void replaceFoodEffects(boolean replace) {
            FOOD_EFFECTS_REPLACEMENTS.forEach((food, pair) -> ((FoodPropertiesAccessor)food).setEffects(replace ? (List)pair.getSecond() : (List)pair.getFirst()));
        }

        static {
            Foods.addReplacement(FRFoodValues.GREEN_TEA, new Pair(() -> new MobEffectInstance((MobEffect)RespitefulMobEffects.VITALITY.get(), 1800), (Object)Float.valueOf(1.0f)));
            Foods.addReplacement(FRFoodValues.LONG_GREEN_TEA, new Pair(() -> new MobEffectInstance((MobEffect)RespitefulMobEffects.VITALITY.get(), 3600), (Object)Float.valueOf(1.0f)));
            Foods.addReplacement(FRFoodValues.STRONG_GREEN_TEA, new Pair(() -> new MobEffectInstance((MobEffect)RespitefulMobEffects.VITALITY.get(), 1200, 1), (Object)Float.valueOf(1.0f)));
            Foods.addReplacement(FRFoodValues.GREEN_TEA_COOKIE, new Pair(() -> new MobEffectInstance((MobEffect)RespitefulMobEffects.VITALITY.get(), 100), (Object)Float.valueOf(1.0f)));
            Foods.addReplacement(FRFoodValues.YELLOW_TEA, new Pair(() -> new MobEffectInstance((MobEffect)RespitefulMobEffects.TENACITY.get(), 1800), (Object)Float.valueOf(1.0f)));
            Foods.addReplacement(FRFoodValues.LONG_YELLOW_TEA, new Pair(() -> new MobEffectInstance((MobEffect)RespitefulMobEffects.TENACITY.get(), 3600), (Object)Float.valueOf(1.0f)));
            Foods.addReplacement(FRFoodValues.STRONG_YELLOW_TEA, new Pair(() -> new MobEffectInstance((MobEffect)RespitefulMobEffects.TENACITY.get(), 1200, 1), (Object)Float.valueOf(1.0f)));
            Foods.addReplacement(FRFoodValues.TEA_CURRY, new Pair(() -> new MobEffectInstance((MobEffect)ModEffects.NOURISHMENT.get(), 3600, 0), (Object)Float.valueOf(1.0f)), new Pair(() -> new MobEffectInstance((MobEffect)RespitefulMobEffects.TENACITY.get(), 600), (Object)Float.valueOf(1.0f)));
            Foods.addReplacement(FRFoodValues.BLACK_TEA, new Pair(() -> new MobEffectInstance((MobEffect)RespitefulMobEffects.MATURITY.get(), 1800), (Object)Float.valueOf(1.0f)));
            Foods.addReplacement(FRFoodValues.LONG_BLACK_TEA, new Pair(() -> new MobEffectInstance((MobEffect)RespitefulMobEffects.MATURITY.get(), 3600), (Object)Float.valueOf(1.0f)));
            Foods.addReplacement(FRFoodValues.STRONG_BLACK_TEA, new Pair(() -> new MobEffectInstance((MobEffect)RespitefulMobEffects.MATURITY.get(), 1200, 1), (Object)Float.valueOf(1.0f)));
            Foods.addReplacement(FRFoodValues.BLACK_COD, new Pair(() -> new MobEffectInstance((MobEffect)ModEffects.NOURISHMENT.get(), 3600, 0), (Object)Float.valueOf(1.0f)), new Pair(() -> new MobEffectInstance((MobEffect)RespitefulMobEffects.MATURITY.get(), 600), (Object)Float.valueOf(1.0f)));
        }
    }

    @Mod.EventBusSubscriber(modid="respiteful")
    public static class ForgeEventHandler {
        @SubscribeEvent
        public static void onWandererTrades(WandererTradesEvent event) {
            if (((Boolean)Configuration.FARMERS_BUY_FD_CROPS.get()).booleanValue()) {
                List trades = event.getGenericTrades();
                trades.add(new TradeUtil.BlueprintTrade(((FlavoredCakeBlock)RespitefulBlocks.GREEN_TEA_CAKE.get()).m_5456_(), 1, 13, 12, 30));
                trades.add(new TradeUtil.BlueprintTrade(((FlavoredCakeBlock)RespitefulBlocks.YELLOW_TEA_CAKE.get()).m_5456_(), 1, 13, 12, 30));
                trades.add(new TradeUtil.BlueprintTrade(((FlavoredCakeBlock)RespitefulBlocks.BLACK_TEA_CAKE.get()).m_5456_(), 1, 13, 12, 30));
            }
        }
    }
}

