/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.petrolpark.PetrolparkRegistries;
import com.petrolpark.contamination.Contaminant;
import com.petrolpark.contamination.ItemContamination;
import java.util.Collection;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class ContaminateCommand {
    private static final DynamicCommandExceptionType ERROR_NOT_LIVING_ENTITY = new DynamicCommandExceptionType(name -> Component.m_237110_((String)"commands.petrolpark.contaminate.failed.entity", (Object[])new Object[]{name}));
    private static final DynamicCommandExceptionType ERROR_NO_ITEM = new DynamicCommandExceptionType(name -> Component.m_237110_((String)"commands.petrolpark.contaminate.failed.itemless", (Object[])new Object[]{name}));
    private static final SimpleCommandExceptionType ERROR_NOTHING_HAPPENED = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"commands.petrolpark.contaminate.failed"));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"contaminate").requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).then(Commands.m_82129_((String)"contaminant", (ArgumentType)ResourceArgument.m_247102_((CommandBuildContext)context, PetrolparkRegistries.Keys.CONTAMINANT)).executes(ctx -> ContaminateCommand.contaminate((CommandSourceStack)ctx.getSource(), EntityArgument.m_91461_((CommandContext)ctx, (String)"targets"), (Holder<Contaminant>)ResourceArgument.m_246781_((CommandContext)ctx, (String)"contaminant", PetrolparkRegistries.Keys.CONTAMINANT))))));
    }

    private static int contaminate(CommandSourceStack source, Collection<? extends Entity> targets, Holder<Contaminant> contaminantHolder) throws CommandSyntaxException {
        Contaminant contaminant = (Contaminant)contaminantHolder.get();
        int i = 0;
        for (Entity entity : targets) {
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                ItemStack itemStack = livingEntity.m_21205_();
                if (!itemStack.m_41619_()) {
                    try {
                        if (!ItemContamination.get(itemStack).contaminate(contaminant)) continue;
                        ++i;
                    }
                    catch (Throwable throwable) {}
                    continue;
                }
                if (targets.size() != 1) continue;
                throw ERROR_NO_ITEM.create((Object)livingEntity.m_7755_().getString());
            }
            if (targets.size() != 1) continue;
            throw ERROR_NOT_LIVING_ENTITY.create((Object)entity.m_7755_().getString());
        }
        if (i == 0) {
            throw ERROR_NOTHING_HAPPENED.create();
        }
        if (targets.size() == 1) {
            source.m_288197_(() -> Component.m_237110_((String)"commands.petrolpark.contaminate.success.single", (Object[])new Object[]{contaminant.getName(), ((Entity)targets.iterator().next()).m_5446_()}), true);
        } else {
            source.m_288197_(() -> Component.m_237110_((String)"commands.petrolpark.contaminate.success.multiple", (Object[])new Object[]{contaminant.getName(), targets.size()}), true);
        }
        return i;
    }
}

