/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.contamination;

import com.petrolpark.contamination.Contaminant;
import com.petrolpark.contamination.IContamination;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class IntrinsicContaminants {
    protected static final Map<Object, Set<Contaminant>> INTRINSIC_CONTAMINANTS = new HashMap<Object, Set<Contaminant>>();
    protected static final Map<Object, Set<Contaminant>> SHOWN_IF_ABSENT_CONTAMINANTS = new HashMap<Object, Set<Contaminant>>();

    public static void clear() {
        INTRINSIC_CONTAMINANTS.clear();
        SHOWN_IF_ABSENT_CONTAMINANTS.clear();
    }

    protected static <OBJECT> Set<Contaminant> get(IContamination<OBJECT, ?> contamination) {
        return INTRINSIC_CONTAMINANTS.computeIfAbsent(contamination.getType(), obj -> IntrinsicContaminants.withChildren(contamination.getContaminable().getIntrinsicContaminants(contamination.getType())));
    }

    protected static <OBJECT> Set<Contaminant> getShownIfAbsent(IContamination<OBJECT, ?> contamination) {
        return SHOWN_IF_ABSENT_CONTAMINANTS.computeIfAbsent(contamination.getType(), obj -> IntrinsicContaminants.withChildren(contamination.getContaminable().getShownIfAbsentContaminants(contamination.getType())));
    }

    @SubscribeEvent
    public static final void onTagsUpdated(TagsUpdatedEvent event) {
        IntrinsicContaminants.clear();
    }

    private static Set<Contaminant> withChildren(Set<Contaminant> contaminants) {
        return Stream.concat(contaminants.stream(), contaminants.stream().map(Contaminant::getChildren).flatMap(Collection::stream)).collect(Collectors.toSet());
    }
}

