/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.data.reward;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.petrolpark.data.IEntityTarget;
import com.petrolpark.data.reward.ContextEntityReward;
import com.petrolpark.data.reward.RewardType;
import com.petrolpark.data.reward.RewardTypes;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.storage.loot.LootContext;

public class UnlockTradeReward
extends ContextEntityReward {
    public final MerchantOffer trade;

    public UnlockTradeReward(IEntityTarget target, MerchantOffer trade) {
        super(target);
        this.trade = trade;
    }

    @Override
    public void reward(Entity entity, LootContext context, float multiplier) {
        if (entity instanceof Merchant) {
            Merchant merchant = (Merchant)entity;
            merchant.m_6616_().add((Object)this.trade);
        }
    }

    @Override
    public void render(GuiGraphics graphics) {
        throw new UnsupportedOperationException("Unimplemented method 'render'");
    }

    @Override
    public Component getName() {
        throw new UnsupportedOperationException("Unimplemented method 'getName'");
    }

    @Override
    public RewardType getType() {
        return (RewardType)((Object)RewardTypes.UNLOCK_TRADE.get());
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<UnlockTradeReward> {
        public void serialize(JsonObject json, UnlockTradeReward value, JsonSerializationContext serializationContext) {
            json.addProperty("target", value.target.name());
            CompoundTag.f_128325_.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)value.trade.m_45384_()).resultOrPartial(err -> {
                throw new IllegalStateException((String)err);
            }).ifPresent(element -> json.add("trade", element));
        }

        public UnlockTradeReward deserialize(JsonObject json, JsonDeserializationContext serializationContext) {
            IEntityTarget target = IEntityTarget.getByName(GsonHelper.m_13906_((JsonObject)json, (String)"target"));
            Optional op = CompoundTag.f_128325_.decode((DynamicOps)JsonOps.INSTANCE, (Object)GsonHelper.m_13930_((JsonObject)json, (String)"trade")).resultOrPartial(err -> {
                throw new JsonSyntaxException(err);
            });
            if (op.isEmpty()) {
                throw new JsonSyntaxException("Unlock Trade reward specifies no or an invalid trade");
            }
            return new UnlockTradeReward(target, new MerchantOffer((CompoundTag)((Pair)op.get()).getFirst()));
        }
    }
}

