/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.recipe.manualonly;

import com.google.gson.JsonObject;
import com.petrolpark.PetrolparkRecipeTypes;
import com.petrolpark.PetrolparkTags;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ManualOnlyShapedRecipe
extends ShapedRecipe {
    public ManualOnlyShapedRecipe(ResourceLocation id, String group, CraftingBookCategory category, int width, int height, NonNullList<Ingredient> recipeItems, ItemStack result) {
        super(id, group, category, width, height, recipeItems, result);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isAllowed(CraftingContainer inv) {
        if (!(inv instanceof TransientCraftingContainer)) return false;
        TransientCraftingContainer container = (TransientCraftingContainer)inv;
        if (container.f_286998_ instanceof InventoryMenu) return true;
        if (!PetrolparkTags.MenuTypes.ALLOWS_MANUAL_ONLY_CRAFTING.matches(container.f_286998_)) return false;
        return true;
    }

    public boolean m_5818_(CraftingContainer inv, Level level) {
        return super.m_5818_(inv, level) && ManualOnlyShapedRecipe.isAllowed(inv);
    }

    public boolean m_5598_() {
        return true;
    }

    public RecipeSerializer<?> m_7707_() {
        return PetrolparkRecipeTypes.MANUAL_ONLY_CRAFTING_SHAPED.getSerializer();
    }

    public ItemStack getExampleResult() {
        return this.m_8043_(null);
    }

    public static class Serializer
    implements RecipeSerializer<ManualOnlyShapedRecipe> {
        private final ShapedRecipe.Serializer parent = new ShapedRecipe.Serializer();

        public ManualOnlyShapedRecipe fromJson(ResourceLocation recipeId, JsonObject serializedRecipe) {
            ShapedRecipe recipe = this.parent.m_6729_(recipeId, serializedRecipe);
            return new ManualOnlyShapedRecipe(recipeId, recipe.m_6076_(), recipe.m_245232_(), recipe.m_44220_(), recipe.m_44221_(), (NonNullList<Ingredient>)recipe.m_7527_(), recipe.m_8043_(null));
        }

        @Nullable
        public ManualOnlyShapedRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            ShapedRecipe recipe = this.parent.m_8005_(recipeId, buffer);
            return new ManualOnlyShapedRecipe(recipeId, recipe.m_6076_(), recipe.m_245232_(), recipe.m_44220_(), recipe.m_44221_(), (NonNullList<Ingredient>)recipe.m_7527_(), recipe.m_8043_(null));
        }

        public void toNetwork(FriendlyByteBuf buffer, ManualOnlyShapedRecipe recipe) {
            this.parent.m_6178_(buffer, (ShapedRecipe)recipe);
        }
    }
}

