/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.petrolsparts.content.differential;

import com.petrolpark.compat.create.block.entity.behaviour.AbstractRememberPlacerBehaviour;
import com.petrolpark.petrolsparts.PetrolsPartsBlockEntityTypes;
import com.petrolpark.petrolsparts.PetrolsPartsBlocks;
import com.petrolpark.petrolsparts.content.differential.DifferentialBlockEntity;
import com.petrolpark.petrolsparts.core.advancement.PetrolsPartsAdvancementBehaviour;
import com.petrolpark.petrolsparts.core.block.DirectionalRotatedPillarKineticBlock;
import com.petrolpark.util.KineticsHelper;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.simpleRelays.CogWheelBlock;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DifferentialBlock
extends CogWheelBlock {
    public static final BooleanProperty FULL_MODEL = BooleanProperty.m_61465_((String)"full_model");

    public DifferentialBlock(BlockBehaviour.Properties properties) {
        super(true, properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FULL_MODEL, (Comparable)Boolean.valueOf(true)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{DirectionalRotatedPillarKineticBlock.POSITIVE_AXIS_DIRECTION});
        builder.m_61104_(new Property[]{FULL_MODEL});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)super.m_5573_(context).m_61124_((Property)FULL_MODEL, (Comparable)Boolean.valueOf(false));
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (((Boolean)state.m_61143_((Property)FULL_MODEL)).booleanValue()) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)FULL_MODEL, (Comparable)Boolean.valueOf(false)));
        }
        super.m_6807_(state, level, pos, oldState, isMoving);
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.m_6402_(worldIn, pos, state, placer, stack);
        AbstractRememberPlacerBehaviour.setPlacedBy((Level)worldIn, (BlockPos)pos, (LivingEntity)placer);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return Shapes.m_83144_();
    }

    public void onNeighborChange(BlockState state, LevelReader level, BlockPos pos, BlockPos neighbor) {
        this.withBlockEntityDo((BlockGetter)level, pos, be -> {
            DifferentialBlockEntity differential;
            BlockEntity neighborBE = level.m_7702_(neighbor);
            Direction directionBetween = KineticsHelper.directionBetween((BlockPos)pos, (BlockPos)neighbor);
            Direction differentialDirection = DirectionalRotatedPillarKineticBlock.getDirection(state);
            if (be instanceof DifferentialBlockEntity && (differential = (DifferentialBlockEntity)((Object)be)).m_58898_() && directionBetween == differentialDirection.m_122424_()) {
                float newControlSpeed = 0.0f;
                if (neighborBE instanceof KineticBlockEntity) {
                    KineticBlockEntity kbe = (KineticBlockEntity)neighborBE;
                    newControlSpeed = differential.getPropagatedSpeed(kbe, differentialDirection);
                }
                if (differential.oldControlSpeed != newControlSpeed) {
                    differential.m_58904_().m_186460_(pos, (Block)this, 1);
                }
            }
        });
        super.onNeighborChange(state, level, pos, neighbor);
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        level.m_46597_(pos, (BlockState)((BlockState)PetrolsPartsBlocks.DUMMY_DIFFERENTIAL.getDefaultState().m_61124_((Property)AXIS, (Comparable)((Direction.Axis)state.m_61143_((Property)AXIS)))).m_61124_((Property)DirectionalRotatedPillarKineticBlock.POSITIVE_AXIS_DIRECTION, (Comparable)((Boolean)state.m_61143_((Property)DirectionalRotatedPillarKineticBlock.POSITIVE_AXIS_DIRECTION))));
        PetrolsPartsAdvancementBehaviour behaviour = (PetrolsPartsAdvancementBehaviour)BlockEntityBehaviour.get((BlockGetter)level, (BlockPos)pos, PetrolsPartsAdvancementBehaviour.TYPE);
        AbstractRememberPlacerBehaviour.setPlacedBy((Level)level, (BlockPos)pos, (LivingEntity)behaviour.getPlayer());
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return face == DirectionalRotatedPillarKineticBlock.getDirection(state);
    }

    public boolean isLargeCog() {
        return true;
    }

    public boolean isDedicatedCogWheel() {
        return true;
    }

    public BlockEntityType<? extends KineticBlockEntity> getBlockEntityType() {
        return (BlockEntityType)PetrolsPartsBlockEntityTypes.DIFFERENTIAL.get();
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return (Direction.Axis)state.m_61143_((Property)AXIS);
    }
}

