/*
 * Decompiled with CFR 0.152.
 */
package guideme.document.block.recipes;

import guideme.document.DefaultStyles;
import guideme.document.LytRect;
import guideme.document.block.LytSlot;
import guideme.document.block.LytSlotGrid;
import guideme.document.block.recipes.LytRecipeBox;
import guideme.internal.util.Platform;
import guideme.layout.LayoutContext;
import guideme.render.GuiAssets;
import guideme.render.RenderContext;
import guideme.siteexport.ExportableResourceProvider;
import java.util.List;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.SmithingTransformRecipe;
import net.minecraft.world.item.crafting.SmithingTrimRecipe;
import net.minecraft.world.level.block.Blocks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated(forRemoval=true)
public class LytSmithingRecipe
extends LytRecipeBox
implements ExportableResourceProvider {
    private static final Logger LOG = LoggerFactory.getLogger(LytSmithingRecipe.class);
    private final SmithingRecipe recipe;
    private final LytSlotGrid inputGrid;
    private final LytSlot resultSlot;

    public LytSmithingRecipe(SmithingRecipe recipe) {
        super((Recipe<?>)recipe);
        this.recipe = recipe;
        this.setPadding(5);
        this.paddingTop = 15;
        this.inputGrid = LytSlotGrid.row(LytSmithingRecipe.getIngredients(this.recipe), true);
        this.append(this.inputGrid);
        this.resultSlot = new LytSlot(this.recipe.m_8043_(Platform.getClientRegistryAccess()));
        this.append(this.resultSlot);
    }

    private static List<Ingredient> getIngredients(SmithingRecipe recipe) {
        if (recipe instanceof SmithingTrimRecipe) {
            SmithingTrimRecipe trimRecipe = (SmithingTrimRecipe)recipe;
            return List.of(trimRecipe.f_265958_, trimRecipe.f_266040_, trimRecipe.f_266053_);
        }
        if (recipe instanceof SmithingTransformRecipe) {
            SmithingTransformRecipe transformRecipe = (SmithingTransformRecipe)recipe;
            return List.of(transformRecipe.f_265949_, transformRecipe.f_265888_, transformRecipe.f_265907_);
        }
        LOG.warn("Cannot determine ingredients of smithing recipe type {}", recipe.getClass());
        return List.of();
    }

    @Override
    protected LytRect computeBoxLayout(LayoutContext context, int x, int y, int availableWidth) {
        LytRect inputBounds = this.inputGrid.layout(context, x, y, availableWidth);
        LytRect resultBounds = this.resultSlot.layout(context, inputBounds.right() + 28, y, availableWidth);
        return LytRect.union(inputBounds, resultBounds);
    }

    @Override
    public void render(RenderContext context) {
        context.renderPanel(this.getBounds());
        context.renderItem(Blocks.f_50625_.m_5456_().m_7968_(), this.bounds.x() + this.paddingLeft, this.bounds.y() + 4, 8.0f, 8.0f);
        context.renderText(Items.f_42775_.m_41466_().getString(), DefaultStyles.CRAFTING_RECIPE_TYPE.mergeWith(DefaultStyles.BASE_STYLE), this.bounds.x() + this.paddingLeft + 10, this.bounds.y() + 4);
        context.fillIcon(new LytRect(this.bounds.right() - 25 - 24, this.bounds.y() + 10 + (this.bounds.height() - 27) / 2, 24, 17), GuiAssets.ARROW);
        super.render(context);
    }
}

