/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.analysis.es;

import guideme.internal.shaded.lucene.analysis.CharArraySet;
import java.util.Arrays;
import java.util.List;

public class SpanishPluralStemmer {
    private static final CharArraySet invariants;
    private static final CharArraySet specialCases;
    private static final List<String> invariantsList;

    public int stem(char[] s, int len) {
        if (len < 4) {
            return len;
        }
        this.removeAccents(s, len);
        if (this.invariant(s, len)) {
            return len;
        }
        if (this.special(s, len)) {
            return len - 2;
        }
        switch (s[len - 1]) {
            case 's': {
                if (!this.isVowel(s[len - 2])) {
                    return len - 1;
                }
                if (s[len - 4] == 'q' || s[len - 4] == 'g' && s[len - 3] == 'u' && (s[len - 2] == 'i' || s[len - 2] == 'e')) {
                    return len - 1;
                }
                if (this.isVowel(s[len - 4]) && s[len - 3] == 'r' && s[len - 2] == 'e') {
                    return len - 2;
                }
                if (this.isVowel(s[len - 4]) && (s[len - 3] == 'd' || s[len - 3] == 'l' || s[len - 3] == 'n' || s[len - 3] == 'x') && s[len - 2] == 'e') {
                    return len - 2;
                }
                if ((s[len - 3] == 'y' || s[len - 3] == 'u') && s[len - 2] == 'e') {
                    return len - 2;
                }
                if ((s[len - 4] == 'u' || s[len - 4] == 'l' || s[len - 4] == 'r' || s[len - 4] == 't' || s[len - 4] == 'n') && s[len - 3] == 'i' && s[len - 2] == 'e') {
                    return len - 2;
                }
                if (s[len - 3] == 's' && s[len - 2] == 'e') {
                    return len - 2;
                }
                if (this.isVowel(s[len - 3]) && s[len - 2] == 'i') {
                    s[len - 2] = 121;
                    return len - 1;
                }
                if (s[len - 3] == 'd' && s[len - 2] == 'i') {
                    s[len - 2] = 121;
                    return len - 1;
                }
                if (s[len - 2] == 'e' && s[len - 3] == 'c') {
                    s[len - 3] = 122;
                    return len - 2;
                }
                if (!this.isVowel(s[len - 2])) break;
                return len - 1;
            }
        }
        return len;
    }

    private boolean isVowel(char c) {
        boolean res = false;
        if (c == 'a' || c == 'e' || c == 'i' || c == 'o' || c == 'u') {
            res = true;
        }
        return res;
    }

    private boolean invariant(char[] s, int len) {
        return invariants.contains(s, 0, len);
    }

    private boolean special(char[] s, int len) {
        return specialCases.contains(s, 0, len);
    }

    private void removeAccents(char[] s, int len) {
        block7: for (int i = 0; i < len; ++i) {
            switch (s[i]) {
                case '\u00e0': 
                case '\u00e1': 
                case '\u00e2': 
                case '\u00e4': {
                    s[i] = 97;
                    continue block7;
                }
                case '\u00f2': 
                case '\u00f3': 
                case '\u00f4': 
                case '\u00f6': {
                    s[i] = 111;
                    continue block7;
                }
                case '\u00e8': 
                case '\u00e9': 
                case '\u00ea': 
                case '\u00eb': {
                    s[i] = 101;
                    continue block7;
                }
                case '\u00f9': 
                case '\u00fa': 
                case '\u00fb': 
                case '\u00fc': {
                    s[i] = 117;
                    continue block7;
                }
                case '\u00ec': 
                case '\u00ed': 
                case '\u00ee': 
                case '\u00ef': {
                    s[i] = 105;
                }
            }
        }
    }

    static {
        invariantsList = Arrays.asList("abrebotellas", "abrecartas", "abrelatas", "afueras", "albatros", "albricias", "aleda\u00f1os", "alexis", "alicates", "analisis", "andurriales", "antitesis", "a\u00f1icos", "apendicitis", "apocalipsis", "arcoiris", "aries", "bilis", "boletus", "boris", "brindis", "cactus", "canutas", "caries", "cascanueces", "cascarrabias", "ciempies", "cifosis", "cortaplumas", "corpus", "cosmos", "cosquillas", "creces", "crisis", "cuatrocientas", "cuatrocientos", "cuelgacapas", "cuentacuentos", "cuentapasos", "cumplea\u00f1os", "doscientas", "doscientos", "dosis", "enseres", "entonces", "esponsales", "estatus", "exequias", "fauces", "forceps", "fotosintesis", "gafas", "gafotas", "gargaras", "gris", "honorarios", "ictus", "jueves", "lapsus", "lavacoches", "lavaplatos", "limpiabotas", "lunes", "maitines", "martes", "mondadientes", "novecientas", "novecientos", "nupcias", "ochocientas", "ochocientos", "pais", "paris", "parabrisas", "paracaidas", "parachoques", "paraguas", "pararrayos", "pisapapeles", "piscis", "portaaviones", "portamaletas", "portamantas", "quinientas", "quinientos", "quitamanchas", "recogepelotas", "rictus", "rompeolas", "sacacorchos", "sacapuntas", "saltamontes", "salvavidas", "seis", "seiscientas", "seiscientos", "setecientas", "setecientos", "sintesis", "tenis", "tifus", "trabalenguas", "vacaciones", "venus", "versus", "viacrucis", "virus", "viveres", "volandas");
        CharArraySet invariantSet = new CharArraySet(invariantsList, true);
        invariants = CharArraySet.unmodifiableSet(invariantSet);
        assert (invariants.size() == invariantsList.size());
        List<String> specialCasesList = Arrays.asList("yoes", "noes", "sies", "clubes", "faralaes", "albalaes", "itemes", "albumes", "sandwiches", "relojes", "bojes", "contrarreloj", "carcajes");
        CharArraySet sepecialSet = new CharArraySet(specialCasesList, true);
        specialCases = CharArraySet.unmodifiableSet(sepecialSet);
    }
}

