/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.analysis.id;

import guideme.internal.shaded.lucene.analysis.TokenFilter;
import guideme.internal.shaded.lucene.analysis.TokenStream;
import guideme.internal.shaded.lucene.analysis.id.IndonesianStemmer;
import guideme.internal.shaded.lucene.analysis.tokenattributes.CharTermAttribute;
import guideme.internal.shaded.lucene.analysis.tokenattributes.KeywordAttribute;
import java.io.IOException;

public final class IndonesianStemFilter
extends TokenFilter {
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    private final KeywordAttribute keywordAtt = this.addAttribute(KeywordAttribute.class);
    private final IndonesianStemmer stemmer = new IndonesianStemmer();
    private final boolean stemDerivational;

    public IndonesianStemFilter(TokenStream input) {
        this(input, true);
    }

    public IndonesianStemFilter(TokenStream input, boolean stemDerivational) {
        super(input);
        this.stemDerivational = stemDerivational;
    }

    @Override
    public boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            if (!this.keywordAtt.isKeyword()) {
                int newlen = this.stemmer.stem(this.termAtt.buffer(), this.termAtt.length(), this.stemDerivational);
                this.termAtt.setLength(newlen);
            }
            return true;
        }
        return false;
    }
}

