/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.facet.range;

import guideme.internal.shaded.lucene.facet.MultiDoubleValues;
import guideme.internal.shaded.lucene.facet.MultiDoubleValuesSource;
import guideme.internal.shaded.lucene.facet.range.LongRange;
import guideme.internal.shaded.lucene.facet.range.Range;
import guideme.internal.shaded.lucene.index.LeafReaderContext;
import guideme.internal.shaded.lucene.search.ConstantScoreScorer;
import guideme.internal.shaded.lucene.search.ConstantScoreWeight;
import guideme.internal.shaded.lucene.search.DocIdSetIterator;
import guideme.internal.shaded.lucene.search.DoubleValues;
import guideme.internal.shaded.lucene.search.DoubleValuesSource;
import guideme.internal.shaded.lucene.search.IndexSearcher;
import guideme.internal.shaded.lucene.search.Query;
import guideme.internal.shaded.lucene.search.QueryVisitor;
import guideme.internal.shaded.lucene.search.ScoreMode;
import guideme.internal.shaded.lucene.search.Scorer;
import guideme.internal.shaded.lucene.search.TwoPhaseIterator;
import guideme.internal.shaded.lucene.search.Weight;
import guideme.internal.shaded.lucene.util.NumericUtils;
import java.io.IOException;
import java.util.Objects;

public final class DoubleRange
extends Range {
    public final double min;
    public final double max;

    public DoubleRange(String label, double minIn, boolean minInclusive, double maxIn, boolean maxInclusive) {
        super(label);
        if (Double.isNaN(minIn)) {
            throw new IllegalArgumentException("min cannot be NaN");
        }
        if (!minInclusive) {
            minIn = Math.nextUp(minIn);
        }
        if (Double.isNaN(maxIn)) {
            throw new IllegalArgumentException("max cannot be NaN");
        }
        if (!maxInclusive) {
            maxIn = Math.nextAfter(maxIn, Double.NEGATIVE_INFINITY);
        }
        if (minIn > maxIn) {
            this.failNoMatch();
        }
        this.min = minIn;
        this.max = maxIn;
    }

    public boolean accept(double value) {
        return value >= this.min && value <= this.max;
    }

    LongRange toLongRange() {
        return new LongRange(this.label, NumericUtils.doubleToSortableLong(this.min), true, NumericUtils.doubleToSortableLong(this.max), true);
    }

    public String toString() {
        return "DoubleRange(" + this.label + ": " + this.min + " to " + this.max + ")";
    }

    public boolean equals(Object _that) {
        if (!(_that instanceof DoubleRange)) {
            return false;
        }
        DoubleRange that = (DoubleRange)_that;
        return that.label.equals(this.label) && Double.compare(that.min, this.min) == 0 && Double.compare(that.max, this.max) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.label, this.min, this.max);
    }

    public Query getQuery(Query fastMatchQuery, DoubleValuesSource valueSource) {
        return new ValueSourceQuery(this, fastMatchQuery, valueSource);
    }

    public Query getQuery(Query fastMatchQuery, MultiDoubleValuesSource valueSource) {
        DoubleValuesSource singleValues = MultiDoubleValuesSource.unwrapSingleton(valueSource);
        if (singleValues != null) {
            return new ValueSourceQuery(this, fastMatchQuery, singleValues);
        }
        return new MultiValueSourceQuery(this, fastMatchQuery, valueSource);
    }

    private static class MultiValueSourceQuery
    extends Query {
        private final DoubleRange range;
        private final Query fastMatchQuery;
        private final MultiDoubleValuesSource valueSource;

        MultiValueSourceQuery(DoubleRange range, Query fastMatchQuery, MultiDoubleValuesSource valueSource) {
            this.range = range;
            this.fastMatchQuery = fastMatchQuery;
            this.valueSource = valueSource;
        }

        @Override
        public boolean equals(Object other) {
            return this.sameClassAs(other) && this.equalsTo((MultiValueSourceQuery)this.getClass().cast(other));
        }

        private boolean equalsTo(MultiValueSourceQuery other) {
            return this.range.equals(other.range) && Objects.equals(this.fastMatchQuery, other.fastMatchQuery) && this.valueSource.equals(other.valueSource);
        }

        @Override
        public int hashCode() {
            return this.classHash() + 31 * Objects.hash(this.range, this.fastMatchQuery, this.valueSource);
        }

        @Override
        public String toString(String field) {
            return "Filter(" + this.range.toString() + ")";
        }

        @Override
        public void visit(QueryVisitor visitor) {
            visitor.visitLeaf(this);
        }

        @Override
        public Query rewrite(IndexSearcher indexSearcher) throws IOException {
            Query fastMatchRewritten;
            if (this.fastMatchQuery != null && (fastMatchRewritten = this.fastMatchQuery.rewrite(indexSearcher)) != this.fastMatchQuery) {
                return new MultiValueSourceQuery(this.range, fastMatchRewritten, this.valueSource);
            }
            return super.rewrite(indexSearcher);
        }

        @Override
        public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
            final Weight fastMatchWeight = this.fastMatchQuery == null ? null : searcher.createWeight(this.fastMatchQuery, ScoreMode.COMPLETE_NO_SCORES, 1.0f);
            return new ConstantScoreWeight(this, boost){

                @Override
                public Scorer scorer(LeafReaderContext context) throws IOException {
                    DocIdSetIterator approximation;
                    int maxDoc = context.reader().maxDoc();
                    if (fastMatchWeight == null) {
                        approximation = DocIdSetIterator.all(maxDoc);
                    } else {
                        Scorer s = fastMatchWeight.scorer(context);
                        if (s == null) {
                            return null;
                        }
                        approximation = s.iterator();
                    }
                    final MultiDoubleValues values = valueSource.getValues(context);
                    TwoPhaseIterator twoPhase = new TwoPhaseIterator(approximation){

                        @Override
                        public boolean matches() throws IOException {
                            if (!values.advanceExact(this.approximation.docID())) {
                                return false;
                            }
                            int i = 0;
                            while ((long)i < values.getValueCount()) {
                                if (range.accept(values.nextValue())) {
                                    return true;
                                }
                                ++i;
                            }
                            return false;
                        }

                        @Override
                        public float matchCost() {
                            return 100.0f;
                        }
                    };
                    return new ConstantScoreScorer((Weight)this, this.score(), scoreMode, twoPhase);
                }

                @Override
                public boolean isCacheable(LeafReaderContext ctx) {
                    return valueSource.isCacheable(ctx);
                }
            };
        }
    }

    private static class ValueSourceQuery
    extends Query {
        private final DoubleRange range;
        private final Query fastMatchQuery;
        private final DoubleValuesSource valueSource;

        ValueSourceQuery(DoubleRange range, Query fastMatchQuery, DoubleValuesSource valueSource) {
            this.range = range;
            this.fastMatchQuery = fastMatchQuery;
            this.valueSource = valueSource;
        }

        @Override
        public boolean equals(Object other) {
            return this.sameClassAs(other) && this.equalsTo((ValueSourceQuery)this.getClass().cast(other));
        }

        private boolean equalsTo(ValueSourceQuery other) {
            return this.range.equals(other.range) && Objects.equals(this.fastMatchQuery, other.fastMatchQuery) && this.valueSource.equals(other.valueSource);
        }

        @Override
        public int hashCode() {
            return this.classHash() + 31 * Objects.hash(this.range, this.fastMatchQuery, this.valueSource);
        }

        @Override
        public String toString(String field) {
            return "Filter(" + this.range.toString() + ")";
        }

        @Override
        public void visit(QueryVisitor visitor) {
            visitor.visitLeaf(this);
        }

        @Override
        public Query rewrite(IndexSearcher indexSearcher) throws IOException {
            Query fastMatchRewritten;
            if (this.fastMatchQuery != null && (fastMatchRewritten = this.fastMatchQuery.rewrite(indexSearcher)) != this.fastMatchQuery) {
                return new ValueSourceQuery(this.range, fastMatchRewritten, this.valueSource);
            }
            return super.rewrite(indexSearcher);
        }

        @Override
        public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
            final Weight fastMatchWeight = this.fastMatchQuery == null ? null : searcher.createWeight(this.fastMatchQuery, ScoreMode.COMPLETE_NO_SCORES, 1.0f);
            return new ConstantScoreWeight(this, boost){

                @Override
                public Scorer scorer(LeafReaderContext context) throws IOException {
                    DocIdSetIterator approximation;
                    int maxDoc = context.reader().maxDoc();
                    if (fastMatchWeight == null) {
                        approximation = DocIdSetIterator.all(maxDoc);
                    } else {
                        Scorer s = fastMatchWeight.scorer(context);
                        if (s == null) {
                            return null;
                        }
                        approximation = s.iterator();
                    }
                    final DoubleValues values = valueSource.getValues(context, null);
                    TwoPhaseIterator twoPhase = new TwoPhaseIterator(approximation){

                        @Override
                        public boolean matches() throws IOException {
                            return values.advanceExact(this.approximation.docID()) && range.accept(values.doubleValue());
                        }

                        @Override
                        public float matchCost() {
                            return 100.0f;
                        }
                    };
                    return new ConstantScoreScorer((Weight)this, this.score(), scoreMode, twoPhase);
                }

                @Override
                public boolean isCacheable(LeafReaderContext ctx) {
                    return valueSource.isCacheable(ctx);
                }
            };
        }
    }
}

