/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.util.fst;

import guideme.internal.shaded.lucene.store.ByteBuffersDataOutput;
import guideme.internal.shaded.lucene.store.DataOutput;
import guideme.internal.shaded.lucene.util.fst.FST;
import guideme.internal.shaded.lucene.util.fst.FSTReader;
import guideme.internal.shaded.lucene.util.fst.ReverseBytesReader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;

final class ReadWriteDataOutput
extends DataOutput
implements FSTReader {
    private final ByteBuffersDataOutput dataOutput;
    private final int blockBits;
    private final int blockSize;
    private final int blockMask;
    private List<ByteBuffer> byteBuffers;
    private boolean frozen;

    public ReadWriteDataOutput(int blockBits) {
        this.dataOutput = new ByteBuffersDataOutput(blockBits, blockBits, ByteBuffersDataOutput.ALLOCATE_BB_ON_HEAP, ByteBuffersDataOutput.NO_REUSE);
        this.blockBits = blockBits;
        this.blockSize = 1 << blockBits;
        this.blockMask = this.blockSize - 1;
    }

    @Override
    public void writeByte(byte b) {
        assert (!this.frozen);
        this.dataOutput.writeByte(b);
    }

    @Override
    public void writeBytes(byte[] b, int offset, int length) {
        assert (!this.frozen);
        this.dataOutput.writeBytes(b, offset, length);
    }

    @Override
    public long ramBytesUsed() {
        return this.dataOutput.ramBytesUsed();
    }

    public void freeze() {
        this.frozen = true;
        this.byteBuffers = this.dataOutput.toWriteableBufferList();
        assert (this.byteBuffers.stream().allMatch(ByteBuffer::hasArray));
    }

    @Override
    public FST.BytesReader getReverseBytesReader() {
        assert (this.byteBuffers != null);
        if (this.byteBuffers.size() == 1) {
            return new ReverseBytesReader(this.byteBuffers.get(0).array());
        }
        return new FST.BytesReader(){
            private byte[] current;
            private int nextBuffer;
            private int nextRead;
            {
                this.current = ReadWriteDataOutput.this.byteBuffers.get(0).array();
                this.nextBuffer = -1;
            }

            @Override
            public byte readByte() {
                if (this.nextRead == -1) {
                    this.current = ReadWriteDataOutput.this.byteBuffers.get(this.nextBuffer--).array();
                    this.nextRead = ReadWriteDataOutput.this.blockSize - 1;
                }
                return this.current[this.nextRead--];
            }

            @Override
            public void skipBytes(long count) {
                this.setPosition(this.getPosition() - count);
            }

            @Override
            public void readBytes(byte[] b, int offset, int len) {
                for (int i = 0; i < len; ++i) {
                    b[offset + i] = this.readByte();
                }
            }

            @Override
            public long getPosition() {
                return ((long)this.nextBuffer + 1L) * (long)ReadWriteDataOutput.this.blockSize + (long)this.nextRead;
            }

            @Override
            public void setPosition(long pos) {
                int bufferIndex = (int)(pos >> ReadWriteDataOutput.this.blockBits);
                if (this.nextBuffer != bufferIndex - 1) {
                    this.nextBuffer = bufferIndex - 1;
                    this.current = ReadWriteDataOutput.this.byteBuffers.get(bufferIndex).array();
                }
                this.nextRead = (int)(pos & (long)ReadWriteDataOutput.this.blockMask);
                assert (this.getPosition() == pos) : "pos=" + pos + " getPos()=" + this.getPosition();
            }
        };
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        this.dataOutput.copyTo(out);
    }
}

