/*
 * Decompiled with CFR 0.152.
 */
package appeng.api.util;

import java.util.Arrays;
import java.util.List;
import net.minecraft.world.item.DyeColor;

public enum AEColor {
    WHITE("White", "gui.ae2.White", "white", DyeColor.WHITE, 0xBEBEBE, 0xDBDBDB, 0xFAFAFA, 0),
    ORANGE("Orange", "gui.ae2.Orange", "orange", DyeColor.ORANGE, 16357177, 16428612, 16047811, 0),
    MAGENTA("Magenta", "gui.ae2.Magenta", "magenta", DyeColor.MAGENTA, 8527490, 12069560, 12949704, 0),
    LIGHT_BLUE("Light Blue", "gui.ae2.LightBlue", "light_blue", DyeColor.LIGHT_BLUE, 6458827, 8563943, 14219007, 0),
    YELLOW("Yellow", "gui.ae2.Yellow", "yellow", DyeColor.YELLOW, 0xFFF7AA, 16318282, 0xFFFFE8, 0),
    LIME("Lime", "gui.ae2.Lime", "lime", DyeColor.LIME, 8191818, 12320593, 15202263, 0),
    PINK("Pink", "gui.ae2.Pink", "pink", DyeColor.PINK, 14454197, 16299479, 16244459, 0),
    GRAY("Gray", "gui.ae2.Gray", "gray", DyeColor.GRAY, 0x7C7C7C, 0xA0A0A0, 0xC9C9C9, 0),
    LIGHT_GRAY("Light Gray", "gui.ae2.LightGray", "light_gray", DyeColor.LIGHT_GRAY, 0x9D9D9D, 0xCDCDCD, 0xEFEFEF, 0),
    CYAN("Cyan", "gui.ae2.Cyan", "cyan", DyeColor.CYAN, 3120037, 5352134, 11460084, 0),
    PURPLE("Purple", "gui.ae2.Purple", "purple", DyeColor.PURPLE, 8532146, 10769358, 13083596, 0),
    BLUE("Blue", "gui.ae2.Blue", "blue", DyeColor.BLUE, 2959776, 5327615, 14542591, 0),
    BROWN("Brown", "gui.ae2.Brown", "brown", DyeColor.BROWN, 7491125, 12031615, 14734024, 0),
    GREEN("Green", "gui.ae2.Green", "green", DyeColor.GREEN, 4562977, 6349614, 14938851, 0),
    RED("Red", "gui.ae2.Red", "red", DyeColor.RED, 10813481, 16711740, 16770797, 0),
    BLACK("Black", "gui.ae2.Black", "black", DyeColor.BLACK, 0x2B2B2B, 0x565656, 0x848484, 0xFFFFFF),
    TRANSPARENT("Fluix", "gui.ae2.Fluix", "fluix", null, 1778500, 9002152, 14138348, 0);

    public static final List<AEColor> VALID_COLORS;
    public static final int TINTINDEX_DARK = 1;
    public static final int TINTINDEX_MEDIUM = 2;
    public static final int TINTINDEX_BRIGHT = 3;
    public static final int TINTINDEX_MEDIUM_BRIGHT = 4;
    public final String translationKey;
    public final int blackVariant;
    public final int mediumVariant;
    public final int whiteVariant;
    public final DyeColor dye;
    public final String registryPrefix;
    public final String englishName;
    public final int contrastTextColor;

    private AEColor(String englishName, String translationKey, String registryPrefix, DyeColor dye, int blackHex, int medHex, int whiteHex, int contrastTextColor) {
        this.englishName = englishName;
        this.translationKey = translationKey;
        this.registryPrefix = registryPrefix;
        this.blackVariant = blackHex;
        this.mediumVariant = medHex;
        this.whiteVariant = whiteHex;
        this.contrastTextColor = contrastTextColor;
        this.dye = dye;
    }

    public static AEColor fromDye(DyeColor vanillaDye) {
        for (AEColor value : AEColor.values()) {
            if (value.dye != vanillaDye) continue;
            return value;
        }
        throw new IllegalArgumentException("Unknown Vanilla dye: " + String.valueOf(vanillaDye));
    }

    public int getVariantByTintIndex(int tintIndex) {
        switch (tintIndex) {
            case 0: {
                return -1;
            }
            case 1: {
                return this.blackVariant;
            }
            case 2: {
                return this.mediumVariant;
            }
            case 3: {
                return this.whiteVariant;
            }
            case 4: {
                int light = this.whiteVariant;
                int dark = this.mediumVariant;
                return ((light >> 16 & 0xFF) + (dark >> 16 & 0xFF)) / 2 << 16 | ((light >> 8 & 0xFF) + (dark >> 8 & 0xFF)) / 2 << 8 | ((light & 0xFF) + (dark & 0xFF)) / 2;
            }
        }
        return -1;
    }

    public String getEnglishName() {
        return this.englishName;
    }

    public String toString() {
        return this.translationKey;
    }

    static {
        VALID_COLORS = Arrays.asList(WHITE, ORANGE, MAGENTA, LIGHT_BLUE, YELLOW, LIME, PINK, GRAY, LIGHT_GRAY, CYAN, PURPLE, BLUE, BROWN, GREEN, RED, BLACK);
    }
}

