/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.widgets;

import appeng.client.gui.style.Blitter;
import appeng.client.gui.widgets.ITooltip;
import appeng.core.localization.GuiText;
import appeng.menu.interfaces.IProgressProvider;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class ProgressBar
extends AbstractWidget
implements ITooltip {
    private final IProgressProvider source;
    private final Blitter blitter;
    private final Direction layout;
    private final Rect2i sourceRect;
    private final Component titleName;
    private Component fullMsg;

    public ProgressBar(IProgressProvider source, Blitter blitter, Direction dir) {
        this(source, blitter, dir, null);
    }

    public ProgressBar(IProgressProvider source, Blitter blitter, Direction dir, Component title) {
        super(0, 0, blitter.getSrcWidth(), blitter.getSrcHeight(), (Component)Component.m_237119_());
        this.source = source;
        this.blitter = blitter.copy();
        this.layout = dir;
        this.titleName = title;
        this.sourceRect = new Rect2i(blitter.getSrcX(), blitter.getSrcY(), blitter.getSrcWidth(), blitter.getSrcHeight());
    }

    public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.f_93624_) {
            int max = this.source.getMaxProgress();
            int current = this.source.getCurrentProgress();
            if (current > max) {
                current = max;
            }
            int srcX = this.sourceRect.m_110085_();
            int srcY = this.sourceRect.m_110086_();
            int srcW = this.sourceRect.m_110090_();
            int srcH = this.sourceRect.m_110091_();
            int destX = this.m_252754_();
            int destY = this.m_252907_();
            if (this.layout == Direction.VERTICAL) {
                int diff = this.f_93619_ - (max > 0 ? this.f_93619_ * current / max : 0);
                destY += diff;
                srcY += diff;
                srcH -= diff;
            } else {
                int diff = this.f_93618_ - (max > 0 ? this.f_93618_ * current / max : 0);
                srcX += diff;
                srcW -= diff;
            }
            this.blitter.src(srcX, srcY, srcW, srcH).dest(destX, destY).blit(guiGraphics);
        }
    }

    public void setFullMsg(Component msg) {
        this.fullMsg = msg;
    }

    @Override
    public List<Component> getTooltipMessage() {
        if (this.fullMsg != null) {
            return Collections.singletonList(this.fullMsg);
        }
        MutableComponent result = this.titleName != null ? this.titleName : Component.m_237119_();
        return Arrays.asList(result, Component.m_237113_((String)(this.source.getCurrentProgress() + " ")).m_7220_((Component)GuiText.Of.text().m_6881_().m_130946_(" " + this.source.getMaxProgress())));
    }

    @Override
    public Rect2i getTooltipArea() {
        return new Rect2i(this.m_252754_() - 2, this.m_252907_() - 2, this.f_93618_ + 4, this.f_93619_ + 4);
    }

    @Override
    public boolean isTooltipAreaVisible() {
        return true;
    }

    public void m_168797_(NarrationElementOutput output) {
    }

    public static enum Direction {
        HORIZONTAL,
        VERTICAL;

    }
}

