/*
 * Decompiled with CFR 0.152.
 */
package appeng.worldgen.meteorite.debug;

import appeng.worldgen.meteorite.CraterType;
import appeng.worldgen.meteorite.PlacedMeteoriteSettings;
import appeng.worldgen.meteorite.fallout.FalloutMode;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class MeteoriteSpawner {
    public PlacedMeteoriteSettings trySpawnMeteoriteAtSuitableHeight(LevelReader level, BlockPos startPos, float coreRadius, CraterType craterType, boolean pureCrater) {
        int stepSize = Math.min(5, (int)Math.ceil(coreRadius) + 1);
        int minY = 10 + stepSize;
        BlockPos.MutableBlockPos mutablePos = startPos.m_122032_();
        mutablePos.m_122175_(Direction.DOWN, stepSize);
        while (mutablePos.m_123342_() > minY) {
            PlacedMeteoriteSettings spawned = this.trySpawnMeteorite(level, (BlockPos)mutablePos, coreRadius, craterType, pureCrater);
            if (spawned != null) {
                return spawned;
            }
            mutablePos.m_142448_(mutablePos.m_123342_() - stepSize);
        }
        return null;
    }

    @Nullable
    public PlacedMeteoriteSettings trySpawnMeteorite(LevelReader level, BlockPos pos, float coreRadius, CraterType craterType, boolean pureCrater) {
        if (!this.areSurroundingsSuitable(level, pos)) {
            return null;
        }
        FalloutMode fallout = FalloutMode.fromBiome((Holder<Biome>)level.m_204166_(pos));
        boolean craterLake = false;
        return new PlacedMeteoriteSettings(pos, coreRadius, craterType, fallout, pureCrater, craterLake);
    }

    private boolean areSurroundingsSuitable(LevelReader level, BlockPos pos) {
        int realValidBlocks = 0;
        BlockPos.MutableBlockPos testPos = new BlockPos.MutableBlockPos();
        for (int i = pos.m_123341_() - 6; i < pos.m_123341_() + 6; ++i) {
            testPos.m_142451_(i);
            for (int j = pos.m_123342_() - 6; j < pos.m_123342_() + 6; ++j) {
                testPos.m_142448_(j);
                for (int k = pos.m_123343_() - 6; k < pos.m_123343_() + 6; ++k) {
                    testPos.m_142443_(k);
                    Block block = level.m_8055_((BlockPos)testPos).m_60734_();
                    ++realValidBlocks;
                }
            }
        }
        int validBlocks = 0;
        for (int i = pos.m_123341_() - 15; i < pos.m_123341_() + 15; ++i) {
            testPos.m_142451_(i);
            for (int j = pos.m_123342_() - 15; j < pos.m_123342_() + 15; ++j) {
                testPos.m_142448_(j);
                for (int k = pos.m_123343_() - 15; k < pos.m_123343_() + 15; ++k) {
                    testPos.m_142443_(k);
                    ++validBlocks;
                }
            }
        }
        int minBlocks = 200;
        return validBlocks > 200 && realValidBlocks > 80;
    }
}

